/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;

public class BookmarksIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};
    public static final String PORTLET_ID = "28";

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String url = document.get("url");
        String entryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/bookmarks/view_entry");
        portletURL.setParameter("entryId", entryId);
        return new Summary(title, url, portletURL);
    }

    protected void checkSearchFolderId(long folderId, SearchContext searchContext) throws Exception {
        if (folderId == 0L) {
            return;
        }
        BookmarksFolderServiceUtil.getFolder((long)folderId);
    }

    protected void doDelete(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, entry.getEntryId());
        SearchEngineUtil.deleteDocument((long)entry.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        long companyId = entry.getCompanyId();
        long groupId = this.getParentGroupId(entry.getGroupId());
        long scopeGroupId = entry.getGroupId();
        long userId = entry.getUserId();
        long folderId = entry.getFolderId();
        long entryId = entry.getEntryId();
        String name = entry.getName();
        String url = entry.getUrl();
        String comments = entry.getComments();
        Date modifiedDate = entry.getModifiedDate();
        long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)BookmarksEntry.class.getName(), (long)entryId);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)BookmarksEntry.class.getName(), (long)entryId);
        ExpandoBridge expandoBridge = entry.getExpandoBridge();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, entryId);
        document.addModifiedDate(modifiedDate);
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("groupId", groupId);
        document.addKeyword("scopeGroupId", scopeGroupId);
        document.addKeyword("userId", userId);
        document.addText("title", name);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        document.addKeyword("assetTagNames", assetTagNames);
        document.addKeyword("folderId", folderId);
        document.addKeyword("entryClassName", BookmarksEntry.class.getName());
        document.addKeyword("entryClassPK", entryId);
        document.addText("url", url);
        document.addText("comments", comments);
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        Document document = this.getDocument(entry);
        SearchEngineUtil.updateDocument((long)entry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
        this.reindexRoot(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEntries(long companyId, long groupId, long folderId, int entryStart, int entryEnd) throws Exception {
        List entries = BookmarksEntryLocalServiceUtil.getEntries((long)groupId, (long)folderId, (int)entryStart, (int)entryEnd);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (BookmarksEntry entry : entries) {
            Document document = this.getDocument(entry);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }

    protected void reindexFolders(long companyId) throws Exception {
        int folderCount = BookmarksFolderLocalServiceUtil.getCompanyFoldersCount((long)companyId);
        int folderPages = folderCount / 1000;
        int i = 0;
        while (i <= folderPages) {
            int folderStart = i * 1000;
            int folderEnd = folderStart + 1000;
            this.reindexFolders(companyId, folderStart, folderEnd);
            ++i;
        }
    }

    protected void reindexFolders(long companyId, int folderStart, int folderEnd) throws Exception {
        List folders = BookmarksFolderLocalServiceUtil.getCompanyFolders((long)companyId, (int)folderStart, (int)folderEnd);
        for (BookmarksFolder folder : folders) {
            long groupId = folder.getGroupId();
            long folderId = folder.getFolderId();
            int entryCount = BookmarksEntryLocalServiceUtil.getEntriesCount((long)groupId, (long)folderId);
            int entryPages = entryCount / 1000;
            int i = 0;
            while (i <= entryPages) {
                int entryStart = i * 1000;
                int entryEnd = entryStart + 1000;
                this.reindexEntries(companyId, groupId, folderId, entryStart, entryEnd);
                ++i;
            }
        }
    }

    protected void reindexRoot(long companyId) throws Exception {
        int groupCount = GroupLocalServiceUtil.getCompanyGroupsCount((long)companyId);
        int groupPages = groupCount / 1000;
        int i = 0;
        while (i <= groupPages) {
            int groupStart = i * 1000;
            int groupEnd = groupStart + 1000;
            this.reindexRoot(companyId, groupStart, groupEnd);
            ++i;
        }
    }

    protected void reindexRoot(long companyId, int groupStart, int groupEnd) throws Exception {
        List groups = GroupLocalServiceUtil.getCompanyGroups((long)companyId, (int)groupStart, (int)groupEnd);
        for (Group group : groups) {
            long groupId = group.getGroupId();
            long folderId = 0L;
            int entryCount = BookmarksEntryLocalServiceUtil.getEntriesCount((long)groupId, (long)folderId);
            int entryPages = entryCount / 1000;
            int i = 0;
            while (i <= entryPages) {
                int entryStart = i * 1000;
                int entryEnd = entryStart + 1000;
                this.reindexEntries(companyId, groupId, folderId, entryStart, entryEnd);
                ++i;
            }
        }
    }
}

