/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.base.BlogsEntryServiceBaseImpl;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.blogs.service.permission.BlogsPermission;
import com.liferay.portlet.blogs.util.comparator.EntryDisplayDateComparator;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsEntryServiceImpl
extends BlogsEntryServiceBaseImpl {
    private static final int _RSS_ABSTRACT_LENGTH = GetterUtil.getInteger((String)PropsUtil.get("blogs.rss.abstract.length"));

    public BlogsEntry addEntry(String title, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        BlogsPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_ENTRY");
        return this.blogsEntryLocalService.addEntry(this.getUserId(), title, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, serviceContext);
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        BlogsEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.blogsEntryLocalService.deleteEntry(entryId);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, int status, int max) throws PortalException, SystemException {
        ArrayList<BlogsEntry> entries = new ArrayList<BlogsEntry>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        while (entries.size() < max && listNotExhausted) {
            List entryList = this.blogsEntryLocalService.getCompanyEntries(companyId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)new EntryDisplayDateComparator());
            Iterator itr = entryList.iterator();
            lastIntervalStart += max;
            listNotExhausted = entryList.size() == max;
            while (itr.hasNext() && entries.size() < max) {
                BlogsEntry entry = (BlogsEntry)itr.next();
                if (!BlogsEntryPermission.contains(this.getPermissionChecker(), entry, "VIEW")) continue;
                entries.add(entry);
            }
        }
        return entries;
    }

    public String getCompanyEntriesRSS(long companyId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        String description = name = company.getName();
        List<BlogsEntry> blogsEntries = this.getCompanyEntries(companyId, status, max);
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, blogsEntries, themeDisplay);
    }

    public BlogsEntry getEntry(long entryId) throws PortalException, SystemException {
        BlogsEntryPermission.check(this.getPermissionChecker(), entryId, "VIEW");
        return this.blogsEntryLocalService.getEntry(entryId);
    }

    public BlogsEntry getEntry(long groupId, String urlTitle) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryLocalService.getEntry(groupId, urlTitle);
        BlogsEntryPermission.check(this.getPermissionChecker(), entry.getEntryId(), "VIEW");
        return entry;
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int status, int max) throws PortalException, SystemException {
        ArrayList<BlogsEntry> entries = new ArrayList<BlogsEntry>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        while (entries.size() < max && listNotExhausted) {
            List entryList = this.blogsEntryLocalService.getGroupEntries(groupId, status, lastIntervalStart, lastIntervalStart + max);
            Iterator itr = entryList.iterator();
            lastIntervalStart += max;
            listNotExhausted = entryList.size() == max;
            while (itr.hasNext() && entries.size() < max) {
                BlogsEntry entry = (BlogsEntry)itr.next();
                if (!BlogsEntryPermission.contains(this.getPermissionChecker(), entry, "VIEW")) continue;
                entries.add(entry);
            }
        }
        return entries;
    }

    public String getGroupEntriesRSS(long groupId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name;
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        String description = name = HtmlUtil.escape((String)group.getDescriptiveName());
        List<BlogsEntry> blogsEntries = this.getGroupEntries(groupId, status, max);
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, blogsEntries, themeDisplay);
    }

    public List<BlogsEntry> getGroupsEntries(long companyId, long groupId, int status, int max) throws PortalException, SystemException {
        ArrayList<BlogsEntry> entries = new ArrayList<BlogsEntry>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        while (entries.size() < max && listNotExhausted) {
            List entryList = this.blogsEntryLocalService.getGroupsEntries(companyId, groupId, status, lastIntervalStart, lastIntervalStart + max);
            Iterator itr = entryList.iterator();
            lastIntervalStart += max;
            listNotExhausted = entryList.size() == max;
            while (itr.hasNext() && entries.size() < max) {
                BlogsEntry entry = (BlogsEntry)itr.next();
                if (!BlogsEntryPermission.contains(this.getPermissionChecker(), entry, "VIEW")) continue;
                entries.add(entry);
            }
        }
        return entries;
    }

    public List<BlogsEntry> getOrganizationEntries(long organizationId, int status, int max) throws PortalException, SystemException {
        ArrayList<BlogsEntry> entries = new ArrayList<BlogsEntry>();
        Date displayDate = new Date();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        while (entries.size() < max && listNotExhausted) {
            List entryList = this.blogsEntryFinder.findByOrganizationId(organizationId, displayDate, status, lastIntervalStart, lastIntervalStart + max);
            Iterator itr = entryList.iterator();
            lastIntervalStart += max;
            listNotExhausted = entryList.size() == max;
            while (itr.hasNext() && entries.size() < max) {
                BlogsEntry entry = (BlogsEntry)itr.next();
                if (!BlogsEntryPermission.contains(this.getPermissionChecker(), entry, "VIEW")) continue;
                entries.add(entry);
            }
        }
        return entries;
    }

    public String getOrganizationEntriesRSS(long organizationId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        String name;
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        String description = name = organization.getName();
        List<BlogsEntry> blogsEntries = this.getOrganizationEntries(organizationId, status, max);
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, blogsEntries, themeDisplay);
    }

    public BlogsEntry updateEntry(long entryId, String title, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        BlogsEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.blogsEntryLocalService.updateEntry(this.getUserId(), entryId, title, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, serviceContext);
    }

    protected String exportToRSS(String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, List<BlogsEntry> blogsEntries, ThemeDisplay themeDisplay) throws SystemException {
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        syndFeed.setTitle(name);
        syndFeed.setLink(feedURL);
        syndFeed.setDescription(description);
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(entries);
        for (BlogsEntry entry : blogsEntries) {
            String author = HtmlUtil.escape((String)PortalUtil.getUserName((long)entry.getUserId(), (String)entry.getUserName()));
            StringBundler link = new StringBundler(4);
            if (entryURL.endsWith("/blogs/rss")) {
                link.append(entryURL.substring(0, entryURL.length() - 3));
                link.append(entry.getUrlTitle());
            } else {
                link.append(entryURL);
                if (!entryURL.endsWith("?")) {
                    link.append("&");
                }
                link.append("entryId=");
                link.append(entry.getEntryId());
            }
            String value = null;
            value = displayStyle.equals("abstract") ? StringUtil.shorten((String)HtmlUtil.extractText((String)entry.getContent()), (int)_RSS_ABSTRACT_LENGTH, (String)"") : (displayStyle.equals("title") ? "" : StringUtil.replace((String)entry.getContent(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + themeDisplay.getURLPortal() + "/", "src=\"" + themeDisplay.getURLPortal() + "/"}));
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            syndEntry.setAuthor(author);
            syndEntry.setTitle(entry.getTitle());
            syndEntry.setLink(link.toString());
            syndEntry.setUri(syndEntry.getLink());
            syndEntry.setPublishedDate(entry.getCreateDate());
            syndEntry.setUpdatedDate(entry.getModifiedDate());
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            syndContent.setValue(value);
            syndEntry.setDescription((SyndContent)syndContent);
            entries.add(syndEntry);
        }
        try {
            return RSSUtil.export((SyndFeed)syndFeed);
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
    }
}

