/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.NoSuchCategoryException;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryProperty;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagProperty;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagPropertyLocalServiceUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetUtil {
    public static char[] INVALID_CHARACTERS = new char[]{'&', '\'', '@', '\\', ']', '}', ':', ',', '=', '>', '/', '<', '\n', '[', '{', '%', '|', '+', '#', '?', '\"', '\r', ';', '/', '*', '~'};
    private static Log _log = LogFactoryUtil.getLog(AssetUtil.class);

    public static Set<String> addLayoutTags(HttpServletRequest request, List<AssetTag> tags) {
        Set<String> layoutTags = AssetUtil.getLayoutTagNames(request);
        for (AssetTag tag : tags) {
            layoutTags.add(tag.getName());
        }
        return layoutTags;
    }

    public static void addPortletBreadcrumbEntries(long assetCategoryId, HttpServletRequest request, PortletURL portletURL) throws Exception {
        AssetCategory assetCategory = AssetCategoryLocalServiceUtil.getCategory((long)assetCategoryId);
        List ancestorCategories = assetCategory.getAncestors();
        Collections.reverse(ancestorCategories);
        for (AssetCategory ancestorCategory : ancestorCategories) {
            portletURL.setParameter("categoryId", String.valueOf(ancestorCategory.getCategoryId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorCategory.getName(), (String)portletURL.toString());
        }
        portletURL.setParameter("categoryId", String.valueOf(assetCategoryId));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)assetCategory.getName(), (String)portletURL.toString());
    }

    public static String getAssetKeywords(String className, long classPK) throws SystemException {
        List tags = AssetTagLocalServiceUtil.getTags((String)className, (long)classPK);
        List categories = AssetCategoryLocalServiceUtil.getCategories((String)className, (long)classPK);
        StringBuffer sb = new StringBuffer();
        sb.append(ListUtil.toString((List)tags, (String)"name"));
        if (!tags.isEmpty()) {
            sb.append(",");
        }
        sb.append(ListUtil.toString((List)categories, (String)"name"));
        return sb.toString();
    }

    public static Set<String> getLayoutTagNames(HttpServletRequest request) {
        HashSet tagNames = (HashSet)request.getAttribute("ASSET_LAYOUT_TAG_NAMES");
        if (tagNames == null) {
            tagNames = new HashSet();
            request.setAttribute("ASSET_LAYOUT_TAG_NAMES", tagNames);
        }
        return tagNames;
    }

    public static boolean isValidWord(String word) {
        char[] wordCharArray;
        if (Validator.isNull((String)word)) {
            return false;
        }
        char[] cArray = wordCharArray = word.toCharArray();
        int n = wordCharArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            char[] cArray2 = INVALID_CHARACTERS;
            int n3 = INVALID_CHARACTERS.length;
            int n4 = 0;
            while (n4 < n3) {
                char invalidChar = cArray2[n4];
                if (c == invalidChar) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Word " + word + " is not valid because " + c + " is not allowed"));
                    }
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public static String substituteCategoryPropertyVariables(long groupId, long categoryId, String s) throws PortalException, SystemException {
        String result = s;
        AssetCategory category = null;
        if (categoryId > 0L) {
            try {
                category = AssetCategoryLocalServiceUtil.getCategory((long)categoryId);
            }
            catch (NoSuchCategoryException noSuchCategoryException) {}
        }
        if (category != null) {
            List categoryProperties = AssetCategoryPropertyLocalServiceUtil.getCategoryProperties((long)categoryId);
            for (AssetCategoryProperty categoryProperty : categoryProperties) {
                result = StringUtil.replace((String)result, (String)("[$" + categoryProperty.getKey() + "$]"), (String)categoryProperty.getValue());
            }
        }
        return StringUtil.stripBetween((String)result, (String)"[$", (String)"$]");
    }

    public static String substituteTagPropertyVariables(long groupId, String tagName, String s) throws PortalException, SystemException {
        String result = s;
        AssetTag tag = null;
        if (tagName != null) {
            try {
                tag = AssetTagLocalServiceUtil.getTag((long)groupId, (String)tagName);
            }
            catch (NoSuchTagException noSuchTagException) {}
        }
        if (tag != null) {
            List tagProperties = AssetTagPropertyLocalServiceUtil.getTagProperties((long)tag.getTagId());
            for (AssetTagProperty tagProperty : tagProperties) {
                result = StringUtil.replace((String)result, (String)("[$" + tagProperty.getKey() + "$]"), (String)tagProperty.getValue());
            }
        }
        return StringUtil.stripBetween((String)result, (String)"[$", (String)"$]");
    }

    public static String toWord(String text) {
        if (Validator.isNull((String)text)) {
            return text;
        }
        char[] textCharArray = text.toCharArray();
        int i = 0;
        while (i < textCharArray.length) {
            char c = textCharArray[i];
            char[] cArray = INVALID_CHARACTERS;
            int n = INVALID_CHARACTERS.length;
            int n2 = 0;
            while (n2 < n) {
                char invalidChar = cArray[n2];
                if (c == invalidChar) {
                    textCharArray[i] = 32;
                    break;
                }
                ++n2;
            }
            ++i;
        }
        return new String(textCharArray);
    }
}

