/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.impl.AssetEntryImpl;
import com.liferay.portlet.asset.service.persistence.AssetEntryFinder;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetEntryFinderImpl
extends BasePersistenceImpl<AssetEntry>
implements AssetEntryFinder {
    public static String FIND_BY_AND_CATEGORY_IDS = String.valueOf(AssetEntryFinder.class.getName()) + ".findByAndCategoryIds";
    public static String FIND_BY_AND_CATEGORY_IDS_TREE = String.valueOf(AssetEntryFinder.class.getName()) + ".findByAndCategoryIdsTree";
    public static String FIND_BY_AND_TAG_IDS = String.valueOf(AssetEntryFinder.class.getName()) + ".findByAndTagIds";

    public int countEntries(AssetEntryQuery entryQuery) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            SQLQuery q = this.buildAssetQuerySQL(entryQuery, true, session);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AssetEntry> findEntries(AssetEntryQuery entryQuery) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = this.buildAssetQuerySQL(entryQuery, false, session);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)entryQuery.getStart(), (int)entryQuery.getEnd());
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected void buildAllCategoriesSQL(String sqlId, long[] categoryIds, StringBundler sb) {
        sb.append(" AND AssetEntry.entryId IN (");
        int i = 0;
        while (i < categoryIds.length) {
            sb.append(CustomSQLUtil.get((String)sqlId));
            if (i + 1 < categoryIds.length) {
                sb.append(" AND AssetEntry.entryId IN (");
            }
            ++i;
        }
        i = 0;
        while (i < categoryIds.length) {
            if (i + 1 < categoryIds.length) {
                sb.append(")");
            }
            ++i;
        }
        sb.append(")");
    }

    protected void buildAllTagsSQL(long[] tagIds, StringBundler sb) {
        sb.append(" AND AssetEntry.entryId IN (");
        int i = 0;
        while (i < tagIds.length) {
            sb.append(CustomSQLUtil.get((String)FIND_BY_AND_TAG_IDS));
            if (i + 1 < tagIds.length) {
                sb.append(" AND AssetEntry.entryId IN (");
            }
            ++i;
        }
        i = 0;
        while (i < tagIds.length) {
            if (i + 1 < tagIds.length) {
                sb.append(")");
            }
            ++i;
        }
        sb.append(")");
    }

    protected SQLQuery buildAssetQuerySQL(AssetEntryQuery entryQuery, boolean count, Session session) {
        String where;
        StringBundler sb = new StringBundler();
        if (count) {
            sb.append("SELECT COUNT(AssetEntry.entryId) AS COUNT_VALUE ");
        } else {
            sb.append("SELECT DISTINCT {AssetEntry.*} ");
        }
        sb.append("FROM AssetEntry ");
        if (entryQuery.getAnyTagIds().length > 0) {
            sb.append("INNER JOIN ");
            sb.append("AssetEntries_AssetTags ON ");
            sb.append("(AssetEntries_AssetTags.entryId = ");
            sb.append("AssetEntry.entryId) ");
            sb.append("INNER JOIN ");
            sb.append("AssetTag ON ");
            sb.append("(AssetTag.tagId = AssetEntries_AssetTags.tagId) ");
        }
        if (entryQuery.getAnyCategoryIds().length > 0) {
            sb.append("INNER JOIN ");
            sb.append("AssetEntries_AssetCategories ON ");
            sb.append("(AssetEntries_AssetCategories.entryId = ");
            sb.append("AssetEntry.entryId) ");
            sb.append("INNER JOIN ");
            sb.append("AssetCategory ON ");
            sb.append("(AssetCategory.categoryId = ");
            sb.append("AssetEntries_AssetCategories.categoryId) ");
        }
        sb.append("WHERE ");
        int whereIndex = sb.index();
        if (entryQuery.isVisible() != null) {
            sb.append(" AND (visible = ?)");
        }
        if (entryQuery.isExcludeZeroViewCount()) {
            sb.append(" AND (AssetEntry.viewCount > 0)");
        }
        if (entryQuery.getAllCategoryIds().length > 0) {
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                this.buildAllCategoriesSQL(FIND_BY_AND_CATEGORY_IDS_TREE, entryQuery.getAllCategoryIds(), sb);
            } else {
                this.buildAllCategoriesSQL(FIND_BY_AND_CATEGORY_IDS, entryQuery.getAllCategoryIds(), sb);
            }
        }
        if (entryQuery.getAnyCategoryIds().length > 0) {
            sb.append(" AND (");
            sb.append(this.getCategoryIds(entryQuery.getAnyCategoryIds(), "="));
            sb.append(") ");
        }
        if (entryQuery.getNotAllCategoryIds().length > 0) {
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                this.buildNotAnyCategoriesSQL(FIND_BY_AND_CATEGORY_IDS_TREE, entryQuery.getNotAllCategoryIds(), sb);
            } else {
                this.buildNotAnyCategoriesSQL(FIND_BY_AND_CATEGORY_IDS, entryQuery.getNotAllCategoryIds(), sb);
            }
        }
        if (entryQuery.getNotAnyCategoryIds().length > 0) {
            sb.append(" AND (");
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                sb.append(this.getNotCategoryIds(FIND_BY_AND_CATEGORY_IDS_TREE, entryQuery.getNotAnyCategoryIds()));
            } else {
                sb.append(this.getNotCategoryIds(FIND_BY_AND_CATEGORY_IDS, entryQuery.getNotAnyCategoryIds()));
            }
            sb.append(") ");
        }
        if (entryQuery.getAllTagIds().length > 0) {
            this.buildAllTagsSQL(entryQuery.getAllTagIds(), sb);
        }
        if (entryQuery.getAnyTagIds().length > 0) {
            sb.append(" AND (");
            sb.append(this.getTagIds(entryQuery.getAnyTagIds(), "="));
            sb.append(") ");
        }
        if (entryQuery.getNotAllTagIds().length > 0) {
            this.buildNotAnyTagsSQL(entryQuery.getNotAllTagIds(), sb);
        }
        if (entryQuery.getNotAnyTagIds().length > 0) {
            sb.append(" AND (");
            sb.append(this.getNotTagIds(entryQuery.getNotAnyTagIds()));
            sb.append(") ");
        }
        int datesIndex = sb.index();
        sb.append("[$DATES$]");
        sb.append(this.getGroupIds(entryQuery.getGroupIds()));
        sb.append(this.getClassNameIds(entryQuery.getClassNameIds()));
        if (!count) {
            sb.append(" ORDER BY AssetEntry.");
            sb.append(entryQuery.getOrderByCol1());
            sb.append(" ");
            sb.append(entryQuery.getOrderByType1());
            if (Validator.isNotNull((String)entryQuery.getOrderByCol2()) && !entryQuery.getOrderByCol1().equals(entryQuery.getOrderByCol2())) {
                sb.append(", AssetEntry.");
                sb.append(entryQuery.getOrderByCol2());
                sb.append(" ");
                sb.append(entryQuery.getOrderByType2());
            }
        }
        sb.setStringAt(this.getDates(entryQuery.getPublishDate(), entryQuery.getExpirationDate()), datesIndex);
        if (sb.index() > whereIndex && (where = sb.stringAt(whereIndex)).startsWith(" AND")) {
            sb.setStringAt(where.substring(4), whereIndex);
        }
        String sql = sb.toString();
        SQLQuery q = session.createSQLQuery(sql);
        if (count) {
            q.addScalar("COUNT_VALUE", Type.LONG);
        } else {
            q.addEntity("AssetEntry", AssetEntryImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (entryQuery.isVisible() != null) {
            qPos.add(entryQuery.isVisible().booleanValue());
        }
        if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
            qPos.add(entryQuery.getAllLeftAndRightCategoryIds());
            qPos.add(entryQuery.getAnyLeftAndRightCategoryIds());
            qPos.add(entryQuery.getNotAllLeftAndRightCategoryIds());
            qPos.add(entryQuery.getNotAnyLeftAndRightCategoryIds());
        } else {
            qPos.add(entryQuery.getAllCategoryIds());
            qPos.add(entryQuery.getAnyCategoryIds());
            qPos.add(entryQuery.getNotAllCategoryIds());
            qPos.add(entryQuery.getNotAnyCategoryIds());
        }
        qPos.add(entryQuery.getAllTagIds());
        qPos.add(entryQuery.getAnyTagIds());
        qPos.add(entryQuery.getNotAllTagIds());
        qPos.add(entryQuery.getNotAnyTagIds());
        this.setDates(qPos, entryQuery.getPublishDate(), entryQuery.getExpirationDate());
        qPos.add(entryQuery.getGroupIds());
        qPos.add(entryQuery.getClassNameIds());
        return q;
    }

    protected void buildNotAnyCategoriesSQL(String sqlId, long[] categoryIds, StringBundler sb) {
        sb.append(" AND (");
        int i = 0;
        while (i < categoryIds.length) {
            sb.append("AssetEntry.entryId NOT IN (");
            sb.append(CustomSQLUtil.get((String)sqlId));
            sb.append(")");
            if (i + 1 < categoryIds.length) {
                sb.append(" OR ");
            }
            ++i;
        }
        sb.append(")");
    }

    protected void buildNotAnyTagsSQL(long[] tagIds, StringBundler sb) {
        sb.append(" AND (");
        int i = 0;
        while (i < tagIds.length) {
            sb.append("AssetEntry.entryId NOT IN (");
            sb.append(CustomSQLUtil.get((String)FIND_BY_AND_TAG_IDS));
            sb.append(")");
            if (i + 1 < tagIds.length) {
                sb.append(" OR ");
            }
            ++i;
        }
        sb.append(")");
    }

    protected String getCategoryIds(long[] categoryIds, String operator) {
        StringBundler sb = new StringBundler();
        int i = 0;
        while (i < categoryIds.length) {
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                sb.append("AssetCategory.leftCategoryId BETWEEN ? AND ?");
            } else {
                sb.append("AssetCategory.categoryId ");
                sb.append(operator);
                sb.append(" ?");
            }
            if (i + 1 != categoryIds.length) {
                sb.append(" OR ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected String getClassNameIds(long[] classNameIds) {
        if (classNameIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(classNameIds.length + 2);
        sb.append(" AND (classNameId = ?");
        int i = 1;
        while (i < classNameIds.length) {
            sb.append(" OR classNameId = ? ");
            ++i;
        }
        sb.append(") ");
        return sb.toString();
    }

    protected String getDates(Date publishDate, Date expirationDate) {
        StringBundler sb = new StringBundler(2);
        if (publishDate != null) {
            sb.append(" AND (publishDate IS NULL OR publishDate < ?)");
        }
        if (expirationDate != null) {
            sb.append(" AND (expirationDate IS NULL OR expirationDate > ?)");
        }
        return sb.toString();
    }

    protected String getGroupIds(long[] groupIds) {
        if (groupIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(groupIds.length + 2);
        sb.append(" AND (AssetEntry.groupId = ? ");
        int i = 1;
        while (i < groupIds.length) {
            sb.append(" OR AssetEntry.groupId = ? ");
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getNotCategoryIds(String sqlId, long[] notCategoryIds) {
        if (notCategoryIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(notCategoryIds.length * 4 - 1);
        int i = 0;
        while (i < notCategoryIds.length) {
            sb.append("AssetEntry.entryId NOT IN (");
            sb.append(CustomSQLUtil.get((String)sqlId));
            sb.append(")");
            if (i + 1 < notCategoryIds.length) {
                sb.append(" AND ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected String getNotTagIds(long[] notTagIds) {
        if (notTagIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(notTagIds.length * 4 - 1);
        int i = 0;
        while (i < notTagIds.length) {
            sb.append("AssetEntry.entryId NOT IN (");
            sb.append(CustomSQLUtil.get((String)FIND_BY_AND_TAG_IDS));
            sb.append(")");
            if (i + 1 < notTagIds.length) {
                sb.append(" AND ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected String getTagIds(long[] tagIds, String operator) {
        StringBundler sb = new StringBundler(tagIds.length * 4 - 1);
        int i = 0;
        while (i < tagIds.length) {
            sb.append("AssetTag.tagId ");
            sb.append(operator);
            sb.append(" ? ");
            if (i + 1 != tagIds.length) {
                sb.append("OR ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected void setDates(QueryPos qPos, Date publishDate, Date expirationDate) {
        if (publishDate != null) {
            Timestamp publishDate_TS = CalendarUtil.getTimestamp((Date)publishDate);
            qPos.add(publishDate_TS);
        }
        if (expirationDate != null) {
            Timestamp expirationDate_TS = CalendarUtil.getTimestamp((Date)expirationDate);
            qPos.add(expirationDate_TS);
        }
    }
}

