/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.base.AssetVocabularyServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetPermission;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetVocabularyServiceImpl
extends AssetVocabularyServiceBaseImpl {
    public AssetVocabulary addVocabulary(Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(this.getUserId(), titleMap, descriptionMap, settings, serviceContext);
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException, SystemException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "DELETE");
        this.assetVocabularyLocalService.deleteVocabulary(vocabularyId);
    }

    public List<AssetVocabulary> getCompanyVocabularies(long companyId) throws PortalException, SystemException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getCompanyVocabularies(companyId));
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds) throws PortalException, SystemException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getGroupsVocabularies(groupIds));
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId) throws PortalException, SystemException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getGroupVocabularies(groupId));
    }

    public AssetVocabulary getVocabulary(long vocabularyId) throws PortalException, SystemException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "VIEW");
        return this.assetVocabularyLocalService.getVocabulary(vocabularyId);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "UPDATE");
        return this.assetVocabularyLocalService.updateVocabulary(vocabularyId, titleMap, descriptionMap, settings, serviceContext);
    }

    protected List<AssetVocabulary> filterVocabularies(List<AssetVocabulary> vocabularies) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        vocabularies = ListUtil.copy(vocabularies);
        Iterator itr = vocabularies.iterator();
        while (itr.hasNext()) {
            AssetVocabulary vocabulary = (AssetVocabulary)itr.next();
            if (AssetVocabularyPermission.contains(permissionChecker, vocabulary, "VIEW")) continue;
            itr.remove();
        }
        return vocabularies;
    }
}

