/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.service.base.AssetLinkLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetLinkLocalServiceImpl
extends AssetLinkLocalServiceBaseImpl {
    public AssetLink addLink(long userId, long entryId1, long entryId2, int type, int weight) throws PortalException, SystemException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        long linkId = this.counterLocalService.increment();
        AssetLink link = this.assetLinkPersistence.create(linkId);
        link.setCompanyId(user.getCompanyId());
        link.setUserId(user.getUserId());
        link.setUserName(user.getFullName());
        link.setCreateDate(now);
        link.setEntryId1(entryId1);
        link.setEntryId2(entryId2);
        link.setType(type);
        link.setWeight(weight);
        this.assetLinkPersistence.update((BaseModel)link, false);
        return link;
    }

    public void deleteLink(long linkId) throws PortalException, SystemException {
        this.assetLinkPersistence.remove(linkId);
    }

    public void deleteLinks(long entryId) throws SystemException {
        this.assetLinkPersistence.removeByE1(entryId);
        this.assetLinkPersistence.removeByE2(entryId);
    }

    public void deleteLinks(long entryId1, long entryId2) throws SystemException {
        this.assetLinkPersistence.removeByE_E(entryId1, entryId2);
    }

    public List<AssetLink> getLinks(long entryId, int typeId) throws SystemException {
        return this.assetLinkPersistence.findByE1_T(entryId, typeId);
    }

    public List<AssetLink> getReverseLinks(long entryId, int typeId) throws SystemException {
        return this.assetLinkPersistence.findByE2_T(entryId, typeId);
    }
}

