/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetEntryDisplay;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.base.AssetEntryLocalServiceBaseImpl;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.asset.util.AssetEntryValidator;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.wiki.model.WikiPage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetEntryLocalServiceImpl
extends AssetEntryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(AssetEntryLocalServiceImpl.class);

    public void deleteEntry(AssetEntry entry) throws PortalException, SystemException {
        List tags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
        this.assetEntryPersistence.remove((BaseModel)entry);
        this.assetLinkLocalService.deleteLinks(entry.getEntryId());
        for (AssetTag tag : tags) {
            this.assetTagLocalService.decrementAssetCount(tag.getTagId(), entry.getClassNameId());
        }
        this.socialEquityLogLocalService.deactivateEquityLogs(entry.getEntryId());
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        AssetEntry entry = this.assetEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public void deleteEntry(String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry != null) {
            this.deleteEntry(entry);
        }
    }

    public List<AssetEntry> getAncestorEntries(long entryId) throws PortalException, SystemException {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        AssetEntry parentEntry = this.getParentEntry(entryId);
        while (parentEntry != null) {
            entries.add(parentEntry);
            parentEntry = this.getParentEntry(parentEntry.getEntryId());
        }
        return entries;
    }

    public List<AssetEntry> getChildEntries(long entryId) throws PortalException, SystemException {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        List links = this.assetLinkLocalService.getLinks(entryId, 1);
        for (AssetLink link : links) {
            AssetEntry curAsset = this.getEntry(link.getEntryId2());
            entries.add(curAsset);
        }
        return entries;
    }

    public List<AssetEntry> getCompanyEntries(long companyId, int start, int end) throws SystemException {
        return this.assetEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyEntriesCount(long companyId) throws SystemException {
        return this.assetEntryPersistence.countByCompanyId(companyId);
    }

    public AssetEntryDisplay[] getCompanyEntryDisplays(long companyId, int start, int end, String languageId) throws SystemException {
        return this.getEntryDisplays(this.getCompanyEntries(companyId, start, end), languageId);
    }

    public List<AssetEntry> getEntries(AssetEntryQuery entryQuery) throws SystemException {
        return this.assetEntryFinder.findEntries(entryQuery);
    }

    public int getEntriesCount(AssetEntryQuery entryQuery) throws SystemException {
        return this.assetEntryFinder.countEntries(entryQuery);
    }

    public AssetEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.assetEntryPersistence.findByPrimaryKey(entryId);
    }

    public AssetEntry getEntry(long groupId, String classUuid) throws PortalException, SystemException {
        return this.assetEntryPersistence.findByG_CU(groupId, classUuid);
    }

    public AssetEntry getEntry(String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.assetEntryPersistence.findByC_C(classNameId, classPK);
    }

    public AssetEntry getNextEntry(long entryId) throws PortalException, SystemException {
        try {
            this.getParentEntry(entryId);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            List<AssetEntry> childEntries = this.getChildEntries(entryId);
            if (childEntries.isEmpty()) {
                throw new NoSuchEntryException();
            }
            return childEntries.get(0);
        }
        List links = this.assetLinkLocalService.getLinks(entryId, 1);
        int i = 0;
        while (i < links.size()) {
            AssetLink link = (AssetLink)links.get(i);
            if (link.getEntryId2() == entryId) {
                if (i + 1 >= links.size()) {
                    throw new NoSuchEntryException();
                }
                AssetLink nextLink = (AssetLink)links.get(i + 1);
                return this.getEntry(nextLink.getEntryId2());
            }
            ++i;
        }
        throw new NoSuchEntryException();
    }

    public AssetEntry getParentEntry(long entryId) throws PortalException, SystemException {
        List links = this.assetLinkLocalService.getReverseLinks(entryId, 1);
        if (links.isEmpty()) {
            throw new NoSuchEntryException();
        }
        AssetLink link = (AssetLink)links.get(0);
        return this.getEntry(link.getEntryId1());
    }

    public AssetEntry getPreviousEntry(long entryId) throws PortalException, SystemException {
        this.getParentEntry(entryId);
        List links = this.assetLinkLocalService.getLinks(entryId, 1);
        int i = 0;
        while (i < links.size()) {
            AssetLink link = (AssetLink)links.get(i);
            if (link.getEntryId2() == entryId) {
                if (i == 0) {
                    throw new NoSuchEntryException();
                }
                AssetLink nextAssetLink = (AssetLink)links.get(i - 1);
                return this.getEntry(nextAssetLink.getEntryId2());
            }
            ++i;
        }
        throw new NoSuchEntryException();
    }

    public List<AssetEntry> getTopViewedEntries(String className, boolean asc, int start, int end) throws SystemException {
        return this.getTopViewedEntries(new String[]{className}, asc, start, end);
    }

    public List<AssetEntry> getTopViewedEntries(String[] className, boolean asc, int start, int end) throws SystemException {
        long[] classNameIds = new long[className.length];
        int i = 0;
        while (i < className.length) {
            classNameIds[i] = PortalUtil.getClassNameId((String)className[i]);
            ++i;
        }
        AssetEntryQuery entryQuery = new AssetEntryQuery();
        entryQuery.setClassNameIds(classNameIds);
        entryQuery.setEnd(end);
        entryQuery.setExcludeZeroViewCount(true);
        entryQuery.setOrderByCol1("viewCount");
        entryQuery.setOrderByType1(asc ? "ASC" : "DESC");
        entryQuery.setStart(start);
        return this.assetEntryFinder.findEntries(entryQuery);
    }

    public void incrementViewCounter(long userId, String className, long classPK) throws PortalException, SystemException {
        this.assetEntryLocalService.incrementViewCounter(userId, className, classPK, 1);
    }

    @BufferedIncrement(incrementClass=NumberIncrement.class)
    public void incrementViewCounter(long userId, String className, long classPK, int increment) throws PortalException, SystemException {
        if (!PropsValues.ASSET_ENTRY_INCREMENT_VIEW_COUNTER_ENABLED) {
            return;
        }
        if (classPK <= 0L) {
            return;
        }
        long classNameId = PortalUtil.getClassNameId((String)className);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry != null) {
            entry.setViewCount(entry.getViewCount() + increment);
            this.assetEntryPersistence.update((BaseModel)entry, false);
            if (userId > 0L && entry.getUserId() != userId) {
                this.socialEquityLogLocalService.addEquityLogs(userId, entry.getEntryId(), "VIEW");
            }
        }
    }

    public Hits search(long companyId, String portletId, String keywords, int start, int end) throws SystemException {
        try {
            SearchContext searchContext = new SearchContext();
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setKeywords(keywords);
            searchContext.setPortletIds(this.getPortletIds(portletId));
            searchContext.setStart(start);
            Indexer indexer = IndexerRegistryUtil.getIndexer(AssetEntry.class);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, long[] groupIds, String portletId, String userName, String title, String description, String assetCategoryIds, String assetTagNames, boolean andSearch, int start, int end) throws SystemException {
        try {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("description", description);
            attributes.put("title", title);
            attributes.put("userName", userName);
            SearchContext searchContext = new SearchContext();
            searchContext.setAndSearch(andSearch);
            searchContext.setAttributes(attributes);
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setGroupIds(groupIds);
            searchContext.setPortletIds(this.getPortletIds(portletId));
            searchContext.setStart(start);
            Indexer indexer = IndexerRegistryUtil.getIndexer(AssetEntry.class);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public AssetEntryDisplay[] searchEntryDisplays(long companyId, String portletId, String keywords, String languageId, int start, int end) throws SystemException {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        Hits hits = this.search(companyId, portletId, keywords, start, end);
        List hitsList = hits.toList();
        for (Document doc : hitsList) {
            try {
                AssetEntry entry = this.getEntry(doc);
                if (entry == null) continue;
                entries.add(entry);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)e);
            }
        }
        return this.getEntryDisplays(entries, languageId);
    }

    public int searchEntryDisplaysCount(long companyId, String portletId, String keywords, String languageId) throws SystemException {
        Hits hits = this.search(companyId, portletId, keywords, -1, -1);
        return hits.getLength();
    }

    public AssetEntry updateEntry(long userId, long groupId, String className, long classPK, long[] categoryIds, String[] tagNames) throws PortalException, SystemException {
        return this.updateEntry(userId, groupId, className, classPK, null, categoryIds, tagNames, true, null, null, null, null, null, null, null, null, null, 0, 0, null, false);
    }

    public AssetEntry updateEntry(long userId, long groupId, String className, long classPK, String classUuid, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, int height, int width, Integer priority, boolean sync) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        title = StringUtil.shorten((String)title, (int)300, (String)"");
        Date now = new Date();
        this.validate(className, categoryIds, tagNames);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry == null) {
            long entryId = this.counterLocalService.increment();
            entry = this.assetEntryPersistence.create(entryId);
            entry.setCompanyId(user.getCompanyId());
            entry.setUserId(user.getUserId());
            entry.setUserName(user.getFullName());
            entry.setCreateDate(now);
            entry.setClassNameId(classNameId);
            entry.setClassPK(classPK);
            entry.setClassUuid(classUuid);
            entry.setVisible(visible);
            entry.setPublishDate(publishDate);
            entry.setExpirationDate(expirationDate);
            if (priority == null) {
                entry.setPriority(0.0);
            }
            entry.setViewCount(0);
        }
        entry.setGroupId(groupId);
        entry.setModifiedDate(now);
        entry.setVisible(visible);
        entry.setStartDate(startDate);
        entry.setEndDate(endDate);
        entry.setPublishDate(publishDate);
        entry.setExpirationDate(expirationDate);
        entry.setMimeType(mimeType);
        entry.setTitle(title);
        entry.setDescription(description);
        entry.setSummary(summary);
        entry.setUrl(url);
        entry.setHeight(height);
        entry.setWidth(width);
        if (priority != null) {
            entry.setPriority((double)priority.intValue());
        }
        if (categoryIds != null) {
            this.assetEntryPersistence.setAssetCategories(entry.getEntryId(), categoryIds);
        }
        if (tagNames != null) {
            long parentGroupId = PortalUtil.getParentGroupId((long)groupId);
            ArrayList<AssetTag> tags = new ArrayList<AssetTag>(tagNames.length);
            String[] stringArray = tagNames;
            int n = tagNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tagName = stringArray[n2];
                AssetTag tag = null;
                try {
                    tag = this.assetTagLocalService.getTag(parentGroupId, tagName);
                }
                catch (NoSuchTagException noSuchTagException) {
                    ServiceContext serviceContext = new ServiceContext();
                    serviceContext.setAddCommunityPermissions(true);
                    serviceContext.setAddGuestPermissions(true);
                    serviceContext.setScopeGroupId(parentGroupId);
                    tag = this.assetTagLocalService.addTag(user.getUserId(), tagName, PropsValues.ASSET_TAG_PROPERTIES_DEFAULT, serviceContext);
                }
                if (tag != null) {
                    tags.add(tag);
                }
                ++n2;
            }
            List oldTags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
            this.assetEntryPersistence.setAssetTags(entry.getEntryId(), tags);
            if (entry.isNew()) {
                for (AssetTag tag : tags) {
                    this.assetTagLocalService.incrementAssetCount(tag.getTagId(), classNameId);
                }
            } else {
                for (AssetTag oldTag : oldTags) {
                    if (tags.contains(oldTag)) continue;
                    this.assetTagLocalService.decrementAssetCount(oldTag.getTagId(), classNameId);
                }
                for (AssetTag tag : tags) {
                    if (oldTags.contains(tag)) continue;
                    this.assetTagLocalService.incrementAssetCount(tag.getTagId(), classNameId);
                }
            }
        }
        this.assetEntryPersistence.update((BaseModel)entry, false);
        if (!sync) {
            return entry;
        }
        if (className.equals(BlogsEntry.class.getName())) {
            BlogsEntry blogsEntry = this.blogsEntryPersistence.findByPrimaryKey(classPK);
            blogsEntry.setTitle(title);
            this.blogsEntryPersistence.update((BaseModel)blogsEntry, false);
        } else if (className.equals(BookmarksEntry.class.getName())) {
            BookmarksEntry bookmarksEntry = this.bookmarksEntryPersistence.findByPrimaryKey(classPK);
            bookmarksEntry.setName(title);
            bookmarksEntry.setComments(description);
            bookmarksEntry.setUrl(url);
            this.bookmarksEntryPersistence.update((BaseModel)bookmarksEntry, false);
        } else if (className.equals(DLFileEntry.class.getName())) {
            DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(classPK);
            dlFileEntry.setTitle(title);
            dlFileEntry.setDescription(description);
            this.dlFileEntryPersistence.update((BaseModel)dlFileEntry, false);
        } else if (className.equals(JournalArticle.class.getName())) {
            JournalArticle journalArticle = this.journalArticlePersistence.findByPrimaryKey(classPK);
            journalArticle.setTitle(title);
            journalArticle.setDescription(description);
            this.journalArticlePersistence.update((BaseModel)journalArticle, false);
        } else if (className.equals(MBMessage.class.getName())) {
            MBMessage mbMessage = this.mbMessagePersistence.findByPrimaryKey(classPK);
            mbMessage.setSubject(title);
            this.mbMessagePersistence.update((BaseModel)mbMessage, false);
        } else if (className.equals(WikiPage.class.getName())) {
            WikiPage wikiPage = this.wikiPagePersistence.findByPrimaryKey(classPK);
            wikiPage.setTitle(title);
            this.wikiPagePersistence.update((BaseModel)wikiPage, false);
        }
        return entry;
    }

    public AssetEntry updateVisible(String className, long classPK, boolean visible) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        AssetEntry entry = this.assetEntryPersistence.findByC_C(classNameId, classPK);
        entry.setVisible(visible);
        this.assetEntryPersistence.update((BaseModel)entry, false);
        return entry;
    }

    public void validate(String className, long[] categoryIds, String[] tagNames) throws PortalException {
        AssetEntryValidator validator = (AssetEntryValidator)InstancePool.get((String)PropsValues.ASSET_ENTRY_VALIDATOR);
        validator.validate(className, categoryIds, tagNames);
    }

    protected AssetEntry getEntry(Document doc) throws PortalException, SystemException {
        String portletId = GetterUtil.getString((String)doc.get("portletId"));
        if (portletId.equals("33")) {
            long entryId = GetterUtil.getLong((String)doc.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)BlogsEntry.class.getName());
            long classPK = entryId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("28")) {
            long entryId = GetterUtil.getLong((String)doc.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)BookmarksEntry.class.getName());
            long classPK = entryId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("20")) {
            long repositoryId = GetterUtil.getLong((String)doc.get("repositoryId"));
            String name = doc.get("path");
            long groupId = 0L;
            long folderId = 0L;
            try {
                this.groupPersistence.findByPrimaryKey(repositoryId);
                groupId = repositoryId;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(repositoryId);
                groupId = folder.getGroupId();
                folderId = folder.getFolderId();
            }
            DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntry(groupId, folderId, name);
            long classNameId = PortalUtil.getClassNameId((String)DLFileEntry.class.getName());
            long classPK = fileEntry.getFileEntryId();
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("31")) {
            long imageId = GetterUtil.getLong((String)doc.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)IGImage.class.getName());
            long classPK = imageId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("15")) {
            long groupId = GetterUtil.getLong((String)doc.get("groupId"));
            String articleId = doc.get("entryClassPK");
            long articleResourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, articleId);
            long classNameId = PortalUtil.getClassNameId((String)JournalArticle.class.getName());
            long classPK = articleResourcePrimKey;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("19")) {
            long messageId = GetterUtil.getLong((String)doc.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)MBMessage.class.getName());
            long classPK = messageId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("36")) {
            long nodeId = GetterUtil.getLong((String)doc.get("entryClassPK"));
            String title = doc.get("title");
            long pageResourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(nodeId, title);
            long classNameId = PortalUtil.getClassNameId((String)WikiPage.class.getName());
            long classPK = pageResourcePrimKey;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        return null;
    }

    protected AssetEntryDisplay[] getEntryDisplays(List<AssetEntry> entries, String languageId) throws SystemException {
        AssetEntryDisplay[] entryDisplays = new AssetEntryDisplay[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            AssetEntry entry = entries.get(i);
            String className = PortalUtil.getClassName((long)entry.getClassNameId());
            String portletId = PortalUtil.getClassNamePortletId((String)className);
            String portletTitle = PortalUtil.getPortletTitle((String)portletId, (String)languageId);
            List categories = this.assetEntryPersistence.getAssetCategories(entry.getEntryId());
            String categoryIdsString = ListUtil.toString((List)categories, (String)"assetCategoryId", (String)",");
            long[] categoryIds = StringUtil.split((String)categoryIdsString, (String)",", (long)0L);
            List tags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
            String tagNames = ListUtil.toString((List)tags, (String)"name", (String)", ");
            AssetEntryDisplay entryDisplay = new AssetEntryDisplay();
            entryDisplay.setEntryId(entry.getEntryId());
            entryDisplay.setCompanyId(entry.getCompanyId());
            entryDisplay.setUserId(entry.getUserId());
            entryDisplay.setUserName(entry.getUserName());
            entryDisplay.setCreateDate(entry.getCreateDate());
            entryDisplay.setModifiedDate(entry.getModifiedDate());
            entryDisplay.setClassNameId(entry.getClassNameId());
            entryDisplay.setClassName(className);
            entryDisplay.setClassPK(entry.getClassPK());
            entryDisplay.setPortletId(portletId);
            entryDisplay.setPortletTitle(portletTitle);
            entryDisplay.setStartDate(entry.getStartDate());
            entryDisplay.setEndDate(entry.getEndDate());
            entryDisplay.setPublishDate(entry.getPublishDate());
            entryDisplay.setExpirationDate(entry.getExpirationDate());
            entryDisplay.setMimeType(entry.getMimeType());
            entryDisplay.setTitle(entry.getTitle());
            entryDisplay.setDescription(entry.getDescription());
            entryDisplay.setSummary(entry.getSummary());
            entryDisplay.setUrl(entry.getUrl());
            entryDisplay.setHeight(entry.getHeight());
            entryDisplay.setWidth(entry.getWidth());
            entryDisplay.setPriority(entry.getPriority());
            entryDisplay.setViewCount(entry.getViewCount());
            entryDisplay.setCategoryIds(categoryIds);
            entryDisplay.setTagNames(tagNames);
            entryDisplays[i] = entryDisplay;
            ++i;
        }
        return entryDisplays;
    }

    private String[] getPortletIds(String portletId) {
        if (Validator.isNotNull((String)portletId)) {
            return new String[]{portletId};
        }
        List rendererFactories = AssetRendererFactoryRegistryUtil.getAssetRendererFactories();
        String[] portletIds = new String[rendererFactories.size()];
        int i = 0;
        while (i < rendererFactories.size()) {
            AssetRendererFactory rendererFactory = (AssetRendererFactory)rendererFactories.get(i);
            portletIds[i] = rendererFactory.getPortletId();
            ++i;
        }
        return portletIds;
    }
}

