/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.base.AssetCategoryServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetCategoryServiceImpl
extends AssetCategoryServiceBaseImpl {
    public AssetCategory addCategory(long parentCategoryId, Map<Locale, String> titleMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(this.getUserId(), parentCategoryId, titleMap, vocabularyId, categoryProperties, serviceContext);
    }

    public void deleteCategory(long categoryId) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
        this.assetCategoryLocalService.deleteCategory(categoryId);
    }

    public List<AssetCategory> getCategories(String className, long classPK) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getCategories(className, classPK));
    }

    public AssetCategory getCategory(long categoryId) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        return this.assetCategoryLocalService.getCategory(categoryId);
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId, start, end, obc));
    }

    public List<AssetCategory> getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, obc));
    }

    public List<AssetCategory> getVocabularyRootCategories(long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyRootCategories(vocabularyId, start, end, obc));
    }

    public JSONArray search(long groupId, String name, String[] categoryProperties, int start, int end) throws SystemException {
        return this.assetCategoryLocalService.search(groupId, name, categoryProperties, start, end);
    }

    public AssetCategory updateCategory(long categoryId, long parentCategoryId, Map<Locale, String> titleMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.updateCategory(this.getUserId(), categoryId, parentCategoryId, titleMap, vocabularyId, categoryProperties, serviceContext);
    }

    protected List<AssetCategory> filterCategories(List<AssetCategory> categories) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        categories = ListUtil.copy(categories);
        Iterator itr = categories.iterator();
        while (itr.hasNext()) {
            AssetCategory category = (AssetCategory)itr.next();
            if (AssetCategoryPermission.contains(permissionChecker, category, "VIEW")) continue;
            itr.remove();
        }
        return categories;
    }
}

