/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.impl.AssetEntryModelImpl;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.social.model.SocialEquityAssetEntry;
import com.liferay.portlet.social.model.SocialEquityValue;
import com.liferay.portlet.social.service.persistence.SocialEquityAssetEntryUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetEntryImpl
extends AssetEntryModelImpl
implements AssetEntry {
    private AtomicReference<Double> _socialInformationEquity = null;

    public List<AssetCategory> getCategories() throws SystemException {
        return AssetCategoryLocalServiceUtil.getEntryCategories((long)this.getEntryId());
    }

    public long[] getCategoryIds() throws SystemException {
        return StringUtil.split((String)ListUtil.toString(this.getCategories(), (String)"categoryId"), (long)0L);
    }

    public double getSocialInformationEquity() {
        if (this._socialInformationEquity == null) {
            try {
                SocialEquityAssetEntry equityAssetEntry = SocialEquityAssetEntryUtil.findByAssetEntryId((long)this.getEntryId());
                SocialEquityValue socialEquityValue = new SocialEquityValue(equityAssetEntry.getInformationK(), equityAssetEntry.getInformationB());
                this._socialInformationEquity = new AtomicReference<Double>(socialEquityValue.getValue());
            }
            catch (PortalException portalException) {
                return 0.0;
            }
            catch (SystemException systemException) {
                return 0.0;
            }
        }
        return this._socialInformationEquity.get();
    }

    public String[] getTagNames() throws SystemException {
        return StringUtil.split((String)ListUtil.toString(this.getTags(), (String)"name"));
    }

    public List<AssetTag> getTags() throws SystemException {
        return AssetTagLocalServiceUtil.getEntryTags((long)this.getEntryId());
    }

    public void updateSocialInformationEquity(double value) {
        if (this._socialInformationEquity != null) {
            double currentValue = 0.0;
            double newValue = 0.0;
            do {
                currentValue = this._socialInformationEquity.get();
                newValue = currentValue + value;
            } while (!this._socialInformationEquity.compareAndSet(currentValue, newValue));
        }
    }
}

