/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.simple.Element;
import com.liferay.portal.xml.StAXReaderUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.Preference;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PortletPreferencesSerializer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PortletPreferences fromDefaultXML(String xml) throws SystemException {
        PortletPreferencesImpl portletPreferencesImpl;
        PortletPreferencesImpl preferences = new PortletPreferencesImpl();
        if (Validator.isNull((String)xml)) {
            return preferences;
        }
        Map<String, Preference> preferencesMap = preferences.getPreferences();
        XMLEventReader xmlEventReader = null;
        try {
            XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
            xmlEventReader = xmlInputFactory.createXMLEventReader((Reader)new UnsyncStringReader(xml));
            while (true) {
                StartElement startElement;
                String elementName;
                if (!xmlEventReader.hasNext()) {
                    portletPreferencesImpl = preferences;
                    if (xmlEventReader == null) return portletPreferencesImpl;
                    break;
                }
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement() || !(elementName = (startElement = xmlEvent.asStartElement()).getName().getLocalPart()).equals("preference")) continue;
                Preference preference = PortletPreferencesSerializer._readPreference(xmlEventReader);
                preferencesMap.put(preference.getName(), preference);
            }
        }
        catch (XMLStreamException xse) {
            try {
                throw new SystemException((Throwable)xse);
            }
            catch (Throwable throwable) {
                if (xmlEventReader == null) throw throwable;
                try {
                    xmlEventReader.close();
                    throw throwable;
                }
                catch (XMLStreamException xMLStreamException) {}
                throw throwable;
            }
        }
        try {
            xmlEventReader.close();
            return portletPreferencesImpl;
        }
        catch (XMLStreamException xMLStreamException) {}
        return portletPreferencesImpl;
    }

    public static PortletPreferencesImpl fromXML(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws SystemException {
        PortletPreferencesImpl preferences = (PortletPreferencesImpl)PortletPreferencesSerializer.fromDefaultXML(xml);
        preferences = new PortletPreferencesImpl(companyId, ownerId, ownerType, plid, portletId, preferences.getPreferences());
        return preferences;
    }

    public static String toXML(PortletPreferencesImpl preferences) {
        Map<String, Preference> preferencesMap = preferences.getPreferences();
        Element portletPreferencesElement = new Element("portlet-preferences", false);
        for (Map.Entry<String, Preference> entry : preferencesMap.entrySet()) {
            Preference preference = entry.getValue();
            Element preferenceElement = portletPreferencesElement.addElement("preference");
            preferenceElement.addElement("name", preference.getName());
            String[] stringArray = preference.getValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                preferenceElement.addElement("value", value);
                ++n2;
            }
            if (!preference.isReadOnly()) continue;
            preferenceElement.addElement("read-only", (Object)Boolean.TRUE);
        }
        return portletPreferencesElement.toXMLString();
    }

    private static Preference _readPreference(XMLEventReader xmlEventReader) throws XMLStreamException {
        String name = null;
        ArrayList<String> values = new ArrayList<String>();
        boolean readOnly = false;
        while (xmlEventReader.hasNext()) {
            EndElement endElement;
            String elementName;
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                String value;
                StartElement startElement = xmlEvent.asStartElement();
                elementName = startElement.getName().getLocalPart();
                if (elementName.equals("name")) {
                    name = StAXReaderUtil.read(xmlEventReader);
                    continue;
                }
                if (elementName.equals("value")) {
                    value = StAXReaderUtil.read(xmlEventReader);
                    values.add(value);
                    continue;
                }
                if (!elementName.equals("read-only")) continue;
                value = StAXReaderUtil.read(xmlEventReader);
                readOnly = GetterUtil.getBoolean((String)value);
                continue;
            }
            if (xmlEvent.isEndElement() && (elementName = (endElement = xmlEvent.asEndElement()).getName().getLocalPart()).equals("preference")) break;
        }
        return new Preference(name, values.toArray(new String[values.size()]), readOnly);
    }
}

