/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xmlrpc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xmlrpc.Fault;
import com.liferay.portal.kernel.xmlrpc.Response;
import com.liferay.portal.kernel.xmlrpc.Success;
import com.liferay.portal.kernel.xmlrpc.XmlRpc;
import com.liferay.portal.kernel.xmlrpc.XmlRpcException;
import com.liferay.portal.xmlrpc.FaultImpl;
import com.liferay.portal.xmlrpc.SuccessImpl;
import com.liferay.portal.xmlrpc.XmlRpcParser;

public class XmlRpcImpl
implements XmlRpc {
    private static Log _log = LogFactoryUtil.getLog(XmlRpcImpl.class);

    public Fault createFault(int code, String description) {
        return new FaultImpl(code, description);
    }

    public Success createSuccess(String description) {
        return new SuccessImpl(description);
    }

    public Response executeMethod(String url, String methodName, Object[] arguments) throws XmlRpcException {
        try {
            return this.doExecuteMethod(url, methodName, arguments);
        }
        catch (Exception e) {
            throw new XmlRpcException((Throwable)e);
        }
    }

    protected Response doExecuteMethod(String url, String methodName, Object[] arguments) throws Exception {
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler();
            sb.append("XML-RPC invoking " + methodName + " ");
            if (arguments != null) {
                int i = 0;
                while (i < arguments.length) {
                    sb.append(arguments[i]);
                    if (i < arguments.length - 1) {
                        sb.append(", ");
                    }
                    ++i;
                }
            }
            _log.debug((Object)sb.toString());
        }
        String requestXML = XmlRpcParser.buildMethod(methodName, arguments);
        Http.Options options = new Http.Options();
        options.addHeader("User-Agent", ReleaseInfo.getServerInfo());
        options.setBody(requestXML, "text/xml", "UTF-8");
        options.setLocation(url);
        options.setPost(true);
        String responseXML = HttpUtil.URLtoString((Http.Options)options);
        return XmlRpcParser.parseResponse(responseXML);
    }
}

