/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.webdav.InvalidRequestException;
import com.liferay.portal.webdav.methods.BasePropMethodImpl;
import com.liferay.portal.webdav.methods.Method;
import com.liferay.util.xml.XMLFormatter;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropfindMethodImpl
extends BasePropMethodImpl
implements Method {
    private static Log _log = LogFactoryUtil.getLog(PropfindMethodImpl.class);

    @Override
    public int process(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            Set<Tuple> props = this.getProps(webDavRequest);
            return this.writeResponseXML(webDavRequest, props);
        }
        catch (InvalidRequestException invalidRequestException) {
            return 400;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    protected Set<Tuple> getProps(WebDAVRequest webDavRequest) throws InvalidRequestException {
        try {
            Document doc;
            Element root;
            HashSet<Tuple> props = new HashSet<Tuple>();
            HttpServletRequest request = webDavRequest.getHttpServletRequest();
            String xml = new String(FileUtil.getBytes((InputStream)request.getInputStream()));
            if (Validator.isNull((String)xml)) {
                return this.generateProps(props);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Request XML: \n" + XMLFormatter.toString((String)xml, (String)"    ")));
            }
            if ((root = (doc = SAXReaderUtil.read((String)xml)).getRootElement()).element("allprop") != null) {
                return this.generateProps(props);
            }
            Element prop = root.element("prop");
            for (Element el : prop.elements()) {
                String prefix = el.getNamespacePrefix();
                String uri = el.getNamespaceURI();
                Namespace namespace = null;
                namespace = uri.equals(WebDAVUtil.DAV_URI.getURI()) ? WebDAVUtil.DAV_URI : (Validator.isNull((String)prefix) ? SAXReaderUtil.createNamespace((String)uri) : SAXReaderUtil.createNamespace((String)prefix, (String)uri));
                props.add(new Tuple(new Object[]{el.getName(), namespace}));
            }
            return props;
        }
        catch (Exception e) {
            throw new InvalidRequestException(e);
        }
    }

    protected Set<Tuple> generateProps(Set<Tuple> props) {
        props.add(new Tuple(new Object[]{"displayname", WebDAVUtil.DAV_URI}));
        props.add(new Tuple(new Object[]{"resourcetype", WebDAVUtil.DAV_URI}));
        props.add(new Tuple(new Object[]{"getcontenttype", WebDAVUtil.DAV_URI}));
        props.add(new Tuple(new Object[]{"getcontentlength", WebDAVUtil.DAV_URI}));
        props.add(new Tuple(new Object[]{"getlastmodified", WebDAVUtil.DAV_URI}));
        props.add(new Tuple(new Object[]{"lockdiscovery", WebDAVUtil.DAV_URI}));
        props.add(new Tuple(new Object[]{"checked-in", WebDAVUtil.DAV_URI}));
        props.add(new Tuple(new Object[]{"checked-out", WebDAVUtil.DAV_URI}));
        props.add(new Tuple(new Object[]{"version-name", WebDAVUtil.DAV_URI}));
        return props;
    }
}

