/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.model.User;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.TreeNodeView;
import com.liferay.portal.util.TreeView;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portal.util.comparator.PortletCategoryComparator;
import com.liferay.portal.util.comparator.PortletTitleComparator;
import com.liferay.portlet.PortletConfigFactoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletLister {
    private LayoutTypePortlet _layoutTypePortlet;
    private User _user;
    private ServletContext _servletContext;
    private int _nodeId;
    private List<TreeNodeView> _list;
    private int _depth;
    private boolean _includeInstanceablePortlets;

    public TreeView getTreeView(LayoutTypePortlet layoutTypePortlet, String rootNodeName, User user, ServletContext servletContext) throws PortalException, SystemException {
        this._layoutTypePortlet = layoutTypePortlet;
        this._user = user;
        this._servletContext = servletContext;
        this._nodeId = 1;
        this._list = new ArrayList<TreeNodeView>();
        TreeNodeView rootNodeView = new TreeNodeView(this._nodeId);
        rootNodeView.setName(rootNodeName);
        this._list.add(rootNodeView);
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(String.valueOf(user.getCompanyId()), "PORTLET_CATEGORY");
        List categories = ListUtil.fromCollection((Collection)portletCategory.getCategories());
        this._iterateCategories(categories, this._nodeId, 0);
        return new TreeView(this._list, this._depth);
    }

    public boolean isIncludeInstanceablePortlets() {
        return this._includeInstanceablePortlets;
    }

    public void setIncludeInstanceablePortlets(boolean includeInstanceablePortlets) {
        this._includeInstanceablePortlets = includeInstanceablePortlets;
    }

    private void _iterateCategories(List<PortletCategory> categories, long parentId, int depth) throws PortalException, SystemException {
        categories = ListUtil.sort(categories, (Comparator)new PortletCategoryComparator(this._user.getLocale()));
        Iterator itr = categories.iterator();
        int i = 0;
        while (itr.hasNext()) {
            PortletCategory portletCategory = (PortletCategory)itr.next();
            if (portletCategory.isHidden()) continue;
            if (i == 0 && ++depth > this._depth) {
                this._depth = depth;
            }
            TreeNodeView nodeView = new TreeNodeView(++this._nodeId);
            nodeView.setDepth(depth);
            if (i + 1 == categories.size()) {
                nodeView.setLs("1");
            } else {
                nodeView.setLs("0");
            }
            nodeView.setName(LanguageUtil.get((Locale)this._user.getLocale(), (String)portletCategory.getName()));
            nodeView.setParentId(parentId);
            this._list.add(nodeView);
            List subCategories = ListUtil.fromCollection((Collection)portletCategory.getCategories());
            this._iterateCategories(subCategories, this._nodeId, depth);
            this._iteratePortlets(portletCategory, portletCategory.getPortletIds(), this._nodeId, depth + 1);
            ++i;
        }
    }

    private void _iteratePortlets(PortletCategory portletCategory, Set<String> portletIds, int parentNodeId, int depth) throws PortalException, SystemException {
        List<Portlet> portlets = new ArrayList();
        Iterator<String> portletIdsItr = portletIds.iterator();
        String externalPortletCategory = null;
        while (portletIdsItr.hasNext()) {
            PortletApp portletApp;
            String portletId = portletIdsItr.next();
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this._user.getCompanyId(), (String)portletId);
            if (portlet == null) continue;
            if (!portlet.isSystem() && portlet.isActive() && (!portlet.isInstanceable() || this._includeInstanceablePortlets)) {
                if (!portlet.isInstanceable() && this._layoutTypePortlet.hasPortletId(portlet.getPortletId())) {
                    portlets.add(portlet);
                } else if (portlet.hasAddPortletPermission(this._user.getUserId())) {
                    portlets.add(portlet);
                }
            }
            if (!(portletApp = portlet.getPortletApp()).isWARFile() || !Validator.isNull(externalPortletCategory)) continue;
            PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)this._servletContext);
            ResourceBundle resourceBundle = portletConfig.getResourceBundle(this._user.getLocale());
            try {
                externalPortletCategory = resourceBundle.getString(portletCategory.getName());
            }
            catch (MissingResourceException missingResourceException) {}
        }
        portlets = ListUtil.sort(portlets, (Comparator)new PortletTitleComparator(this._user.getLocale()));
        Iterator portletsItr = portlets.iterator();
        int i = 0;
        while (portletsItr.hasNext()) {
            Portlet portlet = (Portlet)portletsItr.next();
            TreeNodeView nodeView = new TreeNodeView(++this._nodeId);
            nodeView.setDepth(depth);
            if (i + 1 == portlets.size()) {
                nodeView.setLs("1");
            } else {
                nodeView.setLs("0");
            }
            nodeView.setName(PortalUtil.getPortletTitle((Portlet)portlet, (User)this._user));
            nodeView.setObjId(portlet.getRootPortletId());
            nodeView.setParentId(parentNodeId);
            this._list.add(nodeView);
            ++i;
        }
    }
}

