/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.cache.CacheRegistryImpl;
import com.liferay.portal.configuration.ConfigurationFactoryImpl;
import com.liferay.portal.dao.db.DBFactoryImpl;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.configuration.ConfigurationFactory;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.dao.db.DBFactory;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.JavaProps;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.spring.util.SpringUtil;
import com.liferay.util.SystemProperties;
import com.liferay.util.log4j.Log4JUtil;
import java.net.URL;

public class InitUtil {
    private static final boolean _PRINT_TIME = false;
    private static boolean _initialized;

    public static synchronized void init() {
        if (_initialized) {
            return;
        }
        String userLanguage = SystemProperties.get((String)"user.language");
        String userCountry = SystemProperties.get((String)"user.country");
        String userVariant = SystemProperties.get((String)"user.variant");
        LocaleUtil.setDefault((String)userLanguage, (String)userCountry, (String)userVariant);
        String userTimeZone = SystemProperties.get((String)"user.timezone");
        TimeZoneUtil.setDefault((String)userTimeZone);
        try {
            Thread currentThread = Thread.currentThread();
            PortalClassLoaderUtil.setClassLoader((ClassLoader)currentThread.getContextClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (GetterUtil.getBoolean((String)SystemProperties.get((String)"log4j.configure.on.startup"), (boolean)true)) {
            ClassLoader classLoader = InitUtil.class.getClassLoader();
            Log4JUtil.configureLog4J((URL)classLoader.getResource("META-INF/portal-log4j.xml"));
            Log4JUtil.configureLog4J((URL)classLoader.getResource("META-INF/portal-log4j-ext.xml"));
        }
        try {
            LogFactoryUtil.setLogFactory((LogFactory)new Log4jLogFactoryImpl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CacheRegistryUtil.setCacheRegistry((CacheRegistry)new CacheRegistryImpl());
        ConfigurationFactoryUtil.setConfigurationFactory((ConfigurationFactory)new ConfigurationFactoryImpl());
        DBFactoryUtil.setDBFactory((DBFactory)new DBFactoryImpl());
        JavaProps.isJDK5();
        _initialized = true;
    }

    public static synchronized void initWithSpring() {
        if (_initialized) {
            return;
        }
        InitUtil.init();
        SpringUtil.loadContext();
        _initialized = true;
    }
}

