/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FacebookConnectUtil {
    private static Log _log = LogFactoryUtil.getLog(FacebookConnectUtil.class);

    public static String getAccessTokenURL(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.oauth.token.url", PropsValues.FACEBOOK_CONNECT_OAUTH_TOKEN_URL);
    }

    public static String getAppId(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.app.id", PropsValues.FACEBOOK_CONNECT_APP_ID);
    }

    public static String getAppSecret(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.app.secret", PropsValues.FACEBOOK_CONNECT_APP_SECRET);
    }

    public static String getAuthURL(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.oauth.auth.url", PropsValues.FACEBOOK_CONNECT_OAUTH_AUTH_URL);
    }

    public static JSONObject getGraphResources(long companyId, String path, String accessToken, String fields) {
        try {
            String url = HttpUtil.addParameter((String)(String.valueOf(FacebookConnectUtil.getGraphURL(companyId)) + path), (String)"access_token", (String)accessToken);
            if (Validator.isNotNull((String)fields)) {
                url = HttpUtil.addParameter((String)url, (String)"fields", (String)fields);
            }
            Http.Options options = new Http.Options();
            options.setLocation(url);
            String json = HttpUtil.URLtoString((Http.Options)options);
            return JSONFactoryUtil.createJSONObject((String)json);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return null;
        }
    }

    public static String getGraphURL(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.graph.url", PropsValues.FACEBOOK_CONNECT_GRAPH_URL);
    }

    public static String getProfileImageURL(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpSession session = (request = PortalUtil.getOriginalServletRequest((HttpServletRequest)request)).getSession();
        String facebookId = (String)session.getAttribute("FACEBOOK_USER_ID");
        if (Validator.isNull((String)facebookId)) {
            return null;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String token = (String)session.getAttribute("FACEBOOK_ACCESS_TOKEN");
        JSONObject jsonObject = FacebookConnectUtil.getGraphResources(companyId, "/me", token, "id,picture");
        return jsonObject.getString("picture");
    }

    public static String getRedirectURL(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.oauth.redirect.url", PropsValues.FACEBOOK_CONNECT_OAUTH_REDIRECT_URL);
    }

    public static boolean isEnabled(long companyId) throws SystemException {
        return PrefsPropsUtil.getBoolean(companyId, "facebook.connect.auth.enabled", PropsValues.FACEBOOK_CONNECT_AUTH_ENABLED);
    }
}

