/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_3;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.upgrade.v5_2_3.util.CountryDependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.DependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.ExpandoColumnDependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.ExpandoRowDependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.ExpandoTableDependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.LayoutDependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.MBDiscussionDependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.PermissionDependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.ResourceCodeDependencyManager;
import com.liferay.portal.upgrade.v5_2_3.util.ResourceDependencyManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeDuplicates
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeDuplicates.class);

    protected void deleteDuplicateAnnouncements() throws Exception {
        this.deleteDuplicates("AnnouncementsDelivery", "deliveryId", new Object[][]{{"userId", -5}, {"type_", 12}});
        this.deleteDuplicates("AnnouncementsFlag", "flagId", new Object[][]{{"userId", -5}, {"entryId", -5}, {"value", 4}});
    }

    protected void deleteDuplicateBlogs() throws Exception {
        this.deleteDuplicates("BlogsStatsUser", "statsUserId", new Object[][]{{"groupId", -5}, {"userId", -5}});
    }

    protected void deleteDuplicateCountry() throws Exception {
        CountryDependencyManager countryDependencyManager = new CountryDependencyManager();
        this.deleteDuplicates("Country", "countryId", (Object[][])new Object[][]{{"name", 12}}, countryDependencyManager);
        this.deleteDuplicates("Country", "countryId", (Object[][])new Object[][]{{"a2", 12}}, countryDependencyManager);
        this.deleteDuplicates("Country", "countryId", (Object[][])new Object[][]{{"a3", 12}}, countryDependencyManager);
    }

    protected void deleteDuplicateDocumentLibrary() throws Exception {
        this.deleteDuplicates("DLFileRank", "fileRankId", new Object[][]{{"companyId", -5}, {"userId", -5}, {"folderId", -5}, {"name", 12}});
        this.deleteDuplicates("DLFileVersion", "fileVersionId", new Object[][]{{"folderId", -5}, {"name", 12}, {"version", 8}});
        this.deleteDuplicates("DLFolder", "folderId", new Object[][]{{"groupId", -5}, {"parentFolderId", -5}, {"name", 12}});
    }

    protected void deleteDuplicateGroup() throws Exception {
        this.deleteDuplicates("Group_", "groupId", new Object[][]{{"classNameId", -5}, {"classPK", -5}});
    }

    protected void deleteDuplicateExpando() throws Exception {
        ExpandoTableDependencyManager expandoTableDependencyManager = new ExpandoTableDependencyManager();
        this.deleteDuplicates("ExpandoTable", "tableId", (Object[][])new Object[][]{{"companyId", -5}, {"classNameId", -5}, {"name", 12}}, expandoTableDependencyManager);
        ExpandoRowDependencyManager expandoRowDependencyManager = new ExpandoRowDependencyManager();
        this.deleteDuplicates("ExpandoRow", "rowId_", (Object[][])new Object[][]{{"tableId", -5}, {"classPK", -5}}, expandoRowDependencyManager);
        ExpandoColumnDependencyManager expandoColumnDependencyManager = new ExpandoColumnDependencyManager();
        this.deleteDuplicates("ExpandoColumn", "columnId", (Object[][])new Object[][]{{"tableId", -5}, {"name", 12}}, expandoColumnDependencyManager);
        this.deleteDuplicates("ExpandoValue", "valueId", new Object[][]{{"columnId", -5}, {"rowId_", -5}});
        this.deleteDuplicates("ExpandoValue", "valueId", new Object[][]{{"tableId", -5}, {"columnId", -5}, {"classPK", -5}});
    }

    protected void deleteDuplicateIG() throws Exception {
        this.deleteDuplicates("IGFolder", "folderId", new Object[][]{{"groupId", -5}, {"parentFolderId", -5}, {"name", 12}});
    }

    protected void deleteDuplicateLayout() throws Exception {
        LayoutDependencyManager layoutDependencyManager = new LayoutDependencyManager();
        this.deleteDuplicates("Layout", "plid", (Object[][])new Object[][]{{"groupId", -5}, {"privateLayout", 16}, {"friendlyURL", 12}}, layoutDependencyManager);
        this.deleteDuplicates("Layout", "plid", (Object[][])new Object[][]{{"groupId", -5}, {"privateLayout", 16}, {"layoutId", -5}}, layoutDependencyManager);
    }

    protected void deleteDuplicateMessageBoards() throws Exception {
        this.deleteDuplicates("MBBan", "banId", new Object[][]{{"groupId", -5}, {"banUserId", -5}});
        MBDiscussionDependencyManager mbDiscussionDependencyManager = new MBDiscussionDependencyManager();
        this.deleteDuplicates("MBDiscussion", "discussionId", new Object[][]{{"classNameId", -5}, {"classPK", -5}}, new Object[][]{{"threadId", -5}}, mbDiscussionDependencyManager);
        this.deleteDuplicates("MBDiscussion", "discussionId", (Object[][])new Object[][]{{"threadId", -5}}, mbDiscussionDependencyManager);
        this.deleteDuplicates("MBMessageFlag", "messageFlagId", new Object[][]{{"userId", -5}, {"messageId", -5}, {"flag", 4}});
        this.deleteDuplicates("MBStatsUser", "statsUserId", new Object[][]{{"groupId", -5}, {"userId", -5}});
    }

    protected void deleteDuplicatePermission() throws Exception {
        PermissionDependencyManager permissionDependencyManager = new PermissionDependencyManager();
        this.deleteDuplicates("Permission_", "permissionId", (Object[][])new Object[][]{{"actionId", 12}, {"resourceId", -5}}, permissionDependencyManager);
    }

    protected void deleteDuplicatePolls() throws Exception {
        this.deleteDuplicates("PollsVote", "voteId", new Object[][]{{"questionId", -5}, {"userId", -5}});
    }

    protected void deleteDuplicatePortletPreferences() throws Exception {
        this.deleteDuplicates("PortletPreferences", "portletPreferencesId", new Object[][]{{"ownerId", -5}, {"ownerType", 4}, {"plid", -5}, {"portletId", 12}});
    }

    protected void deleteDuplicateRatings() throws Exception {
        this.deleteDuplicates("RatingsEntry", "entryId", new Object[][]{{"userId", -5}, {"classNameId", -5}, {"classPK", -5}});
        this.deleteDuplicates("RatingsStats", "statsId", new Object[][]{{"classNameId", -5}, {"classPK", -5}});
    }

    protected void deleteDuplicateResource() throws Exception {
        ResourceDependencyManager resourceDependencyManager = new ResourceDependencyManager();
        this.deleteDuplicates("Resource_", "resourceId", (Object[][])new Object[][]{{"codeId", -5}, {"primKey", 12}}, resourceDependencyManager);
    }

    protected void deleteDuplicateResourceCode() throws Exception {
        ResourceCodeDependencyManager resourceCodeDependencyManager = new ResourceCodeDependencyManager();
        this.deleteDuplicates("ResourceCode", "codeId", (Object[][])new Object[][]{{"companyId", -5}, {"name", 12}, {"scope", 4}}, resourceCodeDependencyManager);
    }

    protected void deleteDuplicateUser() throws Exception {
        this.deleteDuplicates("User_", "userId", new Object[][]{{"companyId", -5}, {"screenName", 12}});
    }

    protected void deleteDuplicates(String tableName, String primaryKeyName, Object[][] columns) throws Exception {
        this.deleteDuplicates(tableName, primaryKeyName, columns, null, null);
    }

    protected void deleteDuplicates(String tableName, String primaryKeyName, Object[][] columns, DependencyManager dependencyManager) throws Exception {
        this.deleteDuplicates(tableName, primaryKeyName, columns, null, dependencyManager);
    }

    protected void deleteDuplicates(String tableName, String primaryKeyName, Object[][] columns, Object[][] extraColumns) throws Exception {
        this.deleteDuplicates(tableName, primaryKeyName, columns, extraColumns, null);
    }

    protected void deleteDuplicates(String tableName, String primaryKeyName, Object[][] columns, Object[][] extraColumns, DependencyManager dependencyManager) throws Exception {
        if (_log.isInfoEnabled()) {
            StringBundler sb = new StringBundler(2 * columns.length + 4);
            sb.append("Checking for duplicate data from ");
            sb.append(tableName);
            sb.append(" for unique index (");
            int i = 0;
            while (i < columns.length) {
                sb.append(columns[i][0]);
                if (i + 1 < columns.length) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append(")");
            _log.info((Object)sb.toString());
        }
        if (dependencyManager != null) {
            dependencyManager.setTableName(tableName);
            dependencyManager.setPrimaryKeyName(primaryKeyName);
            dependencyManager.setColumns(columns);
            dependencyManager.setExtraColumns(extraColumns);
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler();
            sb.append("select ");
            sb.append(primaryKeyName);
            int i = 0;
            while (i < columns.length) {
                sb.append(", ");
                sb.append(columns[i][0]);
                ++i;
            }
            if (extraColumns != null) {
                i = 0;
                while (i < extraColumns.length) {
                    sb.append(", ");
                    sb.append(extraColumns[i][0]);
                    ++i;
                }
            }
            sb.append(" from ");
            sb.append(tableName);
            sb.append(" order by ");
            i = 0;
            while (i < columns.length) {
                sb.append(columns[i][0]);
                sb.append(", ");
                ++i;
            }
            sb.append(primaryKeyName);
            String sql = sb.toString();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Execute SQL " + sql));
            }
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            boolean supportsStringCaseSensitiveQuery = this.isSupportsStringCaseSensitiveQuery();
            long previousPrimaryKeyValue = 0L;
            Object[] previousColumnValues = new Object[columns.length];
            Object[] previousExtraColumnValues = null;
            if (extraColumns != null) {
                previousExtraColumnValues = new Object[extraColumns.length];
            }
            while (rs.next()) {
                long primaryKeyValue = rs.getLong(primaryKeyName);
                Object[] columnValues = this.getColumnValues(rs, columns);
                Object[] extraColumnValues = this.getColumnValues(rs, extraColumns);
                boolean duplicate = true;
                int i2 = 0;
                while (i2 < columnValues.length) {
                    Object columnValue = columnValues[i2];
                    Object previousColumnValue = previousColumnValues[i2];
                    if (columnValue == null || previousColumnValue == null) {
                        duplicate = false;
                    } else if (!supportsStringCaseSensitiveQuery && columns[i2][1].equals(12)) {
                        String columnValueString = (String)columnValue;
                        String previousColumnValueString = (String)previousColumnValue;
                        if (!columnValueString.equalsIgnoreCase(previousColumnValueString)) {
                            duplicate = false;
                        }
                    } else if (!columnValue.equals(previousColumnValue)) {
                        duplicate = false;
                    }
                    if (!duplicate) break;
                    ++i2;
                }
                if (duplicate) {
                    this.runSQL("delete from " + tableName + " where " + primaryKeyName + " = " + primaryKeyValue);
                    if (dependencyManager == null) continue;
                    if (_log.isInfoEnabled()) {
                        sb.setIndex(0);
                        sb.append("Resolving duplicate data from ");
                        sb.append(tableName);
                        sb.append(" with primary keys ");
                        sb.append(primaryKeyValue);
                        sb.append(" and ");
                        sb.append(previousPrimaryKeyValue);
                        _log.info((Object)sb.toString());
                    }
                    dependencyManager.update(previousPrimaryKeyValue, previousColumnValues, previousExtraColumnValues, primaryKeyValue, columnValues, extraColumnValues);
                    continue;
                }
                previousPrimaryKeyValue = primaryKeyValue;
                i2 = 0;
                while (i2 < columnValues.length) {
                    previousColumnValues[i2] = columnValues[i2];
                    ++i2;
                }
                if (extraColumnValues == null) continue;
                i2 = 0;
                while (i2 < extraColumnValues.length) {
                    previousExtraColumnValues[i2] = extraColumnValues[i2];
                    ++i2;
                }
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void deleteDuplicateSocial() throws Exception {
        this.deleteDuplicates("SocialActivity", "activityId", new Object[][]{{"groupId", -5}, {"userId", -5}, {"createDate", 93}, {"classNameId", -5}, {"classPK", -5}, {"type_", 4}, {"receiverUserId", -5}});
        this.deleteDuplicates("SocialRelation", "relationId", new Object[][]{{"userId1", -5}, {"userId2", -5}, {"type_", 4}});
        this.deleteDuplicates("SocialRequest", "requestId", new Object[][]{{"userId", -5}, {"classNameId", -5}, {"classPK", -5}, {"type_", 4}, {"receiverUserId", -5}});
    }

    protected void deleteDuplicateSubscription() throws Exception {
        this.deleteDuplicates("Subscription", "subscriptionId", new Object[][]{{"companyId", -5}, {"userId", -5}, {"classNameId", -5}, {"classPK", -5}});
    }

    protected void doUpgrade() throws Exception {
        this.deleteDuplicateAnnouncements();
        this.deleteDuplicateBlogs();
        this.deleteDuplicateCountry();
        this.deleteDuplicateDocumentLibrary();
        this.deleteDuplicateExpando();
        this.deleteDuplicateGroup();
        this.deleteDuplicateIG();
        this.deleteDuplicateLayout();
        this.deleteDuplicateMessageBoards();
        this.deleteDuplicatePermission();
        this.deleteDuplicatePolls();
        this.deleteDuplicatePortletPreferences();
        this.deleteDuplicateRatings();
        this.deleteDuplicateResource();
        this.deleteDuplicateResourceCode();
        this.deleteDuplicateSocial();
        this.deleteDuplicateSubscription();
        this.deleteDuplicateUser();
    }

    protected Object[] getColumnValues(ResultSet rs, Object[][] columns) throws Exception {
        if (columns == null) {
            return null;
        }
        Object[] columnValues = new Object[columns.length];
        int i = 0;
        while (i < columns.length) {
            String columnName = (String)columns[i][0];
            Integer columnType = (Integer)columns[i][1];
            if (columnType == -5) {
                columnValues[i] = rs.getLong(columnName);
            } else if (columnType == 16) {
                columnValues[i] = rs.getBoolean(columnName);
            } else if (columnType == 8) {
                columnValues[i] = rs.getDouble(columnName);
            } else if (columnType == 4) {
                columnValues[i] = rs.getInt(columnName);
            } else if (columnType == 93) {
                columnValues[i] = rs.getTimestamp(columnName);
            } else if (columnType == 12) {
                columnValues[i] = rs.getString(columnName);
            } else {
                throw new UpgradeException("Upgrade code using unsupported class type " + columnType);
            }
            ++i;
        }
        return columnValues;
    }
}

