/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v4_3_0.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.util.BaseUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.IdReplacer;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.ValueMapper;
import com.liferay.portal.kernel.upgrade.util.ValueMapperFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.upgrade.util.Table;
import com.liferay.portal.upgrade.v4_3_0.util.AvailableMappersUtil;
import com.liferay.portlet.journal.service.JournalArticleImageLocalServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.util.PKParser;

public class JournalArticleContentUpgradeColumnImpl
extends BaseUpgradeColumnImpl {
    private static final String _IMG_ID_PATH = "/image/journal/article?img_id=";
    private static Log _log = LogFactoryUtil.getLog(JournalArticleContentUpgradeColumnImpl.class);
    private UpgradeColumn _companyIdColumn;
    private UpgradeColumn _groupIdColumn;
    private UpgradeColumn _articleIdColumn;
    private UpgradeColumn _versionColumn;
    private UpgradeColumn _structureIdColumn;
    private ValueMapper _imageIdMapper;

    public JournalArticleContentUpgradeColumnImpl(UpgradeColumn companyIdColumn, UpgradeColumn groupIdColumn, UpgradeColumn articleIdColumn, UpgradeColumn versionColumn, UpgradeColumn structureIdColumn, ValueMapper imageIdMapper) {
        super("content");
        this._companyIdColumn = companyIdColumn;
        this._groupIdColumn = groupIdColumn;
        this._articleIdColumn = articleIdColumn;
        this._versionColumn = versionColumn;
        this._structureIdColumn = structureIdColumn;
        this._imageIdMapper = imageIdMapper;
    }

    public Object getNewValue(Object oldValue) throws Exception {
        String content = (String)oldValue;
        content = StringUtil.replace((String)content, (String[])Table.SAFE_CHARS[1], (String[])Table.SAFE_CHARS[0]);
        String structureId = (String)this._structureIdColumn.getOldValue();
        if (Validator.isNotNull((String)structureId)) {
            content = this.formatContent(content);
        }
        content = this.replaceIds(content);
        content = StringUtil.replace((String)content, (String[])Table.SAFE_CHARS[0], (String[])Table.SAFE_CHARS[1]);
        return content;
    }

    protected String formatContent(String content) throws Exception {
        String oldCompanyId = (String)this._companyIdColumn.getOldValue();
        Long newCompanyId = (Long)this._companyIdColumn.getNewValue();
        Long groupId = (Long)this._groupIdColumn.getNewValue();
        String articleId = (String)this._articleIdColumn.getNewValue();
        Double version = (Double)this._versionColumn.getNewValue();
        try {
            Document doc = SAXReaderUtil.read((String)content);
            Element root = doc.getRootElement();
            this.format(oldCompanyId, newCompanyId, groupId, articleId, version, root);
            content = JournalUtil.formatXML(doc);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to format content for {articleId=" + articleId + ",version=" + version + "}: " + e.getMessage()));
        }
        return content;
    }

    protected void format(String oldCompanyId, long newCompanyId, long groupId, String articleId, double version, Element root) throws Exception {
        for (Element el : root.elements()) {
            String oldImageId;
            Element dynamicContent = el.element("dynamic-content");
            String elInstanceId = "";
            String elName = el.attributeValue("name", "");
            String elType = el.attributeValue("type", "");
            String elLanguage = "";
            if (dynamicContent != null && !(elLanguage = dynamicContent.attributeValue("language-id", "")).equals("")) {
                elLanguage = "_" + elLanguage;
            }
            if ((elType.equals("image") || elType.equals("text")) && ((oldImageId = dynamicContent.getText()).startsWith(_IMG_ID_PATH) || oldImageId.startsWith("@portal_url@/image/journal/article?img_id=") || oldImageId.startsWith("http://@portal_url@/image/journal/article?img_id=") || oldImageId.startsWith("https://@portal_url@/image/journal/article?img_id="))) {
                int pos = oldImageId.indexOf(_IMG_ID_PATH);
                String preOldImageId = oldImageId.substring(0, pos);
                oldImageId = oldImageId.substring(pos + _IMG_ID_PATH.length(), oldImageId.length());
                String newImageId = this.getNewImageId(oldCompanyId, oldImageId);
                dynamicContent.setText(String.valueOf(preOldImageId) + _IMG_ID_PATH + newImageId);
                if (elType.equals("image")) {
                    dynamicContent.addAttribute("id", newImageId);
                    long articleImageId = GetterUtil.getLong((String)newImageId);
                    JournalArticleImageLocalServiceUtil.addArticleImageId((long)articleImageId, (long)groupId, (String)articleId, (double)version, (String)elInstanceId, (String)elName, (String)elLanguage);
                }
            }
            this.format(oldCompanyId, newCompanyId, groupId, articleId, version, el);
        }
    }

    protected String getNewImageId(String oldCompanyId, String oldImageId) throws Exception {
        int pos = oldImageId.lastIndexOf("&version=");
        oldImageId = String.valueOf(oldImageId.substring(0, pos)) + "." + oldImageId.substring(pos + 9, oldImageId.length());
        String newImageId = String.valueOf(oldCompanyId) + ".journal.article." + oldImageId;
        return String.valueOf(this._imageIdMapper.getNewValue((Object)newImageId));
    }

    protected String replaceIds(String content) throws Exception {
        ValueMapper dlFolderIdMapper = AvailableMappersUtil.getDLFolderIdMapper();
        content = IdReplacer.replaceLongIds((String)content, (String)"/document_library/get_file?folderId=", (ValueMapper)dlFolderIdMapper);
        content = IdReplacer.replaceLongIds((String)content, (String)"_20_struts_action=%2Fdocument_library%2Fget_file&_20_folderId=", (ValueMapper)dlFolderIdMapper);
        content = IdReplacer.replaceLongIds((String)content, (String)"_20_struts_action=%2Fdocument_library%2Fget_file&amp;_20_folderId=", (ValueMapper)dlFolderIdMapper);
        ValueMapper imageIdMapper = AvailableMappersUtil.getImageIdMapper();
        ValueMapper newImageIdMapper = ValueMapperFactoryUtil.getValueMapper();
        ValueMapper igImageIdMapper = AvailableMappersUtil.getIGImageIdMapper();
        for (String oldValue : igImageIdMapper) {
            PKParser oldValuePKParser = new PKParser(oldValue);
            String companyId = oldValuePKParser.getString("companyId");
            String oldIGImageId = oldValuePKParser.getString("imageId");
            String oldImageId = String.valueOf(companyId) + ".image_gallery." + oldIGImageId + ".large";
            Long newImageId = (Long)imageIdMapper.getNewValue((Object)oldImageId);
            newImageIdMapper.mapValue((Object)new Long(GetterUtil.getLong((String)oldIGImageId)), (Object)newImageId);
        }
        content = IdReplacer.replaceLongIds((String)content, (String)"/image_gallery?img_id=", (ValueMapper)newImageIdMapper);
        return content;
    }
}

