/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.deploy.BaseDeployer;
import com.liferay.portal.util.InitUtil;
import com.liferay.util.TextFormatter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeDeployer
extends BaseDeployer {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        ArrayList<String> wars = new ArrayList<String>();
        ArrayList<String> jars = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.endsWith(".war")) {
                wars.add(arg);
            } else if (arg.endsWith(".jar")) {
                jars.add(arg);
            }
            ++n2;
        }
        new ThemeDeployer(wars, jars);
    }

    protected ThemeDeployer() {
    }

    protected ThemeDeployer(List<String> wars, List<String> jars) {
        super(wars, jars);
    }

    @Override
    protected void checkArguments() {
        super.checkArguments();
        if (Validator.isNull((String)this.themeTaglibDTD)) {
            throw new IllegalArgumentException("The system property deployer.theme.taglib.dtd is not set");
        }
        if (Validator.isNull((String)this.utilTaglibDTD)) {
            throw new IllegalArgumentException("The system property deployer.util.taglib.dtd is not set");
        }
    }

    @Override
    protected String getExtraContent(double webXmlVersion, File srcFile, String displayName) throws Exception {
        StringBundler sb = new StringBundler(7);
        String extraContent = super.getExtraContent(webXmlVersion, srcFile, displayName);
        sb.append(extraContent);
        sb.append("<listener>");
        sb.append("<listener-class>");
        sb.append("com.liferay.portal.kernel.servlet.ThemeContextListener");
        sb.append("</listener-class>");
        sb.append("</listener>");
        sb.append(this.getSpeedFiltersContent(srcFile));
        return sb.toString();
    }

    @Override
    protected void processPluginPackageProperties(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        if (pluginPackage == null) {
            return;
        }
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties == null || properties.size() == 0) {
            return;
        }
        String moduleGroupId = pluginPackage.getGroupId();
        String moduleArtifactId = pluginPackage.getArtifactId();
        String moduleVersion = pluginPackage.getVersion();
        String pluginName = pluginPackage.getName();
        String pluginType = (String)pluginPackage.getTypes().get(0);
        String pluginTypeName = TextFormatter.format((String)pluginType, (int)9);
        if (!pluginType.equals("theme")) {
            return;
        }
        String tags = this.getPluginPackageTagsXml(pluginPackage.getTags());
        String shortDescription = pluginPackage.getShortDescription();
        String longDescription = pluginPackage.getLongDescription();
        String changeLog = pluginPackage.getChangeLog();
        String pageURL = pluginPackage.getPageURL();
        String author = pluginPackage.getAuthor();
        String licenses = this.getPluginPackageLicensesXml(pluginPackage.getLicenses());
        String liferayVersions = this.getPluginPackageLiferayVersionsXml(pluginPackage.getLiferayVersions());
        int pos = moduleArtifactId.indexOf("-theme");
        String themeId = moduleArtifactId.substring(0, pos);
        String themeName = pluginName;
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("module_group_id", moduleGroupId);
        filterMap.put("module_artifact_id", moduleArtifactId);
        filterMap.put("module_version", moduleVersion);
        filterMap.put("plugin_name", pluginName);
        filterMap.put("plugin_type", pluginType);
        filterMap.put("plugin_type_name", pluginTypeName);
        filterMap.put("tags", tags);
        filterMap.put("short_description", shortDescription);
        filterMap.put("long_description", longDescription);
        filterMap.put("change_log", changeLog);
        filterMap.put("page_url", pageURL);
        filterMap.put("author", author);
        filterMap.put("licenses", licenses);
        filterMap.put("liferay_versions", liferayVersions);
        filterMap.put("theme_id", themeId);
        filterMap.put("theme_name", themeName);
        filterMap.put("theme_versions", StringUtil.replace((String)liferayVersions, (String)"liferay-version", (String)"version"));
        this.copyDependencyXml("liferay-look-and-feel.xml", srcFile + "/WEB-INF", filterMap, true);
        this.copyDependencyXml("liferay-plugin-package.xml", srcFile + "/WEB-INF", filterMap, true);
    }
}

