/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.InitUtil;
import java.io.IOException;

public class DBBuilder {
    private String _databaseName;
    private String[] _databaseTypes;

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length == 1) {
            new DBBuilder(args[0], DB.TYPE_ALL);
        } else if (args.length == 2) {
            new DBBuilder(args[0], StringUtil.split((String)args[1]));
        } else {
            throw new IllegalArgumentException();
        }
    }

    public DBBuilder(String databaseName, String[] databaseTypes) {
        try {
            this._databaseName = databaseName;
            this._databaseTypes = databaseTypes;
            String sqlDir = System.getProperty("sql.dir", "../sql");
            this._buildSQLFile(sqlDir, "portal");
            this._buildSQLFile(sqlDir, "portal-minimal");
            this._buildSQLFile(sqlDir, "indexes");
            this._buildSQLFile(sqlDir, "sequences");
            this._buildSQLFile(sqlDir, "tables");
            this._buildSQLFile(sqlDir, "update-4.2.0-4.3.0");
            this._buildSQLFile(sqlDir, "update-4.3.0-4.3.1");
            this._buildSQLFile(sqlDir, "update-4.3.1-4.3.2");
            this._buildSQLFile(sqlDir, "update-4.3.2-4.3.3");
            this._buildSQLFile(sqlDir, "update-4.3.3-4.3.4");
            this._buildSQLFile(sqlDir, "update-4.3.6-4.4.0");
            this._buildSQLFile(sqlDir, "update-4.4.0-5.0.0");
            this._buildSQLFile(sqlDir, "update-5.0.1-5.1.0");
            this._buildSQLFile(sqlDir, "update-5.1.1-5.1.2");
            this._buildSQLFile(sqlDir, "update-5.1.2-5.2.0");
            this._buildSQLFile(sqlDir, "update-5.2.0-5.2.1");
            this._buildSQLFile(sqlDir, "update-5.2.2-5.2.3");
            this._buildSQLFile(sqlDir, "update-5.2.3-6.0.0");
            this._buildSQLFile(sqlDir, "update-5.2.5-6.0.0");
            this._buildSQLFile(sqlDir, "update-5.2.7-6.0.0");
            this._buildSQLFile(sqlDir, "update-5.2.8-6.0.5");
            this._buildSQLFile(sqlDir, "update-6.0.0-6.0.1");
            this._buildSQLFile(sqlDir, "update-6.0.1-6.0.2");
            this._buildSQLFile(sqlDir, "update-6.0.2-6.0.3");
            this._buildSQLFile(sqlDir, "update-6.0.4-6.0.5");
            this._buildSQLFile(sqlDir, "update-6.0.5-6.0.6");
            this._buildCreateFile(sqlDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _buildCreateFile(String sqlDir) throws IOException {
        int i = 0;
        while (i < this._databaseTypes.length) {
            DB db;
            String databaseType = this._databaseTypes[i];
            if (!(databaseType.equals("hypersonic") || databaseType.equals("interbase") || databaseType.equals("jdatastore") || databaseType.equals("sap") || (db = DBFactoryUtil.getDB((String)this._databaseTypes[i])) == null)) {
                if (sqlDir.equals("../sql")) {
                    db.buildCreateFile(sqlDir, this._databaseName);
                } else {
                    db.buildCreateFile(sqlDir, this._databaseName, 0);
                }
            }
            ++i;
        }
    }

    private void _buildSQLFile(String sqlDir, String fileName) throws IOException {
        if (!FileUtil.exists((String)(String.valueOf(sqlDir) + "/" + fileName + ".sql"))) {
            return;
        }
        int i = 0;
        while (i < this._databaseTypes.length) {
            DB db = DBFactoryUtil.getDB((String)this._databaseTypes[i]);
            if (db != null) {
                db.buildSQLFile(sqlDir, fileName);
            }
            ++i;
        }
    }
}

