/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.etag;

import com.liferay.portal.kernel.servlet.ByteBufferServletResponse;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.etag.ETagUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import java.nio.ByteBuffer;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagFilter
extends BasePortalFilter {
    private static final String _ETAG = "etag";

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        boolean etag = ParamUtil.getBoolean((HttpServletRequest)request, (String)_ETAG, (boolean)true);
        if (etag) {
            ByteBufferServletResponse byteBufferResponse = new ByteBufferServletResponse(response);
            this.processFilter(ETagFilter.class, request, (HttpServletResponse)byteBufferResponse, filterChain);
            if (!ETagUtil.processETag(request, response, byteBufferResponse)) {
                ServletResponseUtil.write((HttpServletResponse)response, (ByteBuffer)byteBufferResponse.getByteBuffer());
            }
        } else {
            this.processFilter(ETagFilter.class, request, response, filterChain);
        }
    }
}

