/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.model.impl.CompanyImpl;
import com.liferay.portal.model.impl.CompanyModelImpl;
import com.liferay.portal.service.persistence.AccountPersistence;
import com.liferay.portal.service.persistence.AddressPersistence;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.BrowserTrackerPersistence;
import com.liferay.portal.service.persistence.ClassNamePersistence;
import com.liferay.portal.service.persistence.ClusterGroupPersistence;
import com.liferay.portal.service.persistence.CompanyPersistence;
import com.liferay.portal.service.persistence.ContactPersistence;
import com.liferay.portal.service.persistence.CountryPersistence;
import com.liferay.portal.service.persistence.EmailAddressPersistence;
import com.liferay.portal.service.persistence.GroupPersistence;
import com.liferay.portal.service.persistence.ImagePersistence;
import com.liferay.portal.service.persistence.LayoutPersistence;
import com.liferay.portal.service.persistence.LayoutPrototypePersistence;
import com.liferay.portal.service.persistence.LayoutSetPersistence;
import com.liferay.portal.service.persistence.LayoutSetPrototypePersistence;
import com.liferay.portal.service.persistence.ListTypePersistence;
import com.liferay.portal.service.persistence.LockPersistence;
import com.liferay.portal.service.persistence.MembershipRequestPersistence;
import com.liferay.portal.service.persistence.OrgGroupPermissionPersistence;
import com.liferay.portal.service.persistence.OrgGroupRolePersistence;
import com.liferay.portal.service.persistence.OrgLaborPersistence;
import com.liferay.portal.service.persistence.OrganizationPersistence;
import com.liferay.portal.service.persistence.PasswordPolicyPersistence;
import com.liferay.portal.service.persistence.PasswordPolicyRelPersistence;
import com.liferay.portal.service.persistence.PasswordTrackerPersistence;
import com.liferay.portal.service.persistence.PermissionPersistence;
import com.liferay.portal.service.persistence.PhonePersistence;
import com.liferay.portal.service.persistence.PluginSettingPersistence;
import com.liferay.portal.service.persistence.PortletItemPersistence;
import com.liferay.portal.service.persistence.PortletPersistence;
import com.liferay.portal.service.persistence.PortletPreferencesPersistence;
import com.liferay.portal.service.persistence.RegionPersistence;
import com.liferay.portal.service.persistence.ReleasePersistence;
import com.liferay.portal.service.persistence.ResourceActionPersistence;
import com.liferay.portal.service.persistence.ResourceCodePersistence;
import com.liferay.portal.service.persistence.ResourcePermissionPersistence;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.RolePersistence;
import com.liferay.portal.service.persistence.ServiceComponentPersistence;
import com.liferay.portal.service.persistence.ShardPersistence;
import com.liferay.portal.service.persistence.SubscriptionPersistence;
import com.liferay.portal.service.persistence.TeamPersistence;
import com.liferay.portal.service.persistence.TicketPersistence;
import com.liferay.portal.service.persistence.UserGroupGroupRolePersistence;
import com.liferay.portal.service.persistence.UserGroupPersistence;
import com.liferay.portal.service.persistence.UserGroupRolePersistence;
import com.liferay.portal.service.persistence.UserIdMapperPersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.UserTrackerPathPersistence;
import com.liferay.portal.service.persistence.UserTrackerPersistence;
import com.liferay.portal.service.persistence.WebDAVPropsPersistence;
import com.liferay.portal.service.persistence.WebsitePersistence;
import com.liferay.portal.service.persistence.WorkflowDefinitionLinkPersistence;
import com.liferay.portal.service.persistence.WorkflowInstanceLinkPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyPersistenceImpl
extends BasePersistenceImpl<Company>
implements CompanyPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CompanyImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List";
    public static final FinderPath FINDER_PATH_FETCH_BY_WEBID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByWebId", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_WEBID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByWebId", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_VIRTUALHOST = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByVirtualHost", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_VIRTUALHOST = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByVirtualHost", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_MX = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByMx", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_MX = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByMx", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_LOGOID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByLogoId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_LOGOID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByLogoId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findBySystem", new String[]{Boolean.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countBySystem", new String[]{Boolean.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    @BeanReference(type=AccountPersistence.class)
    protected AccountPersistence accountPersistence;
    @BeanReference(type=AddressPersistence.class)
    protected AddressPersistence addressPersistence;
    @BeanReference(type=BrowserTrackerPersistence.class)
    protected BrowserTrackerPersistence browserTrackerPersistence;
    @BeanReference(type=ClassNamePersistence.class)
    protected ClassNamePersistence classNamePersistence;
    @BeanReference(type=ClusterGroupPersistence.class)
    protected ClusterGroupPersistence clusterGroupPersistence;
    @BeanReference(type=CompanyPersistence.class)
    protected CompanyPersistence companyPersistence;
    @BeanReference(type=ContactPersistence.class)
    protected ContactPersistence contactPersistence;
    @BeanReference(type=CountryPersistence.class)
    protected CountryPersistence countryPersistence;
    @BeanReference(type=EmailAddressPersistence.class)
    protected EmailAddressPersistence emailAddressPersistence;
    @BeanReference(type=GroupPersistence.class)
    protected GroupPersistence groupPersistence;
    @BeanReference(type=ImagePersistence.class)
    protected ImagePersistence imagePersistence;
    @BeanReference(type=LayoutPersistence.class)
    protected LayoutPersistence layoutPersistence;
    @BeanReference(type=LayoutPrototypePersistence.class)
    protected LayoutPrototypePersistence layoutPrototypePersistence;
    @BeanReference(type=LayoutSetPersistence.class)
    protected LayoutSetPersistence layoutSetPersistence;
    @BeanReference(type=LayoutSetPrototypePersistence.class)
    protected LayoutSetPrototypePersistence layoutSetPrototypePersistence;
    @BeanReference(type=ListTypePersistence.class)
    protected ListTypePersistence listTypePersistence;
    @BeanReference(type=LockPersistence.class)
    protected LockPersistence lockPersistence;
    @BeanReference(type=MembershipRequestPersistence.class)
    protected MembershipRequestPersistence membershipRequestPersistence;
    @BeanReference(type=OrganizationPersistence.class)
    protected OrganizationPersistence organizationPersistence;
    @BeanReference(type=OrgGroupPermissionPersistence.class)
    protected OrgGroupPermissionPersistence orgGroupPermissionPersistence;
    @BeanReference(type=OrgGroupRolePersistence.class)
    protected OrgGroupRolePersistence orgGroupRolePersistence;
    @BeanReference(type=OrgLaborPersistence.class)
    protected OrgLaborPersistence orgLaborPersistence;
    @BeanReference(type=PasswordPolicyPersistence.class)
    protected PasswordPolicyPersistence passwordPolicyPersistence;
    @BeanReference(type=PasswordPolicyRelPersistence.class)
    protected PasswordPolicyRelPersistence passwordPolicyRelPersistence;
    @BeanReference(type=PasswordTrackerPersistence.class)
    protected PasswordTrackerPersistence passwordTrackerPersistence;
    @BeanReference(type=PermissionPersistence.class)
    protected PermissionPersistence permissionPersistence;
    @BeanReference(type=PhonePersistence.class)
    protected PhonePersistence phonePersistence;
    @BeanReference(type=PluginSettingPersistence.class)
    protected PluginSettingPersistence pluginSettingPersistence;
    @BeanReference(type=PortletPersistence.class)
    protected PortletPersistence portletPersistence;
    @BeanReference(type=PortletItemPersistence.class)
    protected PortletItemPersistence portletItemPersistence;
    @BeanReference(type=PortletPreferencesPersistence.class)
    protected PortletPreferencesPersistence portletPreferencesPersistence;
    @BeanReference(type=RegionPersistence.class)
    protected RegionPersistence regionPersistence;
    @BeanReference(type=ReleasePersistence.class)
    protected ReleasePersistence releasePersistence;
    @BeanReference(type=ResourcePersistence.class)
    protected ResourcePersistence resourcePersistence;
    @BeanReference(type=ResourceActionPersistence.class)
    protected ResourceActionPersistence resourceActionPersistence;
    @BeanReference(type=ResourceCodePersistence.class)
    protected ResourceCodePersistence resourceCodePersistence;
    @BeanReference(type=ResourcePermissionPersistence.class)
    protected ResourcePermissionPersistence resourcePermissionPersistence;
    @BeanReference(type=RolePersistence.class)
    protected RolePersistence rolePersistence;
    @BeanReference(type=ServiceComponentPersistence.class)
    protected ServiceComponentPersistence serviceComponentPersistence;
    @BeanReference(type=ShardPersistence.class)
    protected ShardPersistence shardPersistence;
    @BeanReference(type=SubscriptionPersistence.class)
    protected SubscriptionPersistence subscriptionPersistence;
    @BeanReference(type=TicketPersistence.class)
    protected TicketPersistence ticketPersistence;
    @BeanReference(type=TeamPersistence.class)
    protected TeamPersistence teamPersistence;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    @BeanReference(type=UserGroupPersistence.class)
    protected UserGroupPersistence userGroupPersistence;
    @BeanReference(type=UserGroupGroupRolePersistence.class)
    protected UserGroupGroupRolePersistence userGroupGroupRolePersistence;
    @BeanReference(type=UserGroupRolePersistence.class)
    protected UserGroupRolePersistence userGroupRolePersistence;
    @BeanReference(type=UserIdMapperPersistence.class)
    protected UserIdMapperPersistence userIdMapperPersistence;
    @BeanReference(type=UserTrackerPersistence.class)
    protected UserTrackerPersistence userTrackerPersistence;
    @BeanReference(type=UserTrackerPathPersistence.class)
    protected UserTrackerPathPersistence userTrackerPathPersistence;
    @BeanReference(type=WebDAVPropsPersistence.class)
    protected WebDAVPropsPersistence webDAVPropsPersistence;
    @BeanReference(type=WebsitePersistence.class)
    protected WebsitePersistence websitePersistence;
    @BeanReference(type=WorkflowDefinitionLinkPersistence.class)
    protected WorkflowDefinitionLinkPersistence workflowDefinitionLinkPersistence;
    @BeanReference(type=WorkflowInstanceLinkPersistence.class)
    protected WorkflowInstanceLinkPersistence workflowInstanceLinkPersistence;
    private static final String _SQL_SELECT_COMPANY = "SELECT company FROM Company company";
    private static final String _SQL_SELECT_COMPANY_WHERE = "SELECT company FROM Company company WHERE ";
    private static final String _SQL_COUNT_COMPANY = "SELECT COUNT(company) FROM Company company";
    private static final String _SQL_COUNT_COMPANY_WHERE = "SELECT COUNT(company) FROM Company company WHERE ";
    private static final String _FINDER_COLUMN_WEBID_WEBID_1 = "company.webId IS NULL";
    private static final String _FINDER_COLUMN_WEBID_WEBID_2 = "company.webId = ?";
    private static final String _FINDER_COLUMN_WEBID_WEBID_3 = "(company.webId IS NULL OR company.webId = ?)";
    private static final String _FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_1 = "company.virtualHost IS NULL";
    private static final String _FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_2 = "company.virtualHost = ?";
    private static final String _FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_3 = "(company.virtualHost IS NULL OR company.virtualHost = ?)";
    private static final String _FINDER_COLUMN_MX_MX_1 = "company.mx IS NULL";
    private static final String _FINDER_COLUMN_MX_MX_2 = "company.mx = ?";
    private static final String _FINDER_COLUMN_MX_MX_3 = "(company.mx IS NULL OR company.mx = ?)";
    private static final String _FINDER_COLUMN_LOGOID_LOGOID_2 = "company.logoId = ?";
    private static final String _FINDER_COLUMN_SYSTEM_SYSTEM_2 = "company.system = ?";
    private static final String _ORDER_BY_ENTITY_ALIAS = "company.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Company exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Company exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(CompanyPersistenceImpl.class);

    public void cacheResult(Company company) {
        EntityCacheUtil.putResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (Object)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])new Object[]{company.getWebId()}, (Object)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])new Object[]{company.getVirtualHost()}, (Object)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])new Object[]{company.getMx()}, (Object)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])new Object[]{new Long(company.getLogoId())}, (Object)company);
    }

    public void cacheResult(List<Company> companies) {
        for (Company company : companies) {
            if (EntityCacheUtil.getResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(company);
        }
    }

    public void clearCache() {
        CacheRegistryUtil.clear((String)CompanyImpl.class.getName());
        EntityCacheUtil.clearCache((String)CompanyImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public void clearCache(Company company) {
        EntityCacheUtil.removeResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()));
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])new Object[]{company.getWebId()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])new Object[]{company.getVirtualHost()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])new Object[]{company.getMx()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])new Object[]{new Long(company.getLogoId())});
    }

    public Company create(long companyId) {
        CompanyImpl company = new CompanyImpl();
        company.setNew(true);
        company.setPrimaryKey(companyId);
        return company;
    }

    public Company remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public Company remove(long companyId) throws NoSuchCompanyException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            Company company = (Company)session.get(CompanyImpl.class, (Serializable)new Long(companyId));
            if (company == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + companyId));
                }
                throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + companyId);
            }
            Company company2 = (Company)this.remove((BaseModel)company);
            return company2;
        }
        catch (NoSuchCompanyException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Company removeImpl(Company company) throws SystemException {
        company = this.toUnwrappedModel(company);
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.delete((Session)session, (BaseModel)company);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        CompanyModelImpl companyModelImpl = (CompanyModelImpl)company;
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])new Object[]{companyModelImpl.getWebId()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])new Object[]{companyModelImpl.getVirtualHost()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])new Object[]{companyModelImpl.getMx()});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])new Object[]{new Long(companyModelImpl.getLogoId())});
        EntityCacheUtil.removeResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()));
        return company;
    }

    public Company updateImpl(Company company, boolean merge) throws SystemException {
        company = this.toUnwrappedModel(company);
        boolean isNew = company.isNew();
        CompanyModelImpl companyModelImpl = (CompanyModelImpl)company;
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.update((Session)session, (BaseModel)company, (boolean)merge);
                company.setNew(false);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (Object)company);
        if (!isNew && !Validator.equals((Object)company.getWebId(), (Object)companyModelImpl.getOriginalWebId())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])new Object[]{companyModelImpl.getOriginalWebId()});
        }
        if (isNew || !Validator.equals((Object)company.getWebId(), (Object)companyModelImpl.getOriginalWebId())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])new Object[]{company.getWebId()}, (Object)company);
        }
        if (!isNew && !Validator.equals((Object)company.getVirtualHost(), (Object)companyModelImpl.getOriginalVirtualHost())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])new Object[]{companyModelImpl.getOriginalVirtualHost()});
        }
        if (isNew || !Validator.equals((Object)company.getVirtualHost(), (Object)companyModelImpl.getOriginalVirtualHost())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])new Object[]{company.getVirtualHost()}, (Object)company);
        }
        if (!isNew && !Validator.equals((Object)company.getMx(), (Object)companyModelImpl.getOriginalMx())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])new Object[]{companyModelImpl.getOriginalMx()});
        }
        if (isNew || !Validator.equals((Object)company.getMx(), (Object)companyModelImpl.getOriginalMx())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])new Object[]{company.getMx()}, (Object)company);
        }
        if (!isNew && company.getLogoId() != companyModelImpl.getOriginalLogoId()) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])new Object[]{new Long(companyModelImpl.getOriginalLogoId())});
        }
        if (isNew || company.getLogoId() != companyModelImpl.getOriginalLogoId()) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])new Object[]{new Long(company.getLogoId())}, (Object)company);
        }
        return company;
    }

    protected Company toUnwrappedModel(Company company) {
        if (company instanceof CompanyImpl) {
            return company;
        }
        CompanyImpl companyImpl = new CompanyImpl();
        companyImpl.setNew(company.isNew());
        companyImpl.setPrimaryKey(company.getPrimaryKey());
        companyImpl.setCompanyId(company.getCompanyId());
        companyImpl.setAccountId(company.getAccountId());
        companyImpl.setWebId(company.getWebId());
        companyImpl.setKey(company.getKey());
        companyImpl.setVirtualHost(company.getVirtualHost());
        companyImpl.setMx(company.getMx());
        companyImpl.setHomeURL(company.getHomeURL());
        companyImpl.setLogoId(company.getLogoId());
        companyImpl.setSystem(company.isSystem());
        companyImpl.setMaxUsers(company.getMaxUsers());
        return companyImpl;
    }

    public Company findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public Company findByPrimaryKey(long companyId) throws NoSuchCompanyException, SystemException {
        Company company = this.fetchByPrimaryKey(companyId);
        if (company == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + companyId));
            }
            throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + companyId);
        }
        return company;
    }

    public Company fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public Company fetchByPrimaryKey(long companyId) throws SystemException {
        Company company = (Company)EntityCacheUtil.getResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(companyId), (SessionFactory)this);
        if (company == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    company = (Company)session.get(CompanyImpl.class, (Serializable)new Long(companyId));
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (company != null) {
                    this.cacheResult(company);
                }
                this.closeSession(session);
            }
        }
        return company;
    }

    public Company findByWebId(String webId) throws NoSuchCompanyException, SystemException {
        Company company = this.fetchByWebId(webId);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("webId=");
            msg.append(webId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByWebId(String webId) throws SystemException {
        return this.fetchByWebId(webId, true);
    }

    public Company fetchByWebId(String webId, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{webId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            if (webId == null) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_1);
            } else if (webId.equals("")) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_3);
            } else {
                query.append(_FINDER_COLUMN_WEBID_WEBID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (webId != null) {
                    qPos.add(webId);
                }
                List list = q.list();
                result = list;
                Company company = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs, (Object)list);
                } else {
                    company = (Company)list.get(0);
                    this.cacheResult(company);
                    if (company.getWebId() == null || !company.getWebId().equals(webId)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs, (Object)company);
                    }
                }
                Company company2 = company;
                return company2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company findByVirtualHost(String virtualHost) throws NoSuchCompanyException, SystemException {
        Company company = this.fetchByVirtualHost(virtualHost);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("virtualHost=");
            msg.append(virtualHost);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByVirtualHost(String virtualHost) throws SystemException {
        return this.fetchByVirtualHost(virtualHost, true);
    }

    public Company fetchByVirtualHost(String virtualHost, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{virtualHost};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            if (virtualHost == null) {
                query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_1);
            } else if (virtualHost.equals("")) {
                query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_3);
            } else {
                query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (virtualHost != null) {
                    qPos.add(virtualHost);
                }
                List list = q.list();
                result = list;
                Company company = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])finderArgs, (Object)list);
                } else {
                    company = (Company)list.get(0);
                    this.cacheResult(company);
                    if (company.getVirtualHost() == null || !company.getVirtualHost().equals(virtualHost)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])finderArgs, (Object)company);
                    }
                }
                Company company2 = company;
                return company2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_VIRTUALHOST, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company findByMx(String mx) throws NoSuchCompanyException, SystemException {
        Company company = this.fetchByMx(mx);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("mx=");
            msg.append(mx);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByMx(String mx) throws SystemException {
        return this.fetchByMx(mx, true);
    }

    public Company fetchByMx(String mx, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{mx};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            if (mx == null) {
                query.append(_FINDER_COLUMN_MX_MX_1);
            } else if (mx.equals("")) {
                query.append(_FINDER_COLUMN_MX_MX_3);
            } else {
                query.append(_FINDER_COLUMN_MX_MX_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (mx != null) {
                    qPos.add(mx);
                }
                List list = q.list();
                result = list;
                Company company = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs, (Object)list);
                } else {
                    company = (Company)list.get(0);
                    this.cacheResult(company);
                    if (company.getMx() == null || !company.getMx().equals(mx)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs, (Object)company);
                    }
                }
                Company company2 = company;
                return company2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company findByLogoId(long logoId) throws NoSuchCompanyException, SystemException {
        Company company = this.fetchByLogoId(logoId);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("logoId=");
            msg.append(logoId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByLogoId(long logoId) throws SystemException {
        return this.fetchByLogoId(logoId, true);
    }

    public Company fetchByLogoId(long logoId, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{logoId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(logoId);
                List list = q.list();
                result = list;
                Company company = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs, (Object)list);
                } else {
                    company = (Company)list.get(0);
                    this.cacheResult(company);
                    if (company.getLogoId() != logoId) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs, (Object)company);
                    }
                }
                Company company2 = company;
                return company2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public List<Company> findBySystem(boolean system) throws SystemException {
        return this.findBySystem(system, -1, -1, null);
    }

    public List<Company> findBySystem(boolean system, int start, int end) throws SystemException {
        return this.findBySystem(system, start, end, null);
    }

    public List<Company> findBySystem(boolean system, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{system, String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_SYSTEM, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(2);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(system);
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_BY_SYSTEM, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_SYSTEM, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public Company findBySystem_First(boolean system, OrderByComparator orderByComparator) throws NoSuchCompanyException, SystemException {
        List<Company> list = this.findBySystem(system, 0, 1, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("system=");
            msg.append(system);
            msg.append("}");
            throw new NoSuchCompanyException(msg.toString());
        }
        return list.get(0);
    }

    public Company findBySystem_Last(boolean system, OrderByComparator orderByComparator) throws NoSuchCompanyException, SystemException {
        int count = this.countBySystem(system);
        List<Company> list = this.findBySystem(system, count - 1, count, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("system=");
            msg.append(system);
            msg.append("}");
            throw new NoSuchCompanyException(msg.toString());
        }
        return list.get(0);
    }

    public Company[] findBySystem_PrevAndNext(long companyId, boolean system, OrderByComparator orderByComparator) throws NoSuchCompanyException, SystemException {
        Company company = this.findByPrimaryKey(companyId);
        Session session = null;
        try {
            session = this.openSession();
            Company[] array = new CompanyImpl[]{this.getBySystem_PrevAndNext(session, company, system, orderByComparator, true), company, this.getBySystem_PrevAndNext(session, company, system, orderByComparator, false)};
            Company[] companyArray = array;
            return companyArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Company getBySystem_PrevAndNext(Session session, Company company, boolean system, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_COMPANY_WHERE);
        query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
        if (orderByComparator != null) {
            String[] orderByFields = orderByComparator.getOrderByFields();
            if (orderByFields.length > 0) {
                query.append(" AND ");
            }
            int i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i;
            }
            query.append(" ORDER BY ");
            i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i;
            }
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(system);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByValues((Object)company);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Company)list.get(1);
        }
        return null;
    }

    public List<Company> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<Company> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<Company> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_COMPANY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COMPANY;
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (orderByComparator == null) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByWebId(String webId) throws NoSuchCompanyException, SystemException {
        Company company = this.findByWebId(webId);
        this.remove((BaseModel)company);
    }

    public void removeByVirtualHost(String virtualHost) throws NoSuchCompanyException, SystemException {
        Company company = this.findByVirtualHost(virtualHost);
        this.remove((BaseModel)company);
    }

    public void removeByMx(String mx) throws NoSuchCompanyException, SystemException {
        Company company = this.findByMx(mx);
        this.remove((BaseModel)company);
    }

    public void removeByLogoId(long logoId) throws NoSuchCompanyException, SystemException {
        Company company = this.findByLogoId(logoId);
        this.remove((BaseModel)company);
    }

    public void removeBySystem(boolean system) throws SystemException {
        for (Company company : this.findBySystem(system)) {
            this.remove((BaseModel)company);
        }
    }

    public void removeAll() throws SystemException {
        for (Company company : this.findAll()) {
            this.remove((BaseModel)company);
        }
    }

    public int countByWebId(String webId) throws SystemException {
        Object[] finderArgs = new Object[]{webId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_WEBID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            if (webId == null) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_1);
            } else if (webId.equals("")) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_3);
            } else {
                query.append(_FINDER_COLUMN_WEBID_WEBID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (webId != null) {
                        qPos.add(webId);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_WEBID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByVirtualHost(String virtualHost) throws SystemException {
        Object[] finderArgs = new Object[]{virtualHost};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_VIRTUALHOST, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            if (virtualHost == null) {
                query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_1);
            } else if (virtualHost.equals("")) {
                query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_3);
            } else {
                query.append(_FINDER_COLUMN_VIRTUALHOST_VIRTUALHOST_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (virtualHost != null) {
                        qPos.add(virtualHost);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_VIRTUALHOST, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByMx(String mx) throws SystemException {
        Object[] finderArgs = new Object[]{mx};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_MX, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            if (mx == null) {
                query.append(_FINDER_COLUMN_MX_MX_1);
            } else if (mx.equals("")) {
                query.append(_FINDER_COLUMN_MX_MX_3);
            } else {
                query.append(_FINDER_COLUMN_MX_MX_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (mx != null) {
                        qPos.add(mx);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_MX, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByLogoId(long logoId) throws SystemException {
        Object[] finderArgs = new Object[]{logoId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_LOGOID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(logoId);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_LOGOID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countBySystem(boolean system) throws SystemException {
        Object[] finderArgs = new Object[]{system};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_SYSTEM, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(system);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_SYSTEM, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_COMPANY);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portal.model.Company")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)CompanyImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST);
    }
}

