/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortletPermission;
import com.liferay.portal.util.PropsValues;
import java.util.List;

public class PortletPermissionImpl
implements PortletPermission {
    public static final boolean DEFAULT_STRICT = false;
    private static Log _log = LogFactoryUtil.getLog(PortletPermissionImpl.class);

    public void check(PermissionChecker permissionChecker, long plid, String portletId, String actionId) throws PortalException, SystemException {
        this.check(permissionChecker, plid, portletId, actionId, false);
    }

    public void check(PermissionChecker permissionChecker, long plid, String portletId, String actionId, boolean strict) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, plid, portletId, actionId, strict)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, String portletId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, portletId, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, Portlet portlet, String actionId) throws PortalException, SystemException {
        return this.contains(permissionChecker, plid, portlet, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, Portlet portlet, String actionId, boolean strict) throws PortalException, SystemException {
        if (portlet.isUndeployedPortlet()) {
            return false;
        }
        boolean value = this.contains(permissionChecker, plid, portlet.getPortletId(), actionId, strict);
        if (value) {
            return true;
        }
        return portlet.isSystem() && actionId.equals("VIEW");
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, String portletId, String actionId) throws PortalException, SystemException {
        return this.contains(permissionChecker, plid, portletId, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, String portletId, String actionId, boolean strict) throws PortalException, SystemException {
        long groupId = 0L;
        String name = null;
        String primKey = null;
        if (plid > 0L) {
            Group group;
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            groupId = layout.getGroupId();
            name = PortletConstants.getRootPortletId((String)portletId);
            primKey = this.getPrimaryKey(plid, portletId);
            if ((layout.isPrivateLayout() && !PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_MODIFIABLE || layout.isPublicLayout() && !PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_MODIFIABLE) && actionId.equals("CONFIGURATION") && (group = GroupLocalServiceUtil.getGroup((long)layout.getGroupId())).isUser()) {
                return false;
            }
            if (actionId.equals("VIEW") && (group = GroupLocalServiceUtil.getGroup((long)layout.getGroupId())).isControlPanel()) {
                return true;
            }
            if (!strict && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)"UPDATE") && this.hasLayoutManagerPermission(portletId, actionId)) {
                return true;
            }
        } else {
            name = portletId;
            primKey = portletId;
        }
        return permissionChecker.hasPermission(groupId, name, primKey, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, String portletId, String actionId) throws PortalException, SystemException {
        return this.contains(permissionChecker, 0L, portletId, actionId);
    }

    public String getPrimaryKey(long plid, String portletId) {
        return String.valueOf(plid).concat("_LAYOUT_").concat(portletId);
    }

    public boolean hasLayoutManagerPermission(String portletId, String actionId) {
        try {
            return this.hasLayoutManagerPermissionImpl(portletId, actionId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected boolean hasLayoutManagerPermissionImpl(String portletId, String actionId) {
        portletId = PortletConstants.getRootPortletId((String)portletId);
        List<String> layoutManagerActions = ResourceActionsUtil.getPortletResourceLayoutManagerActions(portletId);
        return layoutManagerActions.contains(actionId);
    }
}

