/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.WebsiteURLException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.Website;
import com.liferay.portal.service.base.WebsiteLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebsiteLocalServiceImpl
extends WebsiteLocalServiceBaseImpl {
    public Website addWebsite(long userId, String className, long classPK, String url, int typeId, boolean primary) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        this.validate(0L, user.getCompanyId(), classNameId, classPK, url, typeId, primary);
        long websiteId = this.counterLocalService.increment();
        Website website = this.websitePersistence.create(websiteId);
        website.setCompanyId(user.getCompanyId());
        website.setUserId(user.getUserId());
        website.setUserName(user.getFullName());
        website.setCreateDate(now);
        website.setModifiedDate(now);
        website.setClassNameId(classNameId);
        website.setClassPK(classPK);
        website.setUrl(url);
        website.setTypeId(typeId);
        website.setPrimary(primary);
        this.websitePersistence.update((BaseModel)website, false);
        return website;
    }

    @Override
    public void deleteWebsite(long websiteId) throws PortalException, SystemException {
        this.websitePersistence.remove(websiteId);
    }

    public void deleteWebsites(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.websitePersistence.removeByC_C_C(companyId, classNameId, classPK);
    }

    @Override
    public Website getWebsite(long websiteId) throws PortalException, SystemException {
        return this.websitePersistence.findByPrimaryKey(websiteId);
    }

    public List<Website> getWebsites() throws SystemException {
        return this.websitePersistence.findAll();
    }

    public List<Website> getWebsites(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.websitePersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public Website updateWebsite(long websiteId, String url, int typeId, boolean primary) throws PortalException, SystemException {
        this.validate(websiteId, 0L, 0L, 0L, url, typeId, primary);
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        website.setModifiedDate(new Date());
        website.setUrl(url);
        website.setTypeId(typeId);
        website.setPrimary(primary);
        this.websitePersistence.update((BaseModel)website, false);
        return website;
    }

    protected void validate(long websiteId, long companyId, long classNameId, long classPK, String url, int typeId, boolean primary) throws PortalException, SystemException {
        if (!Validator.isUrl((String)url)) {
            throw new WebsiteURLException();
        }
        if (websiteId > 0L) {
            Website website = this.websitePersistence.findByPrimaryKey(websiteId);
            companyId = website.getCompanyId();
            classNameId = website.getClassNameId();
            classPK = website.getClassPK();
        }
        this.listTypeService.validate(typeId, classNameId, ".website");
        this.validate(websiteId, companyId, classNameId, classPK, primary);
    }

    protected void validate(long websiteId, long companyId, long classNameId, long classPK, boolean primary) throws SystemException {
        if (primary) {
            for (Website website : this.websitePersistence.findByC_C_C_P(companyId, classNameId, classPK, primary)) {
                if (websiteId > 0L && website.getWebsiteId() == websiteId) continue;
                website.setPrimary(false);
                this.websitePersistence.update((BaseModel)website, false);
            }
        }
    }
}

