/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.SpriteProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.PluginSetting;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.ColorSchemeImpl;
import com.liferay.portal.model.impl.ThemeImpl;
import com.liferay.portal.plugin.PluginUtil;
import com.liferay.portal.service.base.ThemeLocalServiceBaseImpl;
import com.liferay.portal.theme.ThemeCompanyId;
import com.liferay.portal.theme.ThemeCompanyLimit;
import com.liferay.portal.theme.ThemeGroupId;
import com.liferay.portal.theme.ThemeGroupLimit;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.ContextReplace;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeLocalServiceImpl
extends ThemeLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(ThemeLocalServiceImpl.class);
    private static Map<String, Theme> _themes = new ConcurrentHashMap<String, Theme>();
    private static Map<Long, Map<String, Theme>> _themesPool = new ConcurrentHashMap<Long, Map<String, Theme>>();

    public ColorScheme getColorScheme(long companyId, String themeId, String colorSchemeId, boolean wapTheme) throws SystemException {
        List colorSchemes;
        colorSchemeId = GetterUtil.getString((String)colorSchemeId);
        Theme theme = this.getTheme(companyId, themeId, wapTheme);
        Map colorSchemesMap = theme.getColorSchemesMap();
        ColorScheme colorScheme = (ColorScheme)colorSchemesMap.get(colorSchemeId);
        if (colorScheme == null && (colorSchemes = theme.getColorSchemes()).size() > 0) {
            int i = colorSchemes.size() - 1;
            while (i >= 0) {
                colorScheme = (ColorScheme)colorSchemes.get(i);
                if (colorScheme.isDefaultCs()) break;
                --i;
            }
        }
        if (colorScheme == null) {
            colorSchemeId = wapTheme ? ColorSchemeImpl.getDefaultWapColorSchemeId() : ColorSchemeImpl.getDefaultRegularColorSchemeId();
        }
        if (colorScheme == null) {
            colorScheme = ColorSchemeImpl.getNullColorScheme();
        }
        return colorScheme;
    }

    public Theme getTheme(long companyId, String themeId, boolean wapTheme) throws SystemException {
        themeId = GetterUtil.getString((String)themeId);
        Theme theme = this._getThemes(companyId).get(themeId);
        if (theme == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No theme found for specified theme id " + themeId + ". Returning the default theme."));
            }
            themeId = wapTheme ? ThemeImpl.getDefaultWapThemeId(companyId) : ThemeImpl.getDefaultRegularThemeId(companyId);
            theme = _themes.get(themeId);
        }
        if (theme == null) {
            if (_themes.isEmpty()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"No themes are installed");
                }
                return null;
            }
            _log.error((Object)("No theme found for default theme id " + themeId + ". Returning a random theme."));
            for (Map.Entry<String, Theme> entry : _themes.entrySet()) {
                theme = entry.getValue();
            }
        }
        return theme;
    }

    public List<Theme> getThemes(long companyId) {
        List themes = ListUtil.fromCollection(this._getThemes(companyId).values());
        return ListUtil.sort((List)themes);
    }

    public List<Theme> getThemes(long companyId, long groupId, long userId, boolean wapTheme) throws SystemException {
        List<Theme> themes = this.getThemes(companyId);
        themes = PluginUtil.restrictPlugins(themes, companyId, userId);
        Iterator<Theme> itr = themes.iterator();
        while (itr.hasNext()) {
            Theme theme = itr.next();
            if (!theme.getThemeId().equals("controlpanel") && theme.isGroupAvailable(groupId) && theme.isWapTheme() == wapTheme) continue;
            itr.remove();
        }
        return themes;
    }

    public List<Theme> getWARThemes() {
        List themes = ListUtil.fromCollection(_themes.values());
        Iterator itr = themes.iterator();
        while (itr.hasNext()) {
            Theme theme = (Theme)itr.next();
            if (theme.isWARFile()) continue;
            itr.remove();
        }
        return themes;
    }

    public List<String> init(ServletContext servletContext, String themesPath, boolean loadFromServletContext, String[] xmls, PluginPackage pluginPackage) {
        return this.init(null, servletContext, themesPath, loadFromServletContext, xmls, pluginPackage);
    }

    public List<String> init(String servletContextName, ServletContext servletContext, String themesPath, boolean loadFromServletContext, String[] xmls, PluginPackage pluginPackage) {
        ArrayList<String> themeIds = new ArrayList<String>();
        try {
            int i = 0;
            while (i < xmls.length) {
                Set<String> themes = this._readThemes(servletContextName, servletContext, themesPath, loadFromServletContext, xmls[i], pluginPackage);
                for (String themeId : themes) {
                    if (themeIds.contains(themeId)) continue;
                    themeIds.add(themeId);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        _themesPool.clear();
        return themeIds;
    }

    public void uninstallThemes(List<String> themeIds) {
        int i = 0;
        while (i < themeIds.size()) {
            String themeId = themeIds.get(i);
            _themes.remove(themeId);
            this.layoutTemplateLocalService.uninstallLayoutTemplates(themeId);
            ++i;
        }
        _themesPool.clear();
    }

    private List<ThemeCompanyId> _getCompanyLimitExcludes(Element el) {
        ArrayList<ThemeCompanyId> includes = new ArrayList<ThemeCompanyId>();
        if (el != null) {
            List companyIds = el.elements("company-id");
            int i = 0;
            while (i < companyIds.size()) {
                Element companyIdEl = (Element)companyIds.get(i);
                String name = companyIdEl.attributeValue("name");
                String pattern = companyIdEl.attributeValue("pattern");
                ThemeCompanyId themeCompanyId = null;
                if (Validator.isNotNull((String)name)) {
                    themeCompanyId = new ThemeCompanyId(name, false);
                } else if (Validator.isNotNull((String)pattern)) {
                    themeCompanyId = new ThemeCompanyId(pattern, true);
                }
                if (themeCompanyId != null) {
                    includes.add(themeCompanyId);
                }
                ++i;
            }
        }
        return includes;
    }

    private List<ThemeCompanyId> _getCompanyLimitIncludes(Element el) {
        return this._getCompanyLimitExcludes(el);
    }

    private List<ThemeGroupId> _getGroupLimitExcludes(Element el) {
        ArrayList<ThemeGroupId> includes = new ArrayList<ThemeGroupId>();
        if (el != null) {
            List groupIds = el.elements("group-id");
            int i = 0;
            while (i < groupIds.size()) {
                Element groupIdEl = (Element)groupIds.get(i);
                String name = groupIdEl.attributeValue("name");
                String pattern = groupIdEl.attributeValue("pattern");
                ThemeGroupId themeGroupId = null;
                if (Validator.isNotNull((String)name)) {
                    themeGroupId = new ThemeGroupId(name, false);
                } else if (Validator.isNotNull((String)pattern)) {
                    themeGroupId = new ThemeGroupId(pattern, true);
                }
                if (themeGroupId != null) {
                    includes.add(themeGroupId);
                }
                ++i;
            }
        }
        return includes;
    }

    private List<ThemeGroupId> _getGroupLimitIncludes(Element el) {
        return this._getGroupLimitExcludes(el);
    }

    private Map<String, Theme> _getThemes(long companyId) {
        Map<String, Theme> themes = _themesPool.get(companyId);
        if (themes == null) {
            themes = new ConcurrentHashMap<String, Theme>();
            for (Map.Entry<String, Theme> entry : _themes.entrySet()) {
                String themeId = entry.getKey();
                Theme theme = entry.getValue();
                if (!theme.isCompanyAvailable(companyId)) continue;
                themes.put(themeId, theme);
            }
            _themesPool.put(companyId, themes);
        }
        return themes;
    }

    private Version _getVersion(String version) {
        if (version.equals("${current-version}")) {
            version = ReleaseInfo.getVersion();
        }
        return Version.getInstance((String)version);
    }

    private void _readColorSchemes(Element theme, Map<String, ColorScheme> colorSchemes, ContextReplace themeContextReplace) {
        for (Element colorScheme : theme.elements("color-scheme")) {
            ContextReplace colorSchemeContextReplace = (ContextReplace)themeContextReplace.clone();
            String id = colorScheme.attributeValue("id");
            colorSchemeContextReplace.addValue("color-scheme-id", id);
            ColorScheme colorSchemeModel = colorSchemes.get(id);
            if (colorSchemeModel == null) {
                colorSchemeModel = new ColorSchemeImpl(id);
            }
            String name = GetterUtil.getString((String)colorScheme.attributeValue("name"), (String)colorSchemeModel.getName());
            name = colorSchemeContextReplace.replace(name);
            boolean defaultCs = GetterUtil.getBoolean((String)colorScheme.elementText("default-cs"), (boolean)colorSchemeModel.isDefaultCs());
            String cssClass = GetterUtil.getString((String)colorScheme.elementText("css-class"), (String)colorSchemeModel.getCssClass());
            cssClass = colorSchemeContextReplace.replace(cssClass);
            colorSchemeContextReplace.addValue("css-class", cssClass);
            String colorSchemeImagesPath = GetterUtil.getString((String)colorScheme.elementText("color-scheme-images-path"), (String)colorSchemeModel.getColorSchemeImagesPath());
            colorSchemeImagesPath = colorSchemeContextReplace.replace(colorSchemeImagesPath);
            colorSchemeContextReplace.addValue("color-scheme-images-path", colorSchemeImagesPath);
            colorSchemeModel.setName(name);
            colorSchemeModel.setDefaultCs(defaultCs);
            colorSchemeModel.setCssClass(cssClass);
            colorSchemeModel.setColorSchemeImagesPath(colorSchemeImagesPath);
            colorSchemes.put(id, colorSchemeModel);
        }
    }

    private Set<String> _readThemes(String servletContextName, ServletContext servletContext, String themesPath, boolean loadFromServletContext, String xml, PluginPackage pluginPackage) throws Exception {
        HashSet<String> themeIds = new HashSet<String>();
        if (xml == null) {
            return themeIds;
        }
        Document doc = SAXReaderUtil.read((String)xml, (boolean)true);
        Element root = doc.getRootElement();
        Version portalVersion = this._getVersion(ReleaseInfo.getVersion());
        boolean compatible = false;
        Element compatibilityEl = root.element("compatibility");
        if (compatibilityEl != null) {
            for (Element versionEl : compatibilityEl.elements("version")) {
                Version version = this._getVersion(versionEl.getTextTrim());
                if (!version.includes(portalVersion)) continue;
                compatible = true;
                break;
            }
        }
        if (!compatible) {
            _log.error((Object)("Themes in this WAR are not compatible with " + ReleaseInfo.getServerInfo()));
            return themeIds;
        }
        ThemeCompanyLimit companyLimit = null;
        Element companyLimitEl = root.element("company-limit");
        if (companyLimitEl != null) {
            Element companyExcludesEl;
            companyLimit = new ThemeCompanyLimit();
            Element companyIncludesEl = companyLimitEl.element("company-includes");
            if (companyIncludesEl != null) {
                companyLimit.setIncludes(this._getCompanyLimitIncludes(companyIncludesEl));
            }
            if ((companyExcludesEl = companyLimitEl.element("company-excludes")) != null) {
                companyLimit.setExcludes(this._getCompanyLimitExcludes(companyExcludesEl));
            }
        }
        ThemeGroupLimit groupLimit = null;
        Element groupLimitEl = root.element("group-limit");
        if (groupLimitEl != null) {
            Element groupExcludesEl;
            groupLimit = new ThemeGroupLimit();
            Element groupIncludesEl = groupLimitEl.element("group-includes");
            if (groupIncludesEl != null) {
                groupLimit.setIncludes(this._getGroupLimitIncludes(groupIncludesEl));
            }
            if ((groupExcludesEl = groupLimitEl.element("group-excludes")) != null) {
                groupLimit.setExcludes(this._getGroupLimitExcludes(groupExcludesEl));
            }
        }
        long timestamp = ServletContextUtil.getLastModified((ServletContext)servletContext);
        for (Element theme : root.elements("theme")) {
            ContextReplace themeContextReplace = new ContextReplace();
            themeContextReplace.addValue("themes-path", themesPath);
            String themeId = theme.attributeValue("id");
            if (servletContextName != null) {
                themeId = String.valueOf(themeId) + "_WAR_" + servletContextName;
            }
            themeId = PortalUtil.getJsSafePortletId((String)themeId);
            themeContextReplace.addValue("theme-id", themeId);
            themeIds.add(themeId);
            Theme themeModel = _themes.get(themeId);
            if (themeModel == null) {
                themeModel = new ThemeImpl(themeId);
                _themes.put(themeId, themeModel);
            }
            themeModel.setTimestamp(timestamp);
            PluginSetting pluginSetting = this.pluginSettingLocalService.getDefaultPluginSetting();
            themeModel.setPluginPackage(pluginPackage);
            themeModel.setDefaultPluginSetting(pluginSetting);
            themeModel.setThemeCompanyLimit(companyLimit);
            themeModel.setThemeGroupLimit(groupLimit);
            if (servletContextName != null) {
                themeModel.setServletContextName(servletContextName);
            }
            themeModel.setLoadFromServletContext(loadFromServletContext);
            String name = GetterUtil.getString((String)theme.attributeValue("name"), (String)themeModel.getName());
            String rootPath = GetterUtil.getString((String)theme.elementText("root-path"), (String)themeModel.getRootPath());
            rootPath = themeContextReplace.replace(rootPath);
            themeContextReplace.addValue("root-path", rootPath);
            String templatesPath = GetterUtil.getString((String)theme.elementText("templates-path"), (String)themeModel.getTemplatesPath());
            templatesPath = themeContextReplace.replace(templatesPath);
            templatesPath = StringUtil.safePath((String)templatesPath);
            themeContextReplace.addValue("templates-path", templatesPath);
            String cssPath = GetterUtil.getString((String)theme.elementText("css-path"), (String)themeModel.getCssPath());
            cssPath = themeContextReplace.replace(cssPath);
            cssPath = StringUtil.safePath((String)cssPath);
            themeContextReplace.addValue("css-path", cssPath);
            String imagesPath = GetterUtil.getString((String)theme.elementText("images-path"), (String)themeModel.getImagesPath());
            imagesPath = themeContextReplace.replace(imagesPath);
            imagesPath = StringUtil.safePath((String)imagesPath);
            themeContextReplace.addValue("images-path", imagesPath);
            String javaScriptPath = GetterUtil.getString((String)theme.elementText("javascript-path"), (String)themeModel.getJavaScriptPath());
            javaScriptPath = themeContextReplace.replace(javaScriptPath);
            javaScriptPath = StringUtil.safePath((String)javaScriptPath);
            themeContextReplace.addValue("javascript-path", javaScriptPath);
            String virtualPath = GetterUtil.getString((String)theme.elementText("virtual-path"), (String)themeModel.getVirtualPath());
            String templateExtension = GetterUtil.getString((String)theme.elementText("template-extension"), (String)themeModel.getTemplateExtension());
            themeModel.setName(name);
            themeModel.setRootPath(rootPath);
            themeModel.setTemplatesPath(templatesPath);
            themeModel.setCssPath(cssPath);
            themeModel.setImagesPath(imagesPath);
            themeModel.setJavaScriptPath(javaScriptPath);
            themeModel.setVirtualPath(virtualPath);
            themeModel.setTemplateExtension(templateExtension);
            Element settingsEl = theme.element("settings");
            if (settingsEl != null) {
                for (Element settingEl : settingsEl.elements("setting")) {
                    String key = settingEl.attributeValue("key");
                    String value = settingEl.attributeValue("value");
                    themeModel.setSetting(key, value);
                }
            }
            themeModel.setWapTheme(GetterUtil.getBoolean((String)theme.elementText("wap-theme"), (boolean)themeModel.isWapTheme()));
            Element rolesEl = theme.element("roles");
            if (rolesEl != null) {
                for (Element roleNameEl : rolesEl.elements("role-name")) {
                    pluginSetting.addRole(roleNameEl.getText());
                }
            }
            this._readColorSchemes(theme, themeModel.getColorSchemesMap(), themeContextReplace);
            this._readColorSchemes(theme, themeModel.getColorSchemesMap(), themeContextReplace);
            Element layoutTemplatesEl = theme.element("layout-templates");
            if (layoutTemplatesEl != null) {
                Element customEl;
                Element standardEl = layoutTemplatesEl.element("standard");
                if (standardEl != null) {
                    this.layoutTemplateLocalService.readLayoutTemplate(servletContextName, servletContext, null, standardEl, true, themeId, pluginPackage);
                }
                if ((customEl = layoutTemplatesEl.element("custom")) != null) {
                    this.layoutTemplateLocalService.readLayoutTemplate(servletContextName, servletContext, null, customEl, false, themeId, pluginPackage);
                }
            }
            if (themeModel.isWapTheme()) continue;
            this._setSpriteImages(servletContext, themeModel, imagesPath);
        }
        return themeIds;
    }

    private void _setSpriteImages(ServletContext servletContext, Theme theme, String resourcePath) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths(resourcePath);
        if (resourcePaths == null) {
            return;
        }
        ArrayList<File> images = new ArrayList<File>(resourcePaths.size());
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this._setSpriteImages(servletContext, theme, curResourcePath);
                continue;
            }
            if (!curResourcePath.endsWith(".png")) continue;
            String realPath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)curResourcePath);
            if (realPath != null) {
                images.add(new File(realPath));
                continue;
            }
            if (ServerDetector.isTomcat()) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)"Please configure Tomcat to unpack WARs to enable enable sprites for best performance");
                continue;
            }
            _log.error((Object)("Real path for " + curResourcePath + " is null"));
        }
        String spriteFileName = ".sprite.png";
        String spritePropertiesFileName = ".sprite.properties";
        String spritePropertiesRootPath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)theme.getImagesPath());
        Properties spriteProperties = SpriteProcessorUtil.generate(images, (String)spriteFileName, (String)spritePropertiesFileName, (String)spritePropertiesRootPath, (int)16, (int)16, (int)10240);
        if (spriteProperties == null) {
            return;
        }
        spriteFileName = String.valueOf(resourcePath.substring(theme.getImagesPath().length(), resourcePath.length())) + spriteFileName;
        theme.setSpriteImages(spriteFileName, spriteProperties);
    }
}

