/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchResourceException;
import com.liferay.portal.ResourceActionsException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.ResourceCode;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.impl.ResourceImpl;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.PermissionsListFilter;
import com.liferay.portal.security.permission.PermissionsListFilterFactory;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.base.ResourceLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.ResourceComparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLocalServiceImpl
extends ResourceLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(ResourceLocalServiceImpl.class);

    public void addModelResources(long companyId, long groupId, long userId, String name, long primKey, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.addModelResources(companyId, groupId, userId, name, String.valueOf(primKey), communityPermissions, guestPermissions);
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, String primKey, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, false);
        this.addResource(companyId, name, 1, String.valueOf(companyId));
        Group guestGroup = this.groupLocalService.getGroup(companyId, "Guest");
        this.addResource(companyId, name, 2, String.valueOf(guestGroup.getGroupId()));
        if (groupId > 0L && guestGroup.getGroupId() != groupId) {
            this.addResource(companyId, name, 2, String.valueOf(groupId));
        }
        if (primKey == null) {
            return;
        }
        Resource resource = this.addResource(companyId, name, 4, primKey);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.addModelResources_6(companyId, groupId, resource, communityPermissions, guestPermissions);
        } else {
            this.addModelResources_1to5(companyId, groupId, userId, resource, communityPermissions, guestPermissions);
        }
    }

    public Resource addResource(long companyId, String name, int scope, String primKey) throws SystemException {
        if (!PermissionThreadLocal.isAddResource()) {
            return null;
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            return this.addResource_6(companyId, name, scope, primKey);
        }
        return this.addResource_1to5(companyId, name, scope, primKey);
    }

    public void addResources(long companyId, long groupId, String name, boolean portletActions) throws PortalException, SystemException {
        this.addResources(companyId, groupId, 0L, name, null, portletActions, false, false);
    }

    public void addResources(long companyId, long groupId, long userId, String name, long primKey, boolean portletActions, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.addResources(companyId, groupId, userId, name, String.valueOf(primKey), portletActions, addCommunityPermissions, addGuestPermissions);
    }

    public void addResources(long companyId, long groupId, long userId, String name, String primKey, boolean portletActions, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, portletActions);
        this.addResource(companyId, name, 1, String.valueOf(companyId));
        if (groupId > 0L) {
            this.addResource(companyId, name, 2, String.valueOf(groupId));
        }
        if (primKey == null) {
            return;
        }
        Resource resource = this.addResource(companyId, name, 4, primKey);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.addResources_6(companyId, groupId, userId, resource, portletActions);
        } else {
            this.addResources_1to5(companyId, groupId, userId, resource, portletActions);
        }
        if (groupId > 0L && addCommunityPermissions) {
            this.addCommunityPermissions(companyId, groupId, userId, name, resource, portletActions);
        }
        if (addGuestPermissions) {
            this.addGuestPermissions(companyId, groupId, userId, name, resource, portletActions);
        }
    }

    @Override
    public void deleteResource(long resourceId) throws SystemException {
        block2: {
            try {
                Resource resource = this.resourcePersistence.findByPrimaryKey(resourceId);
                this.deleteResource(resource);
            }
            catch (NoSuchResourceException nsre) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)nsre);
            }
        }
    }

    @Override
    public void deleteResource(Resource resource) throws SystemException {
        List permissions = this.permissionPersistence.findByResourceId(resource.getResourceId());
        for (Permission permission : permissions) {
            this.orgGroupPermissionPersistence.removeByPermissionId(permission.getPermissionId());
        }
        this.permissionPersistence.removeByResourceId(resource.getResourceId());
        this.resourcePersistence.remove((BaseModel)resource);
    }

    public void deleteResource(long companyId, String name, int scope, long primKey) throws PortalException, SystemException {
        this.deleteResource(companyId, name, scope, String.valueOf(primKey));
    }

    public void deleteResource(long companyId, String name, int scope, String primKey) throws PortalException, SystemException {
        block3: {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                this.resourcePermissionLocalService.deleteResourcePermissions(companyId, name, scope, primKey);
                return;
            }
            try {
                Resource resource = this.getResource(companyId, name, scope, primKey);
                this.deleteResource(resource.getResourceId());
            }
            catch (NoSuchResourceException nsre) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)nsre);
            }
        }
    }

    public void deleteResources(String name) throws SystemException {
        List resources = this.resourceFinder.findByName(name);
        for (Resource resource : resources) {
            this.deleteResource(resource);
        }
    }

    public long getLatestResourceId() throws SystemException {
        List resources = this.resourcePersistence.findAll(0, 1, (OrderByComparator)new ResourceComparator());
        if (resources.size() == 0) {
            return 0L;
        }
        Resource resource = (Resource)resources.get(0);
        return resource.getResourceId();
    }

    @Override
    public Resource getResource(long resourceId) throws PortalException, SystemException {
        return this.resourcePersistence.findByPrimaryKey(resourceId);
    }

    public Resource getResource(long companyId, String name, int scope, String primKey) throws PortalException, SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            return this.getResource_6(companyId, name, scope, primKey);
        }
        return this.getResource_1to5(companyId, name, scope, primKey);
    }

    public List<Resource> getResources() throws SystemException {
        return this.resourcePersistence.findAll();
    }

    public void updateResources(long companyId, String name, int scope, String primKey, String newPrimKey) throws PortalException, SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.updateResources_6(companyId, name, scope, primKey, newPrimKey);
        } else {
            this.updateResources_1to5(companyId, name, scope, primKey, newPrimKey);
        }
    }

    public void updateResources(long companyId, long groupId, String name, long primKey, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.updateResources(companyId, groupId, name, String.valueOf(primKey), communityPermissions, guestPermissions);
    }

    public void updateResources(long companyId, long groupId, String name, String primKey, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        Resource resource = this.getResource(companyId, name, 4, primKey);
        if (communityPermissions == null) {
            communityPermissions = new String[]{};
        }
        if (guestPermissions == null) {
            guestPermissions = new String[]{};
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.updateResources_6(companyId, groupId, resource, communityPermissions, guestPermissions);
        } else {
            this.updateResources_1to5(companyId, groupId, resource, communityPermissions, guestPermissions);
        }
    }

    protected void addCommunityPermissions(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions) throws PortalException, SystemException {
        List<String> actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceCommunityDefaultActions(name) : ResourceActionsUtil.getModelResourceCommunityDefaultActions(name);
        String[] actionIds = actions.toArray(new String[actions.size()]);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.addCommunityPermissions_6(groupId, resource, actionIds);
        } else {
            this.addCommunityPermissions_1to5(companyId, groupId, userId, name, resource, portletActions, actionIds);
        }
    }

    protected void addCommunityPermissions_1to5(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions, String[] actionIds) throws PortalException, SystemException {
        long resourceId = resource.getResourceId();
        String primKey = resource.getPrimKey();
        List communityPermissionsList = this.permissionLocalService.getPermissions(companyId, actionIds, resourceId);
        PermissionsListFilter permissionsListFilter = PermissionsListFilterFactory.getInstance();
        communityPermissionsList = permissionsListFilter.filterCommunityPermissions(companyId, groupId, userId, name, primKey, portletActions, communityPermissionsList);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            Role role = this.roleLocalService.getDefaultGroupRole(groupId);
            this.rolePersistence.addPermissions(role.getRoleId(), communityPermissionsList);
        } else {
            this.groupPersistence.addPermissions(groupId, communityPermissionsList);
        }
    }

    protected void addCommunityPermissions_6(long groupId, Resource resource, String[] actionIds) throws PortalException, SystemException {
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds);
    }

    protected void addGuestPermissions(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions) throws PortalException, SystemException {
        List<String> actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceGuestDefaultActions(name) : ResourceActionsUtil.getModelResourceGuestDefaultActions(name);
        String[] actionIds = actions.toArray(new String[actions.size()]);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.addGuestPermissions_6(companyId, resource, actionIds);
        } else {
            this.addGuestPermissions_1to5(companyId, groupId, userId, name, resource, portletActions, actionIds);
        }
    }

    protected void addGuestPermissions_1to5(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions, String[] actionIds) throws PortalException, SystemException {
        List guestPermissionsList = this.permissionLocalService.getPermissions(companyId, actionIds, resource.getResourceId());
        PermissionsListFilter permissionsListFilter = PermissionsListFilterFactory.getInstance();
        guestPermissionsList = permissionsListFilter.filterGuestPermissions(companyId, groupId, userId, name, resource.getPrimKey(), portletActions, guestPermissionsList);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
            this.rolePersistence.addPermissions(guestRole.getRoleId(), guestPermissionsList);
        } else {
            long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
            this.userPersistence.addPermissions(defaultUserId, guestPermissionsList);
        }
    }

    protected void addGuestPermissions_6(long companyId, Resource resource, String[] actionIds) throws PortalException, SystemException {
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), guestRole.getRoleId(), actionIds);
    }

    protected void addModelResources_1to5(long companyId, long groupId, long userId, Resource resource, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        PermissionsListFilter permissionsListFilter = PermissionsListFilterFactory.getInstance();
        List permissionsList = this.permissionLocalService.addPermissions(companyId, resource.getName(), resource.getResourceId(), false);
        List userPermissionsList = permissionsListFilter.filterUserPermissions(companyId, groupId, userId, resource.getName(), resource.getPrimKey(), false, permissionsList);
        this.filterOwnerPermissions(resource.getName(), userPermissionsList);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            Role ownerRole = this.roleLocalService.getRole(companyId, "Owner");
            this.rolePersistence.addPermissions(ownerRole.getRoleId(), userPermissionsList);
        } else if (userId > 0L && userId != defaultUserId) {
            this.userPersistence.addPermissions(userId, userPermissionsList);
        }
        if (groupId > 0L) {
            if (communityPermissions == null) {
                communityPermissions = new String[]{};
            }
            List communityPermissionsList = this.permissionLocalService.getPermissions(companyId, communityPermissions, resource.getResourceId());
            communityPermissionsList = permissionsListFilter.filterCommunityPermissions(companyId, groupId, userId, resource.getName(), resource.getPrimKey(), false, communityPermissionsList);
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                Role role = this.roleLocalService.getDefaultGroupRole(groupId);
                this.rolePersistence.addPermissions(role.getRoleId(), communityPermissionsList);
            } else {
                this.groupPersistence.addPermissions(groupId, communityPermissionsList);
            }
        }
        if (guestPermissions == null) {
            guestPermissions = new String[]{};
        }
        List guestPermissionsList = this.permissionLocalService.getPermissions(companyId, guestPermissions, resource.getResourceId());
        guestPermissionsList = permissionsListFilter.filterGuestPermissions(companyId, groupId, userId, resource.getName(), resource.getPrimKey(), false, guestPermissionsList);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
            this.rolePersistence.addPermissions(guestRole.getRoleId(), guestPermissionsList);
        } else {
            this.userPersistence.addPermissions(defaultUserId, guestPermissionsList);
        }
    }

    protected void addModelResources_6(long companyId, long groupId, Resource resource, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        Role ownerRole = this.roleLocalService.getRole(companyId, "Owner");
        List<String> actionIds = ResourceActionsUtil.getModelResourceActions(resource.getName());
        this.filterOwnerActions(resource.getName(), actionIds);
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), ownerRole.getRoleId(), actionIds.toArray(new String[actionIds.size()]));
        if (groupId > 0L) {
            Role role = this.roleLocalService.getDefaultGroupRole(groupId);
            if (communityPermissions == null) {
                communityPermissions = new String[]{};
            }
            this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), communityPermissions);
        }
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        if (guestPermissions == null) {
            guestPermissions = new String[]{};
        }
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), guestRole.getRoleId(), guestPermissions);
    }

    protected Resource addResource_1to5(long companyId, String name, int scope, String primKey) throws SystemException {
        Resource resource;
        block4: {
            ResourceCode resourceCode = this.resourceCodeLocalService.getResourceCode(companyId, name, scope);
            long codeId = resourceCode.getCodeId();
            resource = this.resourcePersistence.fetchByC_P(codeId, primKey);
            if (resource == null) {
                long resourceId = this.counterLocalService.increment(Resource.class.getName());
                resource = this.resourcePersistence.create(resourceId);
                resource.setCodeId(codeId);
                resource.setPrimKey(primKey);
                try {
                    this.resourcePersistence.update((BaseModel)resource, false);
                }
                catch (SystemException se) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Add failed, fetch {codeId=" + codeId + ", primKey=" + primKey + "}"));
                    }
                    if ((resource = this.resourcePersistence.fetchByC_P(codeId, primKey, false)) != null) break block4;
                    throw se;
                }
            }
        }
        return resource;
    }

    protected Resource addResource_6(long companyId, String name, int scope, String primKey) {
        ResourceImpl resource = new ResourceImpl();
        resource.setCompanyId(companyId);
        resource.setName(name);
        resource.setScope(scope);
        resource.setPrimKey(primKey);
        return resource;
    }

    protected void addResources_1to5(long companyId, long groupId, long userId, Resource resource, boolean portletActions) throws PortalException, SystemException {
        List permissionsList = this.permissionLocalService.addPermissions(companyId, resource.getName(), resource.getResourceId(), portletActions);
        PermissionsListFilter permissionsListFilter = PermissionsListFilterFactory.getInstance();
        List userPermissionsList = permissionsListFilter.filterUserPermissions(companyId, groupId, userId, resource.getName(), resource.getPrimKey(), portletActions, permissionsList);
        this.filterOwnerPermissions(resource.getName(), userPermissionsList);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            Role ownerRole = this.roleLocalService.getRole(companyId, "Owner");
            this.rolePersistence.addPermissions(ownerRole.getRoleId(), userPermissionsList);
        } else {
            long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
            if (userId > 0L && userId != defaultUserId) {
                this.userPersistence.addPermissions(userId, userPermissionsList);
            }
        }
    }

    protected void addResources_6(long companyId, long groupId, long userId, Resource resource, boolean portletActions) throws PortalException, SystemException {
        List<String> actionIds = null;
        if (portletActions) {
            actionIds = ResourceActionsUtil.getPortletResourceActions(resource.getName());
        } else {
            actionIds = ResourceActionsUtil.getModelResourceActions(resource.getName());
            this.filterOwnerActions(resource.getName(), actionIds);
        }
        Role role = this.roleLocalService.getRole(companyId, "Owner");
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds.toArray(new String[actionIds.size()]));
    }

    protected void filterOwnerActions(String name, List<String> actionIds) {
        List<String> defaultOwnerActions = ResourceActionsUtil.getModelResourceOwnerDefaultActions(name);
        if (defaultOwnerActions.isEmpty()) {
            return;
        }
        Iterator<String> itr = actionIds.iterator();
        while (itr.hasNext()) {
            String actionId = itr.next();
            if (defaultOwnerActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    protected void filterOwnerPermissions(String name, List<Permission> permissions) {
        List<String> defaultOwnerActions = ResourceActionsUtil.getModelResourceOwnerDefaultActions(name);
        if (defaultOwnerActions.isEmpty()) {
            return;
        }
        Iterator<Permission> itr = permissions.iterator();
        while (itr.hasNext()) {
            Permission permission = itr.next();
            String actionId = permission.getActionId();
            if (defaultOwnerActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    protected Resource getResource_1to5(long companyId, String name, int scope, String primKey) throws PortalException, SystemException {
        ResourceCode resourceCode = this.resourceCodeLocalService.getResourceCode(companyId, name, scope);
        return this.resourcePersistence.findByC_P(resourceCode.getCodeId(), primKey);
    }

    protected Resource getResource_6(long companyId, String name, int scope, String primKey) {
        ResourceImpl resource = new ResourceImpl();
        resource.setCompanyId(companyId);
        resource.setName(name);
        resource.setScope(scope);
        resource.setPrimKey(primKey);
        return resource;
    }

    protected void updateResources_1to5(long companyId, String name, int scope, String primKey, String newPrimKey) throws PortalException, SystemException {
        Resource resource = this.getResource(companyId, name, scope, primKey);
        resource.setPrimKey(newPrimKey);
        this.resourcePersistence.update((BaseModel)resource, false);
    }

    protected void updateResources_1to5(long companyId, long groupId, Resource resource, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.permissionLocalService.setRolePermissions(role.getRoleId(), communityPermissions, resource.getResourceId());
        role = this.roleLocalService.getRole(companyId, "Guest");
        this.permissionLocalService.setRolePermissions(role.getRoleId(), guestPermissions, resource.getResourceId());
    }

    protected void updateResources_6(long companyId, String name, int scope, String primKey, String newPrimKey) throws SystemException {
        List resourcePermissions = this.resourcePermissionLocalService.getResourcePermissions(companyId, name, scope, primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourcePermission.setPrimKey(newPrimKey);
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission, false);
        }
    }

    protected void updateResources_6(long companyId, long groupId, Resource resource, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), communityPermissions);
        role = this.roleLocalService.getRole(companyId, "Guest");
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), guestPermissions);
    }

    protected void validate(String name, boolean portletActions) throws PortalException {
        List<String> actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceActions(name) : ResourceActionsUtil.getModelResourceActions(name);
        if (actions.size() == 0) {
            throw new ResourceActionsException("There are no actions associated with the resource " + name);
        }
    }
}

