/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.WebsiteServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebsiteServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(WebsiteServiceHttp.class);

    public static Website addWebsite(HttpPrincipal httpPrincipal, String className, long classPK, String url, int typeId, boolean primary) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WebsiteServiceUtil.class.getName(), "addWebsite", new Class[]{String.class, Long.TYPE, String.class, Integer.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK, url, typeId, primary});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Website)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteWebsite(HttpPrincipal httpPrincipal, long websiteId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WebsiteServiceUtil.class.getName(), "deleteWebsite", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{websiteId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Website getWebsite(HttpPrincipal httpPrincipal, long websiteId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WebsiteServiceUtil.class.getName(), "getWebsite", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{websiteId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Website)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Website> getWebsites(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WebsiteServiceUtil.class.getName(), "getWebsites", new Class[]{String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Website updateWebsite(HttpPrincipal httpPrincipal, long websiteId, String url, int typeId, boolean primary) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WebsiteServiceUtil.class.getName(), "updateWebsite", new Class[]{Long.TYPE, String.class, Integer.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{websiteId, url, typeId, primary});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Website)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

