/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ResourcePermissionServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;

public class ResourcePermissionServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ResourcePermissionServiceHttp.class);

    public static void addResourcePermission(HttpPrincipal httpPrincipal, long groupId, long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ResourcePermissionServiceUtil.class.getName(), "addResourcePermission", new Class[]{Long.TYPE, Long.TYPE, String.class, Integer.TYPE, String.class, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, companyId, name, scope, primKey, roleId, actionId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setIndividualResourcePermissions(HttpPrincipal httpPrincipal, long groupId, long companyId, String name, String primKey, long roleId, String[] actionIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ResourcePermissionServiceUtil.class.getName(), "setIndividualResourcePermissions", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Long.TYPE, String[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, companyId, name, primKey, roleId, actionIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void removeResourcePermission(HttpPrincipal httpPrincipal, long groupId, long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ResourcePermissionServiceUtil.class.getName(), "removeResourcePermission", new Class[]{Long.TYPE, Long.TYPE, String.class, Integer.TYPE, String.class, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, companyId, name, scope, primKey, roleId, actionId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void removeResourcePermissions(HttpPrincipal httpPrincipal, long groupId, long companyId, String name, int scope, long roleId, String actionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ResourcePermissionServiceUtil.class.getName(), "removeResourcePermissions", new Class[]{Long.TYPE, Long.TYPE, String.class, Integer.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, companyId, name, scope, roleId, actionId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

