/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Phone;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.PhoneServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(PhoneServiceHttp.class);

    public static Phone addPhone(HttpPrincipal httpPrincipal, String className, long classPK, String number, String extension, int typeId, boolean primary) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PhoneServiceUtil.class.getName(), "addPhone", new Class[]{String.class, Long.TYPE, String.class, String.class, Integer.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK, number, extension, typeId, primary});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Phone)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deletePhone(HttpPrincipal httpPrincipal, long phoneId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PhoneServiceUtil.class.getName(), "deletePhone", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{phoneId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Phone getPhone(HttpPrincipal httpPrincipal, long phoneId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PhoneServiceUtil.class.getName(), "getPhone", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{phoneId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Phone)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Phone> getPhones(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PhoneServiceUtil.class.getName(), "getPhones", new Class[]{String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Phone updatePhone(HttpPrincipal httpPrincipal, long phoneId, String number, String extension, int typeId, boolean primary) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PhoneServiceUtil.class.getName(), "updatePhone", new Class[]{Long.TYPE, String.class, String.class, Integer.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{phoneId, number, extension, typeId, primary});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Phone)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

