/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Resource;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.service.PermissionServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(PermissionServiceHttp.class);

    public static void checkPermission(HttpPrincipal httpPrincipal, long groupId, long resourceId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "checkPermission", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, resourceId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void checkPermission(HttpPrincipal httpPrincipal, long groupId, String name, long primKey) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "checkPermission", new Class[]{Long.TYPE, String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, primKey});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void checkPermission(HttpPrincipal httpPrincipal, long groupId, String name, String primKey) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "checkPermission", new Class[]{Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, primKey});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasGroupPermission(HttpPrincipal httpPrincipal, long groupId, String actionId, long resourceId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "hasGroupPermission", new Class[]{Long.TYPE, String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, actionId, resourceId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserPermission(HttpPrincipal httpPrincipal, long userId, String actionId, long resourceId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "hasUserPermission", new Class[]{Long.TYPE, String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, actionId, resourceId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserPermissions(HttpPrincipal httpPrincipal, long userId, long groupId, List<Resource> resources, String actionId, PermissionCheckerBag permissionCheckerBag) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "hasUserPermissions", new Class[]{Long.TYPE, Long.TYPE, List.class, String.class, PermissionCheckerBag.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId, resources, actionId, permissionCheckerBag});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setGroupPermissions(HttpPrincipal httpPrincipal, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "setGroupPermissions", new Class[]{Long.TYPE, String[].class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, actionIds, resourceId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setGroupPermissions(HttpPrincipal httpPrincipal, String className, String classPK, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "setGroupPermissions", new Class[]{String.class, String.class, Long.TYPE, String[].class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK, groupId, actionIds, resourceId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setOrgGroupPermissions(HttpPrincipal httpPrincipal, long organizationId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "setOrgGroupPermissions", new Class[]{Long.TYPE, Long.TYPE, String[].class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId, groupId, actionIds, resourceId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setRolePermission(HttpPrincipal httpPrincipal, long roleId, long groupId, String name, int scope, String primKey, String actionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "setRolePermission", new Class[]{Long.TYPE, Long.TYPE, String.class, Integer.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupId, name, scope, primKey, actionId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setRolePermissions(HttpPrincipal httpPrincipal, long roleId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "setRolePermissions", new Class[]{Long.TYPE, Long.TYPE, String[].class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupId, actionIds, resourceId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setUserPermissions(HttpPrincipal httpPrincipal, long userId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "setUserPermissions", new Class[]{Long.TYPE, Long.TYPE, String[].class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId, actionIds, resourceId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetRolePermission(HttpPrincipal httpPrincipal, long roleId, long groupId, long permissionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "unsetRolePermission", new Class[]{Long.TYPE, Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupId, permissionId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetRolePermission(HttpPrincipal httpPrincipal, long roleId, long groupId, String name, int scope, String primKey, String actionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "unsetRolePermission", new Class[]{Long.TYPE, Long.TYPE, String.class, Integer.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupId, name, scope, primKey, actionId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetRolePermissions(HttpPrincipal httpPrincipal, long roleId, long groupId, String name, int scope, String actionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "unsetRolePermissions", new Class[]{Long.TYPE, Long.TYPE, String.class, Integer.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupId, name, scope, actionId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetUserPermissions(HttpPrincipal httpPrincipal, long userId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(PermissionServiceUtil.class.getName(), "unsetUserPermissions", new Class[]{Long.TYPE, Long.TYPE, String[].class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId, actionIds, resourceId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

