/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.security.ldap.AttributesTransformer;
import com.liferay.portal.security.ldap.AttributesTransformerFactory;
import com.liferay.portal.security.ldap.LDAPGroup;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.ldap.LDAPToPortalConverter;
import com.liferay.portal.security.ldap.LDAPUser;
import com.liferay.portal.security.ldap.LDAPUserTransactionThreadLocal;
import com.liferay.portal.security.ldap.PortalLDAPImporter;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import com.liferay.portlet.expando.util.ExpandoConverterUtil;
import com.liferay.util.ldap.LDAPUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.NameNotFoundException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalLDAPImporterImpl
implements PortalLDAPImporter {
    private static final String _IMPORT_BY_GROUP = "group";
    private static final String _IMPORT_BY_USER = "user";
    private static Log _log = LogFactoryUtil.getLog(PortalLDAPImporterImpl.class);
    private LDAPToPortalConverter _ldapToPortalConverter;

    public void importFromLDAP() throws Exception {
        List companies = CompanyLocalServiceUtil.getCompanies((boolean)false);
        for (Company company : companies) {
            this.importFromLDAP(company.getCompanyId());
        }
    }

    public void importFromLDAP(long companyId) throws Exception {
        if (!LDAPSettingsUtil.isImportEnabled(companyId)) {
            return;
        }
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        if (LockLocalServiceUtil.hasLock((long)defaultUserId, (String)PortalLDAPImporterUtil.class.getName(), (long)companyId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping LDAP import for company " + companyId + "because another LDAP import is in process"));
            }
            return;
        }
        LockLocalServiceUtil.lock((long)defaultUserId, (String)PortalLDAPImporterUtil.class.getName(), (long)companyId, (String)PortalLDAPImporterImpl.class.getName(), (boolean)false, (long)86400000L);
        try {
            long[] ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L);
            if (ldapServerIds.length <= 0) {
                ldapServerIds = new long[1];
            }
            long[] lArray = ldapServerIds;
            int n = ldapServerIds.length;
            int n2 = 0;
            while (n2 < n) {
                long ldapServerId = lArray[n2];
                this.importFromLDAP(ldapServerId, companyId);
                ++n2;
            }
        }
        finally {
            LockLocalServiceUtil.unlock((String)PortalLDAPImporterUtil.class.getName(), (long)companyId);
        }
    }

    public void importFromLDAP(long ldapServerId, long companyId) throws Exception {
        if (!LDAPSettingsUtil.isImportEnabled(companyId)) {
            return;
        }
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        if (ldapContext == null) {
            return;
        }
        try {
            try {
                Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
                Properties userExpandoMappings = LDAPSettingsUtil.getUserExpandoMappings(ldapServerId, companyId);
                Properties contactMappings = LDAPSettingsUtil.getContactMappings(ldapServerId, companyId);
                Properties contactExpandoMappings = LDAPSettingsUtil.getContactExpandoMappings(ldapServerId, companyId);
                Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, companyId);
                String importMethod = PrefsPropsUtil.getString(companyId, "ldap.import.method");
                if (importMethod.equals(_IMPORT_BY_GROUP)) {
                    this.importFromLDAPByGroup(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, groupMappings);
                } else if (importMethod.equals(_IMPORT_BY_USER)) {
                    this.importFromLDAPByUser(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, groupMappings);
                }
            }
            catch (Exception e) {
                _log.error((Object)"Error importing LDAP users and groups", (Throwable)e);
                if (ldapContext != null) {
                    ldapContext.close();
                }
            }
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public User importLDAPUser(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, String password) throws Exception {
        Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
        Properties userExpandoMappings = LDAPSettingsUtil.getUserExpandoMappings(ldapServerId, companyId);
        Properties contactMappings = LDAPSettingsUtil.getContactMappings(ldapServerId, companyId);
        Properties contactExpandoMappings = LDAPSettingsUtil.getContactExpandoMappings(ldapServerId, companyId);
        User user = this.importUser(companyId, attributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, password);
        Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, companyId);
        this.importGroups(ldapServerId, companyId, ldapContext, attributes, user, userMappings, groupMappings);
        return user;
    }

    public User importLDAPUserByScreenName(long companyId, String screenName) throws Exception {
        long ldapServerId = PortalLDAPUtil.getLdapServerId(companyId, screenName);
        SearchResult result = (SearchResult)PortalLDAPUtil.getUser(ldapServerId, companyId, screenName);
        if (result == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No user was found in LDAP with screenName " + screenName));
            }
            return null;
        }
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        User user = PortalLDAPImporterUtil.importLDAPUser(ldapServerId, companyId, ldapContext, result.getAttributes(), "");
        ldapContext.close();
        return user;
    }

    public void setLDAPToPortalConverter(LDAPToPortalConverter ldapToPortalConverter) {
        this._ldapToPortalConverter = ldapToPortalConverter;
    }

    protected void addRole(long companyId, LDAPGroup ldapGroup, UserGroup userGroup) throws Exception {
        if (!PropsValues.LDAP_IMPORT_CREATE_ROLE_PER_GROUP) {
            return;
        }
        Role role = null;
        try {
            role = RoleLocalServiceUtil.getRole((long)companyId, (String)ldapGroup.getGroupName());
        }
        catch (NoSuchRoleException noSuchRoleException) {
            User defaultUser = UserLocalServiceUtil.getDefaultUser((long)companyId);
            role = RoleLocalServiceUtil.addRole((long)defaultUser.getUserId(), (long)companyId, (String)ldapGroup.getGroupName(), null, (String)"Autogenerated role from LDAP import", (int)1);
        }
        Group group = userGroup.getGroup();
        if (GroupLocalServiceUtil.hasRoleGroup((long)role.getRoleId(), (long)group.getGroupId())) {
            return;
        }
        GroupLocalServiceUtil.addRoleGroups((long)role.getRoleId(), (long[])new long[]{group.getGroupId()});
    }

    protected User addUser(long companyId, LDAPUser ldapUser, String password) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding user " + ldapUser.getEmailAddress()));
        }
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(ldapUser.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        return UserLocalServiceUtil.addUser((long)ldapUser.getCreatorUserId(), (long)companyId, (boolean)ldapUser.isAutoPassword(), (String)password, (String)password, (boolean)ldapUser.isAutoScreenName(), (String)ldapUser.getScreenName(), (String)ldapUser.getEmailAddress(), (long)ldapUser.getFacebookId(), (String)ldapUser.getOpenId(), (Locale)ldapUser.getLocale(), (String)ldapUser.getFirstName(), (String)ldapUser.getMiddleName(), (String)ldapUser.getLastName(), (int)ldapUser.getPrefixId(), (int)ldapUser.getSuffixId(), (boolean)ldapUser.isMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)ldapUser.getJobTitle(), (long[])ldapUser.getGroupIds(), (long[])ldapUser.getOrganizationIds(), (long[])ldapUser.getRoleIds(), (long[])ldapUser.getUserGroupIds(), (boolean)ldapUser.isSendEmail(), (ServiceContext)ldapUser.getServiceContext());
    }

    protected User getUser(long companyId, LDAPUser ldapUser) throws Exception {
        User user = null;
        try {
            String authType = PrefsPropsUtil.getString(companyId, "company.security.auth.type", PropsValues.COMPANY_SECURITY_AUTH_TYPE);
            user = authType.equals("screenName") && !ldapUser.isAutoScreenName() ? UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)ldapUser.getScreenName()) : UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)ldapUser.getEmailAddress());
        }
        catch (NoSuchUserException noSuchUserException) {}
        return user;
    }

    protected Attribute getUsers(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, UserGroup userGroup, Properties groupMappings) throws Exception {
        Attribute attribute = attributes.get(groupMappings.getProperty(_IMPORT_BY_USER));
        if (attribute == null) {
            return null;
        }
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        StringBundler sb = new StringBundler(7);
        sb.append("(&");
        sb.append(PrefsPropsUtil.getString(companyId, "ldap.import.group.search.filter" + postfix));
        sb.append("(");
        sb.append(groupMappings.getProperty("groupName"));
        sb.append("=");
        sb.append(userGroup.getName());
        sb.append("))");
        return PortalLDAPUtil.getMultivaluedAttribute(companyId, ldapContext, baseDN, sb.toString(), attribute);
    }

    protected void importFromLDAPByGroup(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, Properties groupMappings) throws Exception {
        byte[] cookie = new byte[]{};
        while (cookie != null) {
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            String groupMappingsGroupName = GetterUtil.getString((String)groupMappings.getProperty("groupName")).toLowerCase();
            cookie = PortalLDAPUtil.getGroups(ldapServerId, companyId, ldapContext, cookie, 0, new String[]{groupMappingsGroupName}, searchResults);
            for (SearchResult searchResult : searchResults) {
                try {
                    Attributes attributes = PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ldapContext, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, searchResult), true);
                    UserGroup userGroup = this.importUserGroup(companyId, attributes, groupMappings);
                    Attribute usersAttribute = this.getUsers(ldapServerId, companyId, ldapContext, attributes, userGroup, groupMappings);
                    if (usersAttribute == null) {
                        if (!_log.isInfoEnabled()) continue;
                        _log.info((Object)("No users found in " + userGroup.getName()));
                        continue;
                    }
                    this.importUsers(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, userGroup.getUserGroupId(), usersAttribute);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to import group " + searchResult), (Throwable)e);
                }
            }
        }
    }

    protected void importFromLDAPByUser(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, Properties groupMappings) throws Exception {
        byte[] cookie = new byte[]{};
        while (cookie != null) {
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty("screenName")).toLowerCase();
            cookie = PortalLDAPUtil.getUsers(ldapServerId, companyId, ldapContext, cookie, 0, new String[]{userMappingsScreenName}, searchResults);
            for (SearchResult searchResult : searchResults) {
                try {
                    Attributes userAttributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ldapContext, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, searchResult));
                    User user = this.importUser(companyId, userAttributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, "");
                    this.importGroups(ldapServerId, companyId, ldapContext, userAttributes, user, userMappings, groupMappings);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to import user " + searchResult), (Throwable)e);
                }
            }
        }
    }

    protected void importGroups(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, User user, Properties userMappings, Properties groupMappings) throws Exception {
        String userMappingsGroup = userMappings.getProperty(_IMPORT_BY_GROUP);
        if (Validator.isNotNull((String)userMappingsGroup) && attributes.get(userMappingsGroup) == null) {
            return;
        }
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        Binding binding = PortalLDAPUtil.getUser(ldapServerId, companyId, user.getScreenName());
        String fullUserDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding);
        StringBundler sb = new StringBundler(9);
        sb.append("(");
        sb.append("&");
        sb.append(PrefsPropsUtil.getString(companyId, "ldap.import.group.search.filter" + postfix));
        sb.append("(");
        sb.append(groupMappings.getProperty(_IMPORT_BY_USER));
        sb.append("=");
        sb.append(fullUserDN);
        sb.append(")");
        sb.append(")");
        byte[] cookie = new byte[]{};
        ArrayList<Long> newUserGroupIds = new ArrayList<Long>();
        while (cookie != null) {
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            String groupMappingsGroupName = GetterUtil.getString((String)groupMappings.getProperty("groupName")).toLowerCase();
            cookie = PortalLDAPUtil.searchLDAP(companyId, ldapContext, cookie, 0, baseDN, sb.toString(), new String[]{groupMappingsGroupName}, searchResults);
            for (SearchResult searchResult : searchResults) {
                String fullGroupDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, searchResult);
                Attributes groupAttributes = null;
                try {
                    groupAttributes = PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ldapContext, fullGroupDN);
                }
                catch (NameNotFoundException nnfe) {
                    _log.error((Object)("LDAP group not found with fullGroupDN " + fullGroupDN), (Throwable)nnfe);
                    continue;
                }
                UserGroup userGroup = this.importUserGroup(companyId, groupAttributes, groupMappings);
                if (userGroup == null) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding " + user.getUserId() + " to group " + userGroup.getUserGroupId()));
                }
                newUserGroupIds.add(userGroup.getUserGroupId());
            }
        }
        UserGroupLocalServiceUtil.setUserUserGroups((long)user.getUserId(), (long[])ArrayUtil.toArray((Long[])newUserGroupIds.toArray(new Long[newUserGroupIds.size()])));
    }

    protected User importUser(long companyId, Attributes attributes, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, String password) throws Exception {
        LDAPUserTransactionThreadLocal.setOriginatesFromLDAP(true);
        try {
            AttributesTransformer attributesTransformer = AttributesTransformerFactory.getInstance();
            attributes = attributesTransformer.transformUser(attributes);
            LDAPUser ldapUser = this._ldapToPortalConverter.importLDAPUser(companyId, attributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, password);
            User user = this.getUser(companyId, ldapUser);
            if (user != null && user.isDefaultUser()) {
                User user2 = user;
                return user2;
            }
            if (user != null) {
                String modifiedDate = LDAPUtil.getAttributeValue((Attributes)attributes, (String)"modifyTimestamp");
                user = this.updateUser(companyId, ldapUser, user, password, modifiedDate);
            } else {
                user = this.addUser(companyId, ldapUser, password);
            }
            this.updateExpandoAttributes(user, ldapUser);
            User user3 = user;
            return user3;
        }
        finally {
            LDAPUserTransactionThreadLocal.setOriginatesFromLDAP(false);
        }
    }

    protected UserGroup importUserGroup(long companyId, Attributes attributes, Properties groupMappings) throws Exception {
        UserGroup userGroup;
        LDAPGroup ldapGroup;
        block6: {
            AttributesTransformer attributesTransformer = AttributesTransformerFactory.getInstance();
            attributes = attributesTransformer.transformGroup(attributes);
            ldapGroup = this._ldapToPortalConverter.importLDAPGroup(companyId, attributes, groupMappings);
            userGroup = null;
            try {
                userGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)ldapGroup.getGroupName());
                UserGroupLocalServiceUtil.updateUserGroup((long)companyId, (long)userGroup.getUserGroupId(), (String)ldapGroup.getGroupName(), (String)ldapGroup.getDescription());
            }
            catch (NoSuchUserGroupException noSuchUserGroupException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding user group to portal " + ldapGroup.getGroupName()));
                }
                long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
                try {
                    userGroup = UserGroupLocalServiceUtil.addUserGroup((long)defaultUserId, (long)companyId, (String)ldapGroup.getGroupName(), (String)ldapGroup.getDescription());
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to create user group " + ldapGroup.getGroupName()));
                    }
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
        }
        this.addRole(companyId, ldapGroup, userGroup);
        return userGroup;
    }

    protected void importUsers(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, long userGroupId, Attribute attribute) throws Exception {
        ArrayList<Long> newUserIds = new ArrayList<Long>(attribute.size());
        int i = 0;
        while (i < attribute.size()) {
            block7: {
                String fullUserDN = (String)attribute.get(i);
                Attributes userAttributes = null;
                try {
                    userAttributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ldapContext, fullUserDN);
                }
                catch (NameNotFoundException nnfe) {
                    _log.error((Object)("LDAP user not found with fullUserDN " + fullUserDN), (Throwable)nnfe);
                    break block7;
                }
                try {
                    User user = this.importUser(companyId, userAttributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, "");
                    if (user != null) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Adding " + user.getUserId() + " to group " + userGroupId));
                        }
                        newUserIds.add(user.getUserId());
                    }
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to load user " + userAttributes), (Throwable)e);
                }
            }
            ++i;
        }
        UserLocalServiceUtil.setUserGroupUsers((long)userGroupId, (long[])ArrayUtil.toArray((Long[])newUserIds.toArray(new Long[newUserIds.size()])));
    }

    protected void populateExpandoAttributes(ExpandoBridge expandoBridge, Map<String, String> expandoAttributes) {
        for (Map.Entry<String, String> expandoAttribute : expandoAttributes.entrySet()) {
            String name = expandoAttribute.getKey();
            if (!expandoBridge.hasAttribute(name)) continue;
            int type = expandoBridge.getAttributeType(name);
            Serializable value = ExpandoConverterUtil.getAttributeFromString(type, expandoAttribute.getValue());
            try {
                ExpandoValueLocalServiceUtil.addValue((long)expandoBridge.getCompanyId(), (String)expandoBridge.getClassName(), (String)"CUSTOM_FIELDS", (String)name, (long)expandoBridge.getClassPK(), (Object)value);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void updateExpandoAttributes(User user, LDAPUser ldapUser) throws Exception {
        ExpandoBridge userExpandoBridge = user.getExpandoBridge();
        this.populateExpandoAttributes(userExpandoBridge, ldapUser.getUserExpandoAttributes());
        Contact contact = user.getContact();
        ExpandoBridge contactExpandoBridge = contact.getExpandoBridge();
        this.populateExpandoAttributes(contactExpandoBridge, ldapUser.getContactExpandoAttributes());
    }

    protected User updateUser(long companyId, LDAPUser ldapUser, User user, String password, String modifiedDate) throws Exception {
        Date ldapUserModifiedDate;
        block10: {
            ldapUserModifiedDate = null;
            try {
                if (Validator.isNull((String)modifiedDate)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("LDAP entry never modified, skipping user " + user.getEmailAddress()));
                    }
                    return user;
                }
                DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
                ldapUserModifiedDate = dateFormat.parse(modifiedDate);
                if (ldapUserModifiedDate.equals(user.getModifiedDate()) && ldapUser.isAutoPassword()) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("User is already synchronized, skipping user " + user.getEmailAddress()));
                    }
                    return user;
                }
            }
            catch (ParseException pe) {
                if (!_log.isDebugEnabled()) break block10;
                _log.debug((Object)("Unable to parse LDAP modify timestamp " + modifiedDate), (Throwable)pe);
            }
        }
        if (Validator.isNull((String)ldapUser.getScreenName())) {
            ldapUser.setAutoScreenName(true);
        }
        if (ldapUser.isAutoScreenName()) {
            ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
            ldapUser.setScreenName(screenNameGenerator.generate(companyId, user.getUserId(), ldapUser.getEmailAddress()));
        }
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(user.getContact().getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        if (ldapUser.isUpdatePassword()) {
            UserLocalServiceUtil.updatePassword((long)user.getUserId(), (String)password, (String)password, (boolean)ldapUser.isPasswordReset(), (boolean)true);
        }
        user = UserLocalServiceUtil.updateUser((long)user.getUserId(), (String)password, (String)"", (String)"", (boolean)ldapUser.isPasswordReset(), (String)ldapUser.getReminderQueryQuestion(), (String)ldapUser.getReminderQueryAnswer(), (String)ldapUser.getScreenName(), (String)ldapUser.getEmailAddress(), (long)ldapUser.getFacebookId(), (String)ldapUser.getOpenId(), (String)ldapUser.getLanguageId(), (String)ldapUser.getTimeZoneId(), (String)ldapUser.getGreeting(), (String)ldapUser.getComments(), (String)ldapUser.getFirstName(), (String)ldapUser.getMiddleName(), (String)ldapUser.getLastName(), (int)ldapUser.getPrefixId(), (int)ldapUser.getSuffixId(), (boolean)ldapUser.isMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)ldapUser.getSmsSn(), (String)ldapUser.getAimSn(), (String)ldapUser.getFacebookSn(), (String)ldapUser.getIcqSn(), (String)ldapUser.getJabberSn(), (String)ldapUser.getMsnSn(), (String)ldapUser.getMySpaceSn(), (String)ldapUser.getSkypeSn(), (String)ldapUser.getTwitterSn(), (String)ldapUser.getYmSn(), (String)ldapUser.getJobTitle(), (long[])ldapUser.getGroupIds(), (long[])ldapUser.getOrganizationIds(), (long[])ldapUser.getRoleIds(), (List)ldapUser.getUserGroupRoles(), (long[])ldapUser.getUserGroupIds(), (ServiceContext)ldapUser.getServiceContext());
        if (ldapUserModifiedDate != null) {
            user = UserLocalServiceUtil.updateModifiedDate((long)user.getUserId(), (Date)ldapUserModifiedDate);
        }
        return user;
    }
}

