/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicAuthHeaderAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(BasicAuthHeaderAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) throws AutoLoginException {
        try {
            String[] credentials;
            block10: {
                int pos;
                credentials = null;
                String authorization = request.getHeader("Authorization");
                if (authorization == null) {
                    return credentials;
                }
                StringTokenizer st = new StringTokenizer(authorization);
                if (!st.hasMoreTokens()) {
                    return credentials;
                }
                String basic = st.nextToken();
                if (!basic.equalsIgnoreCase("BASIC")) {
                    return credentials;
                }
                String encodedCredentials = st.nextToken();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Encoded credentials are " + encodedCredentials));
                }
                String decodedCredentials = new String(Base64.decode((String)encodedCredentials));
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Decoded credentials are " + decodedCredentials));
                }
                if ((pos = decodedCredentials.indexOf(58)) == -1) {
                    return credentials;
                }
                long userId = GetterUtil.getLong((String)decodedCredentials.substring(0, pos));
                String password = decodedCredentials.substring(pos + 1);
                try {
                    UserLocalServiceUtil.getUserById((long)userId);
                    credentials = new String[]{String.valueOf(userId), password, Boolean.TRUE.toString()};
                }
                catch (NoSuchUserException noSuchUserException) {
                    if (!_log.isWarnEnabled()) break block10;
                    _log.warn((Object)(String.valueOf(userId) + " is not a valid user id"));
                }
            }
            return credentials;
        }
        catch (Exception e) {
            throw new AutoLoginException((Throwable)e);
        }
    }
}

