/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.beanshell;

import bsh.Interpreter;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanShellExecutor
implements ScriptingExecutor {
    public static final String LANGUAGE = "beanshell";

    public void clearCache() {
    }

    public String getLanguage() {
        return LANGUAGE;
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script) throws ScriptingException {
        Interpreter interpreter;
        block6: {
            if (allowedClasses != null) {
                throw new ExecutionException("Constrained execution not supported for BeanShell");
            }
            interpreter = new Interpreter();
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                interpreter.set(entry.getKey(), entry.getValue());
            }
            interpreter.eval(script);
            if (outputNames != null) break block6;
            return null;
        }
        try {
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, interpreter.get(outputName));
            }
            return outputObjects;
        }
        catch (Exception e) {
            throw new ScriptingException(e.getMessage(), (Throwable)e);
        }
    }
}

