/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.util.HashMap;
import java.util.Map;

public class PollerRequestManager
implements MessageListener {
    private String _destinationName;
    private Map<String, PollerRequest> _pollerRequests = new HashMap<String, PollerRequest>();
    private JSONArray _pollerResponseChunksJSON;
    private int _responseCount;
    private String _responseDestinationName;
    private Map<String, String> _responseIds = new HashMap<String, String>();
    private long _timeout;

    public PollerRequestManager(JSONArray pollerResponseChunksJSON, String destinationName, String responseDestinationName, long timeout) {
        this._pollerResponseChunksJSON = pollerResponseChunksJSON;
        this._destinationName = destinationName;
        this._responseDestinationName = responseDestinationName;
        this._timeout = timeout;
    }

    public void addPollerRequest(PollerRequest pollerRequest) {
        if (pollerRequest == null) {
            return;
        }
        this._pollerRequests.put(pollerRequest.getPortletId(), pollerRequest);
    }

    public void clearRequests() {
        this._pollerRequests.clear();
        this._responseIds.clear();
        this._responseCount = 0;
    }

    public JSONArray getPollerResponse() {
        return this._pollerResponseChunksJSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequests() {
        MessageBusUtil.registerMessageListener((String)this._responseDestinationName, (MessageListener)this);
        try {
            for (PollerRequest pollerRequest : this._pollerRequests.values()) {
                Message message = new Message();
                message.setPayload((Object)pollerRequest);
                message.setResponseDestinationName(this._responseDestinationName);
                String responseId = PortalUUIDUtil.generate();
                message.setResponseId(responseId);
                this._responseIds.put(responseId, responseId);
                MessageBusUtil.sendMessage((String)this._destinationName, (Message)message);
            }
            PollerRequestManager pollerRequestManager = this;
            synchronized (pollerRequestManager) {
                if (this._responseCount != this._pollerRequests.size()) {
                    try {
                        this.wait(this._timeout);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            MessageBusUtil.unregisterMessageListener((String)this._responseDestinationName, (MessageListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        PollerResponse pollerResponse;
        if (!this._responseIds.containsKey(message.getResponseId())) {
            return;
        }
        if (this._pollerResponseChunksJSON != null && (pollerResponse = (PollerResponse)message.getPayload()) != null) {
            this._pollerResponseChunksJSON.put(pollerResponse.toJSONObject());
        }
        PollerRequestManager pollerRequestManager = this;
        synchronized (pollerRequestManager) {
            ++this._responseCount;
            if (this._responseCount == this._pollerRequests.size()) {
                this.notify();
            }
        }
    }
}

