/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.portlet;

import com.liferay.portal.model.Company;
import com.liferay.portal.model.CompanyConstants;
import com.liferay.portal.monitoring.MonitoringException;
import com.liferay.portal.monitoring.statistics.DataSampleProcessor;
import com.liferay.portal.monitoring.statistics.RequestStatistics;
import com.liferay.portal.monitoring.statistics.portlet.PortletRequestDataSample;
import com.liferay.portal.monitoring.statistics.portlet.PortletStatistics;
import com.liferay.portal.service.CompanyLocalService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyStatistics
implements DataSampleProcessor<PortletRequestDataSample> {
    private long _companyId;
    private long _maxTime;
    private long _minTime;
    private Map<String, PortletStatistics> _portletStatisticsByPortletId = new ConcurrentHashMap<String, PortletStatistics>();
    private String _webId;

    public CompanyStatistics() {
        this._companyId = 0L;
        this._webId = CompanyConstants.SYSTEM_STRING;
    }

    public CompanyStatistics(CompanyLocalService companyLocalService, String webId) {
        try {
            Company company = companyLocalService.getCompanyByWebId(webId);
            this._companyId = company.getCompanyId();
            this._webId = webId;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get company with web id " + webId, e);
        }
    }

    public RequestStatistics getActionRequestStatistics(String portletId) throws MonitoringException {
        PortletStatistics portletStatistics = this._portletStatisticsByPortletId.get(portletId);
        if (portletStatistics == null) {
            throw new MonitoringException("No statistics for portlet id " + portletId);
        }
        return portletStatistics.getActionRequestStatistics();
    }

    public Set<RequestStatistics> getActionRequestStatisticsSet() {
        HashSet<RequestStatistics> actionStatisticsSet = new HashSet<RequestStatistics>();
        for (PortletStatistics portletStatistics : this._portletStatisticsByPortletId.values()) {
            actionStatisticsSet.add(portletStatistics.getActionRequestStatistics());
        }
        return actionStatisticsSet;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public RequestStatistics getEventRequestStatistics(String portletId) throws MonitoringException {
        PortletStatistics portletStatistics = this._portletStatisticsByPortletId.get(portletId);
        if (portletStatistics == null) {
            throw new MonitoringException("No statistics for portlet id " + portletId);
        }
        return portletStatistics.getEventRequestStatistics();
    }

    public Set<RequestStatistics> getEventRequestStatisticsSet() {
        HashSet<RequestStatistics> eventStatisticsSet = new HashSet<RequestStatistics>();
        for (PortletStatistics portletStatistics : this._portletStatisticsByPortletId.values()) {
            eventStatisticsSet.add(portletStatistics.getEventRequestStatistics());
        }
        return eventStatisticsSet;
    }

    public long getMaxTime() {
        return this._maxTime;
    }

    public long getMinTime() {
        return this._minTime;
    }

    public Collection<String> getPortletIds() {
        return this._portletStatisticsByPortletId.keySet();
    }

    public RequestStatistics getRenderRequestStatistics(String portletId) throws MonitoringException {
        PortletStatistics portletStatistics = this._portletStatisticsByPortletId.get(portletId);
        if (portletStatistics == null) {
            throw new MonitoringException("No statistics for portlet id " + portletId);
        }
        return portletStatistics.getRenderRequestStatistics();
    }

    public Set<RequestStatistics> getRenderRequestStatisticsSet() {
        HashSet<RequestStatistics> renderStatisticsSet = new HashSet<RequestStatistics>();
        for (PortletStatistics portletStatistics : this._portletStatisticsByPortletId.values()) {
            renderStatisticsSet.add(portletStatistics.getRenderRequestStatistics());
        }
        return renderStatisticsSet;
    }

    public RequestStatistics getResourceRequestStatistics(String portletId) throws MonitoringException {
        PortletStatistics portletStatistics = this._portletStatisticsByPortletId.get(portletId);
        if (portletStatistics == null) {
            throw new MonitoringException("No statistics for portlet id " + portletId);
        }
        return portletStatistics.getResourceRequestStatistics();
    }

    public Set<RequestStatistics> getResourceRequestStatisticsSet() {
        HashSet<RequestStatistics> resourceStatisticsSet = new HashSet<RequestStatistics>();
        for (PortletStatistics portletStatistics : this._portletStatisticsByPortletId.values()) {
            resourceStatisticsSet.add(portletStatistics.getResourceRequestStatistics());
        }
        return resourceStatisticsSet;
    }

    public String getWebId() {
        return this._webId;
    }

    @Override
    public void processDataSample(PortletRequestDataSample portletRequestDataSample) throws MonitoringException {
        if (portletRequestDataSample.getCompanyId() != this._companyId) {
            return;
        }
        String portletId = portletRequestDataSample.getPortletId();
        PortletStatistics portletStatistics = this._portletStatisticsByPortletId.get(portletId);
        if (portletStatistics == null) {
            portletStatistics = new PortletStatistics(portletId, portletRequestDataSample.getName(), portletRequestDataSample.getDisplayName());
            this._portletStatisticsByPortletId.put(portletId, portletStatistics);
        }
        portletStatistics.processDataSample(portletRequestDataSample);
        long duration = portletRequestDataSample.getDuration();
        if (this._maxTime < duration) {
            this._maxTime = duration;
        } else if (this._minTime > duration) {
            this._minTime = duration;
        }
    }

    public void reset() {
        this._maxTime = 0L;
        this._minTime = 0L;
        for (PortletStatistics portletStatistics : this._portletStatisticsByPortletId.values()) {
            portletStatistics.reset();
        }
    }
}

