/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.liveusers;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ConcurrentHashSet;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.UserTracker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserTrackerLocalServiceUtil;
import com.liferay.portal.service.persistence.UserTrackerUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveUsers {
    private static Log _log = LogFactoryUtil.getLog(LiveUsers.class);
    private static LiveUsers _instance = new LiveUsers();

    public static void deleteGroup(long companyId, long groupId) {
        _instance._deleteGroup(companyId, groupId);
    }

    public static Set<Long> getGroupUsers(long companyId, long groupId) {
        return _instance._getGroupUsers(_instance._getLiveUsers(companyId), groupId);
    }

    public static int getGroupUsersCount(long companyId, long groupId) {
        return LiveUsers.getGroupUsers(companyId, groupId).size();
    }

    public static Map<String, UserTracker> getSessionUsers(long companyId) {
        return _instance._getSessionUsers(companyId);
    }

    public static int getSessionUsersCount(long companyId) {
        return LiveUsers.getSessionUsers(companyId).size();
    }

    public static UserTracker getUserTracker(long companyId, String sessionId) {
        return _instance._getUserTracker(companyId, sessionId);
    }

    public static void joinGroup(long companyId, long groupId, long userId) {
        _instance._joinGroup(companyId, groupId, userId);
    }

    public static void joinGroup(long companyId, long groupId, long[] userIds) {
        _instance._joinGroup(companyId, groupId, userIds);
    }

    public static void leaveGroup(long companyId, long groupId, long userId) {
        _instance._leaveGroup(companyId, groupId, userId);
    }

    public static void leaveGroup(long companyId, long groupId, long[] userIds) {
        _instance._leaveGroup(companyId, groupId, userIds);
    }

    public static void signIn(long companyId, long userId, String sessionId, String remoteAddr, String remoteHost, String userAgent) throws SystemException {
        _instance._signIn(companyId, userId, sessionId, remoteAddr, remoteHost, userAgent);
    }

    public static void signOut(long companyId, long userId, String sessionId) throws SystemException {
        _instance._signOut(companyId, userId, sessionId);
    }

    private LiveUsers() {
    }

    private void _addUserTracker(long companyId, long userId, UserTracker userTracker) {
        List<UserTracker> userTrackers = this._getUserTrackers(companyId, userId);
        if (userTrackers != null) {
            userTrackers.add(userTracker);
        } else {
            userTrackers = new ArrayList<UserTracker>();
            userTrackers.add(userTracker);
            Map<Long, List<UserTracker>> userTrackersMap = this._getUserTrackersMap(companyId);
            userTrackersMap.put(userId, userTrackers);
        }
    }

    private void _deleteGroup(long companyId, long groupId) {
        Map<Long, Set<Long>> liveUsers = this._getLiveUsers(companyId);
        liveUsers.remove(groupId);
    }

    private Set<Long> _getGroupUsers(Map<Long, Set<Long>> liveUsers, long groupId) {
        ConcurrentHashSet groupUsers = liveUsers.get(groupId);
        if (groupUsers == null) {
            groupUsers = new ConcurrentHashSet();
            liveUsers.put(groupId, (Set<Long>)groupUsers);
        }
        return groupUsers;
    }

    private Map<Long, Set<Long>> _getLiveUsers(long companyId) {
        String companyIdString = String.valueOf(companyId);
        ConcurrentHashMap liveUsers = (ConcurrentHashMap)WebAppPool.get(companyIdString, "LIVE_USERS");
        if (liveUsers == null) {
            liveUsers = new ConcurrentHashMap();
            WebAppPool.put(companyIdString, "LIVE_USERS", liveUsers);
        }
        return liveUsers;
    }

    private Map<String, UserTracker> _getSessionUsers(long companyId) {
        String companyIdString = String.valueOf(companyId);
        ConcurrentHashMap sessionUsers = (ConcurrentHashMap)WebAppPool.get(companyIdString, "LIVE_SESSION_USERS");
        if (sessionUsers == null) {
            sessionUsers = new ConcurrentHashMap();
            WebAppPool.put(companyIdString, "LIVE_SESSION_USERS", sessionUsers);
        }
        return sessionUsers;
    }

    private UserTracker _getUserTracker(long companyId, String sessionId) {
        Map<String, UserTracker> sessionUsers = this._getSessionUsers(companyId);
        return sessionUsers.get(sessionId);
    }

    private List<UserTracker> _getUserTrackers(long companyId, long userId) {
        Map<Long, List<UserTracker>> userTrackersMap = this._getUserTrackersMap(companyId);
        return userTrackersMap.get(userId);
    }

    private Map<Long, List<UserTracker>> _getUserTrackersMap(long companyId) {
        String companyIdString = String.valueOf(companyId);
        ConcurrentHashMap userTrackersMap = (ConcurrentHashMap)WebAppPool.get(companyIdString, "LIVE_USER_TRACKERS");
        if (userTrackersMap == null) {
            userTrackersMap = new ConcurrentHashMap();
            WebAppPool.put(companyIdString, "LIVE_USER_TRACKERS", userTrackersMap);
        }
        return userTrackersMap;
    }

    private void _joinGroup(long companyId, long groupId, long userId) {
        Map<Long, Set<Long>> liveUsers = this._getLiveUsers(companyId);
        Set<Long> groupUsers = this._getGroupUsers(liveUsers, groupId);
        if (this._getUserTrackers(companyId, userId) != null) {
            groupUsers.add(userId);
        }
    }

    private void _joinGroup(long companyId, long groupId, long[] userIds) {
        Map<Long, Set<Long>> liveUsers = this._getLiveUsers(companyId);
        Set<Long> groupUsers = this._getGroupUsers(liveUsers, groupId);
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            if (this._getUserTrackers(companyId, userId) != null) {
                groupUsers.add(userId);
            }
            ++n2;
        }
    }

    private void _leaveGroup(long companyId, long userId, long groupId) {
        Map<Long, Set<Long>> liveUsers = this._getLiveUsers(companyId);
        Set<Long> groupUsers = this._getGroupUsers(liveUsers, groupId);
        groupUsers.remove(userId);
    }

    private void _leaveGroup(long companyId, long groupId, long[] userIds) {
        Map<Long, Set<Long>> liveUsers = this._getLiveUsers(companyId);
        Set<Long> groupUsers = this._getGroupUsers(liveUsers, groupId);
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            groupUsers.remove(userId);
            ++n2;
        }
    }

    private void _removeUserTracker(long companyId, long userId, UserTracker userTracker) {
        List<UserTracker> userTrackers = this._getUserTrackers(companyId, userId);
        if (userTrackers != null) {
            String sessionId = userTracker.getSessionId();
            Iterator<UserTracker> itr = userTrackers.iterator();
            while (itr.hasNext()) {
                UserTracker curUserTracker = itr.next();
                if (!sessionId.equals(curUserTracker.getSessionId())) continue;
                itr.remove();
            }
            if (userTrackers.size() == 0) {
                Map<Long, List<UserTracker>> userTrackersMap = this._getUserTrackersMap(companyId);
                userTrackersMap.remove(userId);
            }
        }
    }

    private void _signIn(long companyId, long userId, String sessionId, String remoteAddr, String remoteHost, String userAgent) throws SystemException {
        this._updateGroupStatus(companyId, userId, true);
        Map<String, UserTracker> sessionUsers = this._getSessionUsers(companyId);
        UserTracker userTracker = sessionUsers.get(sessionId);
        if (userTracker == null && PropsValues.SESSION_TRACKER_MEMORY_ENABLED) {
            userTracker = UserTrackerUtil.create((long)0L);
            userTracker.setCompanyId(companyId);
            userTracker.setUserId(userId);
            userTracker.setModifiedDate(new Date());
            userTracker.setSessionId(sessionId);
            userTracker.setRemoteAddr(remoteAddr);
            userTracker.setRemoteHost(remoteHost);
            userTracker.setUserAgent(userAgent);
            sessionUsers.put(sessionId, userTracker);
            this._addUserTracker(companyId, userId, userTracker);
        }
    }

    private void _signOut(long companyId, long userId, String sessionId) throws SystemException {
        Map<String, UserTracker> sessionUsers;
        UserTracker userTracker;
        List<UserTracker> userTrackers = this._getUserTrackers(companyId, userId);
        if (userTrackers == null || userTrackers.size() <= 1) {
            this._updateGroupStatus(companyId, userId, false);
        }
        if ((userTracker = (sessionUsers = this._getSessionUsers(companyId)).remove(sessionId)) != null) {
            block4: {
                try {
                    UserTrackerLocalServiceUtil.addUserTracker((long)userTracker.getCompanyId(), (long)userTracker.getUserId(), (Date)userTracker.getModifiedDate(), (String)sessionId, (String)userTracker.getRemoteAddr(), (String)userTracker.getRemoteHost(), (String)userTracker.getUserAgent(), (List)userTracker.getPaths());
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)e.getMessage());
                }
            }
            this._removeUserTracker(companyId, userId, userTracker);
        }
    }

    private Map<Long, Set<Long>> _updateGroupStatus(long companyId, long userId, boolean signedIn) throws SystemException {
        Map<Long, Set<Long>> liveUsers = this._getLiveUsers(companyId);
        LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
        groupParams.put("usersGroups", userId);
        List communities = GroupLocalServiceUtil.search((long)companyId, null, null, groupParams, (int)-1, (int)-1);
        for (Group community : communities) {
            Set<Long> groupUsers = this._getGroupUsers(liveUsers, community.getGroupId());
            if (signedIn) {
                groupUsers.add(userId);
                continue;
            }
            groupUsers.remove(userId);
        }
        return liveUsers;
    }
}

