/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.events.ShutdownHook;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.freemarker.FreeMarkerEngineUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.servlet.JspFactorySwapper;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.scheduler.SchedulerEngineProxy;
import com.liferay.portal.security.lang.PortalSecurityManager;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.PropsValues;

public class StartupAction
extends SimpleAction {
    private static Log _log = LogFactoryUtil.getLog(StartupAction.class);

    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(ids);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }

    protected void doRun(String[] ids) throws Exception {
        block11: {
            System.out.println("Starting " + ReleaseInfo.getReleaseInfo());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Clear locks");
            }
            try {
                LockLocalServiceUtil.clear();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block11;
                _log.warn((Object)"Unable to clear locks because Lock table does not exist");
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Add shutdown hook");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook()));
        if (System.getSecurityManager() == null && PropsValues.PORTAL_SECURITY_MANAGER_ENABLE) {
            System.setSecurityManager(new PortalSecurityManager());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize FreeMarker engine");
        }
        FreeMarkerEngineUtil.init();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize Velocity engine");
        }
        VelocityEngineUtil.init();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Upgrade database");
        }
        DBUpgrader.upgrade();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize message bus");
        }
        MessageBus messageBus = (MessageBus)PortalBeanLocatorUtil.locate((String)MessageBus.class.getName());
        MessageSender messageSender = (MessageSender)PortalBeanLocatorUtil.locate((String)MessageSender.class.getName());
        SynchronousMessageSender synchronousMessageSender = (SynchronousMessageSender)PortalBeanLocatorUtil.locate((String)SynchronousMessageSender.class.getName());
        MessageBusUtil.init((MessageBus)messageBus, (MessageSender)messageSender, (SynchronousMessageSender)synchronousMessageSender);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize scheduler engine");
        }
        SchedulerEngineUtil.init((SchedulerEngine)new SchedulerEngineProxy());
        SchedulerEngineUtil.start();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Verify database");
        }
        DBUpgrader.verify();
        JspFactorySwapper.swap();
        ClusterExecutorUtil.initialize();
    }
}

