/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.receiver.impl;

import com.liferay.portal.editor.fckeditor.command.CommandArgument;
import com.liferay.portal.editor.fckeditor.exception.FCKException;
import com.liferay.portal.editor.fckeditor.receiver.impl.BaseCommandReceiver;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PageCommandReceiver
extends BaseCommandReceiver {
    protected String createFolder(CommandArgument arg) {
        return "0";
    }

    protected String fileUpload(CommandArgument arg, String fileName, File file, String extension) {
        return "0";
    }

    protected void getFolders(CommandArgument arg, Document doc, Node root) {
        try {
            this._getFolders(arg, doc, root);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
    }

    protected void getFoldersAndFiles(CommandArgument arg, Document doc, Node root) {
        try {
            this._getFolders(arg, doc, root);
            this._getFiles(arg, doc, root);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
    }

    private Layout _getLayout(String layoutName, Layout layout) throws Exception {
        String friendlyURL = layout.getFriendlyURL();
        if (layoutName.equals(friendlyURL)) {
            return layout;
        }
        List layoutChildren = layout.getChildren();
        if (layoutChildren.size() == 0) {
            return null;
        }
        for (Layout layoutChild : layoutChildren) {
            Layout currentLayout = this._getLayout(layoutName, layoutChild);
            if (currentLayout == null) continue;
            return currentLayout;
        }
        return null;
    }

    private String _getLayoutName(Layout layout) {
        return layout.getFriendlyURL();
    }

    private String _getLayoutName(String folderName) {
        String layoutName = folderName.substring(folderName.lastIndexOf(126) + 1, folderName.length() - 1);
        layoutName = layoutName.replace('>', '/');
        return layoutName;
    }

    private void _getFiles(CommandArgument arg, Document doc, Node root) throws Exception {
        if (arg.getCurrentFolder().equals("/")) {
            return;
        }
        Element filesEl = doc.createElement("Files");
        root.appendChild(filesEl);
        Group group = arg.getCurrentGroup();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
        if (("/" + arg.getCurrentGroupName() + "/").equals(arg.getCurrentFolder())) {
            for (Layout layout : layouts) {
                Element fileEl = doc.createElement("File");
                filesEl.appendChild(fileEl);
                fileEl.setAttribute("name", this._getLayoutName(layout));
                fileEl.setAttribute("desc", this._getLayoutName(layout));
                fileEl.setAttribute("size", "");
                fileEl.setAttribute("url", PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)arg.getThemeDisplay(), (boolean)false));
            }
        } else {
            String layoutName = this._getLayoutName(arg.getCurrentFolder());
            Layout layout = null;
            int i = 0;
            while (i < layouts.size()) {
                layout = this._getLayout(layoutName, (Layout)layouts.get(i));
                if (layout != null) break;
                ++i;
            }
            if (layout == null) {
                return;
            }
            List layoutChildren = layout.getChildren();
            int i2 = 0;
            while (i2 < layoutChildren.size()) {
                layout = (Layout)layoutChildren.get(i2);
                Element fileEl = doc.createElement("File");
                filesEl.appendChild(fileEl);
                fileEl.setAttribute("name", this._getLayoutName(layout));
                fileEl.setAttribute("desc", this._getLayoutName(layout));
                fileEl.setAttribute("size", this.getSize());
                fileEl.setAttribute("url", PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)arg.getThemeDisplay(), (boolean)false));
                ++i2;
            }
        }
    }

    private void _getFolders(CommandArgument arg, Document doc, Node root) throws Exception {
        block4: {
            List layouts;
            Element foldersEl;
            block5: {
                block3: {
                    foldersEl = doc.createElement("Folders");
                    root.appendChild(foldersEl);
                    if (!arg.getCurrentFolder().equals("/")) break block3;
                    this.getRootFolders(arg, doc, foldersEl);
                    break block4;
                }
                Group group = arg.getCurrentGroup();
                layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
                if (!("/" + arg.getCurrentGroupName() + "/").equals(arg.getCurrentFolder())) break block5;
                for (Layout layout : layouts) {
                    Element folderEl = doc.createElement("Folder");
                    foldersEl.appendChild(folderEl);
                    folderEl.setAttribute("name", "~" + this._getLayoutName(layout).replace('/', '>'));
                }
                break block4;
            }
            String layoutName = this._getLayoutName(arg.getCurrentFolder());
            Layout layout = null;
            int i = 0;
            while (i < layouts.size()) {
                layout = this._getLayout(layoutName, (Layout)layouts.get(i));
                if (layout != null) break;
                ++i;
            }
            if (layout == null) break block4;
            List layoutChildren = layout.getChildren();
            int i2 = 0;
            while (i2 < layoutChildren.size()) {
                layout = (Layout)layoutChildren.get(i2);
                Element folderEl = doc.createElement("Folder");
                foldersEl.appendChild(folderEl);
                folderEl.setAttribute("name", "~" + this._getLayoutName(layout).replace('/', '>'));
                ++i2;
            }
        }
    }
}

