/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.documentlibrary.util.Hook;
import com.liferay.portal.captcha.CaptchaImpl;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.image.HookFactory;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.captcha.Captcha;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployDir;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.InvokerAction;
import com.liferay.portal.kernel.events.InvokerSessionAction;
import com.liferay.portal.kernel.events.InvokerSimpleAction;
import com.liferay.portal.kernel.events.SessionAction;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.sanitizer.Sanitizer;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.sanitizer.SanitizerWrapper;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.model.Release;
import com.liferay.portal.security.auth.AuthFailure;
import com.liferay.portal.security.auth.AuthPipeline;
import com.liferay.portal.security.auth.AuthToken;
import com.liferay.portal.security.auth.AuthTokenUtil;
import com.liferay.portal.security.auth.AuthTokenWrapper;
import com.liferay.portal.security.auth.Authenticator;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.security.auth.FullNameValidator;
import com.liferay.portal.security.auth.FullNameValidatorFactory;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.security.auth.ScreenNameValidator;
import com.liferay.portal.security.auth.ScreenNameValidatorFactory;
import com.liferay.portal.security.ldap.AttributesTransformer;
import com.liferay.portal.security.ldap.AttributesTransformerFactory;
import com.liferay.portal.service.ReleaseLocalServiceUtil;
import com.liferay.portal.service.persistence.BasePersistence;
import com.liferay.portal.servlet.filters.autologin.AutoLoginFilter;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.upgrade.UpgradeProcessUtil;
import com.liferay.portal.util.JavaScriptBundleUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ControlPanelEntry;
import com.liferay.portlet.DefaultControlPanelEntryFactory;
import com.liferay.util.UniqueList;
import com.liferay.util.log4j.Log4JUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.target.SingletonTargetSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HookHotDeployListener
extends BaseHotDeployListener
implements PropsKeys {
    public static String[] SUPPORTED_PROPERTIES = new String[]{"admin.default.group.names", "admin.default.role.names", "admin.default.user.group.names", "auth.forward.by.last.path", "auto.deploy.listeners", "application.startup.events", "auth.failure", "auth.max.failures", "auth.token.impl", "auth.pipeline.post", "auth.pipeline.pre", "auto.login.hooks", "captcha.check.portal.create_account", "captcha.engine.impl", "control.panel.entry.class.default", "convert.processes", "default.landing.page.path", "dl.hook.impl", "dl.webdav.hold.lock", "dl.webdav.save.to.single.version", "field.enable.com.liferay.portal.model.Contact.birthday", "field.enable.com.liferay.portal.model.Contact.male", "field.enable.com.liferay.portal.model.Organization.status", "hot.deploy.listeners", "image.hook.impl", "javascript.fast.load", "layout.static.portlets.all", "layout.template.cache.enabled", "layout.types", "layout.user.private.layouts.auto.create", "layout.user.private.layouts.enabled", "layout.user.private.layouts.modifiable", "layout.user.public.layouts.auto.create", "layout.user.public.layouts.enabled", "layout.user.public.layouts.modifiable", "ldap.attrs.transformer.impl", "login.create.account.allow.custom.password", "login.events.post", "login.events.pre", "logout.events.post", "logout.events.pre", "mail.hook.impl", "my.places.show.community.private.sites.with.no.layouts", "my.places.show.community.public.sites.with.no.layouts", "my.places.show.organization.private.sites.with.no.layouts", "my.places.show.organization.public.sites.with.no.layouts", "my.places.show.user.private.sites.with.no.layouts", "my.places.show.user.public.sites.with.no.layouts", "passwords.passwordpolicytoolkit.generator", "passwords.passwordpolicytoolkit.static", "portlet.add.default.resource.check.enabled", "sanitizer.impl", "servlet.session.create.events", "servlet.session.destroy.events", "servlet.service.events.post", "servlet.service.events.pre", "session.phishing.protected.attributes", "terms.of.use.required", "theme.css.fast.load", "theme.images.fast.load", "theme.loader.new.theme.id.on.import", "theme.portlet.decorate.default", "theme.portlet.sharing.default", "theme.shortcut.icon", "upgrade.processes", "users.email.address.generator", "users.email.address.required", "users.full.name.generator", "users.full.name.validator", "users.screen.name.always.autogenerate", "users.screen.name.generator", "users.screen.name.validator", "value.object.listener.*"};
    private static final String[] _PROPS_KEYS_EVENTS = new String[]{"login.events.post", "login.events.pre", "logout.events.post", "logout.events.pre", "servlet.service.events.post", "servlet.service.events.pre"};
    private static final String[] _PROPS_KEYS_SESSION_EVENTS = new String[]{"servlet.session.create.events", "servlet.session.destroy.events"};
    private static final String[] _PROPS_VALUES_BOOLEAN = new String[]{"auth.forward.by.last.path", "captcha.check.portal.create_account", "dl.webdav.hold.lock", "dl.webdav.save.to.single.version", "field.enable.com.liferay.portal.model.Contact.birthday", "field.enable.com.liferay.portal.model.Contact.male", "field.enable.com.liferay.portal.model.Organization.status", "javascript.fast.load", "layout.template.cache.enabled", "layout.user.private.layouts.auto.create", "layout.user.private.layouts.enabled", "layout.user.private.layouts.modifiable", "layout.user.public.layouts.auto.create", "layout.user.public.layouts.enabled", "layout.user.public.layouts.modifiable", "login.create.account.allow.custom.password", "my.places.show.community.private.sites.with.no.layouts", "my.places.show.community.public.sites.with.no.layouts", "my.places.show.organization.private.sites.with.no.layouts", "my.places.show.organization.public.sites.with.no.layouts", "my.places.show.user.private.sites.with.no.layouts", "my.places.show.user.public.sites.with.no.layouts", "portlet.add.default.resource.check.enabled", "terms.of.use.required", "theme.css.fast.load", "theme.images.fast.load", "theme.loader.new.theme.id.on.import", "theme.portlet.decorate.default", "theme.portlet.sharing.default", "users.email.address.required", "users.screen.name.always.autogenerate"};
    private static final String[] _PROPS_VALUES_INTEGER = new String[0];
    private static final String[] _PROPS_VALUES_LONG = new String[0];
    private static final String[] _PROPS_VALUES_STRING = new String[]{"default.landing.page.path", "passwords.passwordpolicytoolkit.generator", "passwords.passwordpolicytoolkit.static", "theme.shortcut.icon"};
    private static final String[] _PROPS_VALUES_STRING_ARRAY = new String[]{"admin.default.group.names", "admin.default.role.names", "admin.default.user.group.names", "convert.processes", "layout.static.portlets.all", "layout.types", "session.phishing.protected.attributes"};
    private static Log _log = LogFactoryUtil.getLog(HookHotDeployListener.class);
    private Map<String, AuthenticatorsContainer> _authenticatorsContainerMap = new HashMap<String, AuthenticatorsContainer>();
    private Map<String, AuthFailuresContainer> _authFailuresContainerMap = new HashMap<String, AuthFailuresContainer>();
    private Map<String, AutoDeployListenersContainer> _autoDeployListenersContainerMap = new HashMap<String, AutoDeployListenersContainer>();
    private Map<String, AutoLoginsContainer> _autoLoginsContainerMap = new HashMap<String, AutoLoginsContainer>();
    private Map<String, CustomJspBag> _customJspBagsMap = new HashMap<String, CustomJspBag>();
    private Map<String, EventsContainer> _eventsContainerMap = new HashMap<String, EventsContainer>();
    private Map<String, HotDeployListenersContainer> _hotDeployListenersContainerMap = new HashMap<String, HotDeployListenersContainer>();
    private Map<String, LanguagesContainer> _languagesContainerMap = new HashMap<String, LanguagesContainer>();
    private Map<String, ModelListenersContainer> _modelListenersContainerMap = new HashMap<String, ModelListenersContainer>();
    private Map<String, Properties> _portalPropertiesMap = new HashMap<String, Properties>();
    private ServicesContainer _servicesContainer = new ServicesContainer();
    private Set<String> _servletContextNames = new HashSet<String>();
    private Map<String, StringArraysContainer> _stringArraysContainerMap = new HashMap<String, StringArraysContainer>();

    public HookHotDeployListener() {
        String[] stringArray = _PROPS_VALUES_STRING_ARRAY;
        int n = _PROPS_VALUES_STRING_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this._stringArraysContainerMap.put(key, new StringArraysContainer(key));
            ++n2;
        }
    }

    public void invokeDeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeDeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error registering hook for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeUndeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error unregistering hook for ", t);
        }
    }

    protected boolean containsKey(Properties portalProperties, String key) {
        if (_log.isDebugEnabled()) {
            return true;
        }
        return portalProperties.containsKey(key);
    }

    protected void destroyCustomJspBag(CustomJspBag customJspBag) {
        String customJspDir = customJspBag.getCustomJspDir();
        List<String> customJsps = customJspBag.getCustomJsps();
        String portalWebDir = PortalUtil.getPortalWebDir();
        for (String customJsp : customJsps) {
            int pos = customJsp.indexOf(customJspDir);
            String portalJsp = customJsp.substring(pos + customJspDir.length(), customJsp.length());
            File portalJspFile = new File(String.valueOf(portalWebDir) + portalJsp);
            File portalJspBackupFile = this.getPortalJspBackupFile(portalJspFile);
            if (portalJspBackupFile.exists()) {
                FileUtil.copyFile((File)portalJspBackupFile, (File)portalJspFile);
                portalJspBackupFile.delete();
                continue;
            }
            if (!portalJspFile.exists()) continue;
            portalJspFile.delete();
        }
    }

    protected void destroyPortalProperties(String servletContextName, Properties portalProperties) throws Exception {
        PropsUtil.removeProperties(portalProperties);
        if (_log.isDebugEnabled() && portalProperties.containsKey("locales")) {
            _log.debug((Object)("Portlet locales " + portalProperties.getProperty("locales")));
            _log.debug((Object)("Original locales " + PropsUtil.get("locales")));
            _log.debug((Object)("Original locales array length " + PropsUtil.getArray("locales").length));
        }
        this.resetPortalProperties(servletContextName, portalProperties, false);
        if (portalProperties.containsKey("auth.token.impl")) {
            AuthTokenWrapper authTokenWrapper = (AuthTokenWrapper)AuthTokenUtil.getAuthToken();
            authTokenWrapper.setAuthToken(null);
        }
        if (portalProperties.containsKey("captcha.engine.impl")) {
            CaptchaImpl captchaImpl = (CaptchaImpl)CaptchaUtil.getCaptcha();
            captchaImpl.setCaptcha(null);
        }
        if (portalProperties.containsKey("control.panel.default.entry.class")) {
            DefaultControlPanelEntryFactory.setInstance(null);
        }
        if (portalProperties.containsKey("dl.hook.impl")) {
            com.liferay.documentlibrary.util.HookFactory.setInstance(null);
        }
        if (portalProperties.containsKey("image.hook.impl")) {
            HookFactory.setInstance(null);
        }
        if (portalProperties.containsKey("ldap.attrs.transformer.impl")) {
            AttributesTransformerFactory.setInstance(null);
        }
        if (portalProperties.containsKey("mail.hook.impl")) {
            com.liferay.mail.util.HookFactory.setInstance(null);
        }
        if (portalProperties.containsKey("sanitizer.impl")) {
            SanitizerWrapper sanitizerWrapper = (SanitizerWrapper)SanitizerUtil.getSanitizer();
            sanitizerWrapper.setSanitizer(null);
        }
        if (portalProperties.containsKey("users.email.address.generator")) {
            EmailAddressGeneratorFactory.setInstance(null);
        }
        if (portalProperties.containsKey("users.full.name.generator")) {
            FullNameGeneratorFactory.setInstance(null);
        }
        if (portalProperties.containsKey("users.full.name.validator")) {
            FullNameValidatorFactory.setInstance(null);
        }
        if (portalProperties.containsKey("users.screen.name.generator")) {
            ScreenNameGeneratorFactory.setInstance(null);
        }
        if (portalProperties.containsKey("users.screen.name.validator")) {
            ScreenNameValidatorFactory.setInstance(null);
        }
    }

    protected void destroyServices(String servletContextName) throws Exception {
        List<ServiceBag> serviceBags = this._servicesContainer.findByServletContextName(servletContextName);
        for (ServiceBag serviceBag : serviceBags) {
            Object serviceProxy = PortalBeanLocatorUtil.locate((String)serviceBag.getServiceType());
            AdvisedSupport advisedSupport = this.getAdvisedSupport(serviceProxy);
            SingletonTargetSource originalTargetSource = new SingletonTargetSource(serviceBag.getOriginalService());
            advisedSupport.setTargetSource((TargetSource)originalTargetSource);
        }
        this._servicesContainer.removeByServletContextName(servletContextName);
    }

    protected void doInvokeDeploy(HotDeployEvent event) throws Exception {
        String xml;
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-hook.xml"))) == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering hook for " + servletContextName));
        }
        this._servletContextNames.add(servletContextName);
        ClassLoader portletClassLoader = event.getContextClassLoader();
        this.initLogger(portletClassLoader);
        Document document = SAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        String portalPropertiesLocation = rootElement.elementText("portal-properties");
        if (Validator.isNotNull((String)portalPropertiesLocation)) {
            Properties portalProperties;
            Configuration portalPropertiesConfiguration = null;
            try {
                String name = portalPropertiesLocation;
                int pos = name.lastIndexOf(".properties");
                if (pos != -1) {
                    name = name.substring(0, pos);
                }
                portalPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)portletClassLoader, (String)name);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to read " + portalPropertiesLocation), (Throwable)e);
            }
            if (portalPropertiesConfiguration != null && (portalProperties = portalPropertiesConfiguration.getProperties()).size() > 0) {
                this._portalPropertiesMap.put(servletContextName, portalProperties);
                this.initPortalProperties(servletContextName, portletClassLoader, portalProperties);
                this.initAuthFailures(servletContextName, portletClassLoader, portalProperties);
                this.initAutoDeployListeners(servletContextName, portletClassLoader, portalProperties);
                this.initAutoLogins(servletContextName, portletClassLoader, portalProperties);
                this.initAuthenticators(servletContextName, portletClassLoader, portalProperties);
                this.initHotDeployListeners(servletContextName, portletClassLoader, portalProperties);
                this.initModelListeners(servletContextName, portletClassLoader, portalProperties);
                this.initEvents(servletContextName, portletClassLoader, portalProperties);
            }
        }
        LanguagesContainer languagesContainer = new LanguagesContainer();
        this._languagesContainerMap.put(servletContextName, languagesContainer);
        List languagePropertiesElements = rootElement.elements("language-properties");
        for (Element languagePropertiesElement : languagePropertiesElements) {
            String languagePropertiesLocation = languagePropertiesElement.getText();
            try {
                URL url = portletClassLoader.getResource(languagePropertiesLocation);
                if (url == null) continue;
                InputStream is = url.openStream();
                Properties properties = new Properties();
                properties.load(is);
                is.close();
                HashMap<String, String> languageMap = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    value = LanguageResources.fixValue(value);
                    languageMap.put(key, value);
                }
                Locale locale = this.getLocale(languagePropertiesLocation);
                if (locale == null) continue;
                languagesContainer.addLanguage(locale, languageMap);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to read " + languagePropertiesLocation), (Throwable)e);
            }
        }
        String customJspDir = rootElement.elementText("custom-jsp-dir");
        if (Validator.isNotNull((String)customJspDir)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Custom JSP directory: " + customJspDir));
            }
            ArrayList<String> customJsps = new ArrayList<String>();
            String webDir = servletContext.getRealPath("/");
            this.getCustomJsps(servletContext, webDir, customJspDir, customJsps);
            if (customJsps.size() > 0) {
                CustomJspBag customJspBag = new CustomJspBag(customJspDir, customJsps);
                if (_log.isDebugEnabled()) {
                    StringBundler sb = new StringBundler(customJsps.size() * 2);
                    sb.append("Custom JSP files:\n");
                    Iterator itr = customJsps.iterator();
                    while (itr.hasNext()) {
                        String customJsp = (String)itr.next();
                        sb.append(customJsp);
                        if (!itr.hasNext()) continue;
                        sb.append("\n");
                    }
                    _log.debug((Object)sb.toString());
                }
                this._customJspBagsMap.put(servletContextName, customJspBag);
                this.initCustomJspBag(customJspBag);
            }
        }
        List serviceElements = rootElement.elements("service");
        for (Element serviceElement : serviceElements) {
            String serviceType = serviceElement.elementText("service-type");
            String serviceImpl = serviceElement.elementText("service-impl");
            Class<?> serviceTypeClass = portletClassLoader.loadClass(serviceType);
            Class<?> serviceImplClass = portletClassLoader.loadClass(serviceImpl);
            Constructor<?> serviceImplConstructor = serviceImplClass.getConstructor(serviceTypeClass);
            Object serviceProxy = PortalBeanLocatorUtil.locate((String)serviceType);
            if (Proxy.isProxyClass(serviceProxy.getClass())) {
                this.initServices(servletContextName, portletClassLoader, serviceType, serviceTypeClass, serviceImplConstructor, serviceProxy);
                continue;
            }
            _log.error((Object)"Service hooks require Spring to be configured to use JdkDynamicProxy and will not work with CGLIB");
        }
        ModelListenersContainer modelListenersContainer = this._modelListenersContainerMap.get(servletContextName);
        if (modelListenersContainer == null) {
            modelListenersContainer = new ModelListenersContainer();
            this._modelListenersContainerMap.put(servletContextName, modelListenersContainer);
        }
        List modelListenerElements = rootElement.elements("model-listener");
        for (Element modelListenerElement : modelListenerElements) {
            String modelListenerClassName;
            String modelName = modelListenerElement.elementText("model-name");
            ModelListener<BaseModel<?>> modelListener = this.initModelListener(modelName, modelListenerClassName = modelListenerElement.elementText("model-listener-class"), portletClassLoader);
            if (modelListener == null) continue;
            modelListenersContainer.registerModelListener(modelName, modelListener);
        }
        EventsContainer eventsContainer = this._eventsContainerMap.get(servletContextName);
        if (eventsContainer == null) {
            eventsContainer = new EventsContainer();
            this._eventsContainerMap.put(servletContextName, eventsContainer);
        }
        List eventElements = rootElement.elements("event");
        for (Element eventElement : eventElements) {
            String eventClassName;
            String eventName = eventElement.elementText("event-type");
            Object obj = this.initEvent(eventName, eventClassName = eventElement.elementText("event-class"), portletClassLoader);
            if (obj == null) continue;
            eventsContainer.registerEvent(eventName, obj);
        }
        this.registerClpMessageListeners(servletContext, portletClassLoader);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Hook for " + servletContextName + " is available for use"));
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent event) throws Exception {
        Properties portalProperties;
        ModelListenersContainer modelListenersContainer;
        LanguagesContainer languagesContainer;
        HotDeployListenersContainer hotDeployListenersContainer;
        EventsContainer eventsContainer;
        CustomJspBag customJspBag;
        AutoLoginsContainer autoLoginsContainer;
        AutoDeployListenersContainer autoDeployListenersContainer;
        AuthFailuresContainer authFailuresContainer;
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if (!this._servletContextNames.remove(servletContextName)) {
            return;
        }
        AuthenticatorsContainer authenticatorsContainer = this._authenticatorsContainerMap.remove(servletContextName);
        if (authenticatorsContainer != null) {
            authenticatorsContainer.unregisterAuthenticators();
        }
        if ((authFailuresContainer = this._authFailuresContainerMap.remove(servletContextName)) != null) {
            authFailuresContainer.unregisterAuthFailures();
        }
        if ((autoDeployListenersContainer = this._autoDeployListenersContainerMap.remove(servletContextName)) != null) {
            autoDeployListenersContainer.unregisterAutoDeployListeners();
        }
        if ((autoLoginsContainer = this._autoLoginsContainerMap.remove(servletContextName)) != null) {
            autoLoginsContainer.unregisterAutoLogins();
        }
        if ((customJspBag = this._customJspBagsMap.remove(servletContextName)) != null) {
            this.destroyCustomJspBag(customJspBag);
        }
        if ((eventsContainer = this._eventsContainerMap.remove(servletContextName)) != null) {
            eventsContainer.unregisterEvents();
        }
        if ((hotDeployListenersContainer = this._hotDeployListenersContainerMap.remove(servletContextName)) != null) {
            hotDeployListenersContainer.unregisterHotDeployListeners();
        }
        if ((languagesContainer = this._languagesContainerMap.remove(servletContextName)) != null) {
            languagesContainer.unregisterLanguages();
        }
        if ((modelListenersContainer = this._modelListenersContainerMap.remove(servletContextName)) != null) {
            modelListenersContainer.unregisterModelListeners();
        }
        if ((portalProperties = this._portalPropertiesMap.remove(servletContextName)) != null) {
            this.destroyPortalProperties(servletContextName, portalProperties);
        }
        this.destroyServices(servletContextName);
        this.unregisterClpMessageListeners(servletContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Hook for " + servletContextName + " was unregistered"));
        }
    }

    protected AdvisedSupport getAdvisedSupport(Object serviceProxy) throws Exception {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(serviceProxy);
        Class<?> invocationHandlerClass = invocationHandler.getClass();
        Field advisedField = invocationHandlerClass.getDeclaredField("advised");
        advisedField.setAccessible(true);
        return (AdvisedSupport)advisedField.get(invocationHandler);
    }

    protected void getCustomJsps(ServletContext servletContext, String webDir, String resourcePath, List<String> customJsps) {
        Set resourcePaths = servletContext.getResourcePaths(resourcePath);
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this.getCustomJsps(servletContext, webDir, curResourcePath, customJsps);
                continue;
            }
            String customJsp = String.valueOf(webDir) + curResourcePath;
            customJsp = StringUtil.replace((String)customJsp, (String)"//", (String)"/");
            customJsps.add(customJsp);
        }
    }

    protected Locale getLocale(String languagePropertiesLocation) {
        int x = languagePropertiesLocation.indexOf("_");
        int y = languagePropertiesLocation.indexOf(".properties");
        Locale locale = null;
        if (x != -1 && y != 1) {
            String localeKey = languagePropertiesLocation.substring(x + 1, y);
            locale = LocaleUtil.fromLanguageId((String)localeKey);
        }
        return locale;
    }

    protected BasePersistence<?> getPersistence(String modelName) {
        int pos = modelName.lastIndexOf(".");
        String entityName = modelName.substring(pos + 1);
        pos = modelName.lastIndexOf(".model.");
        String packagePath = modelName.substring(0, pos);
        return (BasePersistence)PortalBeanLocatorUtil.locate((String)(String.valueOf(packagePath) + ".service.persistence." + entityName + "Persistence"));
    }

    protected File getPortalJspBackupFile(File portalJspFile) {
        String fileName = portalJspFile.getName();
        String filePath = portalJspFile.toString();
        int fileNameIndex = fileName.lastIndexOf(".");
        if (fileNameIndex > 0) {
            int filePathIndex = filePath.lastIndexOf(fileName);
            fileName = String.valueOf(fileName.substring(0, fileNameIndex)) + ".portal" + fileName.substring(fileNameIndex);
            filePath = String.valueOf(filePath.substring(0, filePathIndex)) + fileName;
        } else {
            filePath = String.valueOf(filePath) + ".portal";
        }
        return new File(filePath);
    }

    protected void initAuthenticators(ClassLoader portletClassLoader, Properties portalProperties, String key, AuthenticatorsContainer authenticatorsContainer) throws Exception {
        String[] authenticatorClassNames;
        String[] stringArray = authenticatorClassNames = StringUtil.split((String)portalProperties.getProperty(key));
        int n = authenticatorClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String authenticatorClassName = stringArray[n2];
            Authenticator authenticator = (Authenticator)this.newInstance(portletClassLoader, Authenticator.class, authenticatorClassName);
            authenticatorsContainer.registerAuthenticator(key, authenticator);
            ++n2;
        }
    }

    protected void initAuthenticators(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        AuthenticatorsContainer authenticatorsContainer = new AuthenticatorsContainer();
        this._authenticatorsContainerMap.put(servletContextName, authenticatorsContainer);
        this.initAuthenticators(portletClassLoader, portalProperties, "auth.pipeline.pre", authenticatorsContainer);
        this.initAuthenticators(portletClassLoader, portalProperties, "auth.pipeline.post", authenticatorsContainer);
    }

    protected void initAuthFailures(ClassLoader portletClassLoader, Properties portalProperties, String key, AuthFailuresContainer authFailuresContainer) throws Exception {
        String[] authFailureClassNames;
        String[] stringArray = authFailureClassNames = StringUtil.split((String)portalProperties.getProperty(key));
        int n = authFailureClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String authFailureClassName = stringArray[n2];
            AuthFailure authFailure = (AuthFailure)this.newInstance(portletClassLoader, AuthFailure.class, authFailureClassName);
            authFailuresContainer.registerAuthFailure(key, authFailure);
            ++n2;
        }
    }

    protected void initAuthFailures(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        AuthFailuresContainer authFailuresContainer = new AuthFailuresContainer();
        this._authFailuresContainerMap.put(servletContextName, authFailuresContainer);
        this.initAuthFailures(portletClassLoader, portalProperties, "auth.failure", authFailuresContainer);
        this.initAuthFailures(portletClassLoader, portalProperties, "auth.max.failures", authFailuresContainer);
    }

    protected void initAutoDeployListeners(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        String[] autoDeployListenerClassNames = StringUtil.split((String)portalProperties.getProperty("auto.deploy.listeners"));
        if (autoDeployListenerClassNames.length == 0) {
            return;
        }
        AutoDeployListenersContainer autoDeployListenersContainer = new AutoDeployListenersContainer();
        this._autoDeployListenersContainerMap.put(servletContextName, autoDeployListenersContainer);
        String[] stringArray = autoDeployListenerClassNames;
        int n = autoDeployListenerClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String autoDeployListenerClassName = stringArray[n2];
            AutoDeployListener autoDeployListener = (AutoDeployListener)this.newInstance(portletClassLoader, AutoDeployListener.class, autoDeployListenerClassName);
            autoDeployListenersContainer.registerAutoDeployListener(autoDeployListener);
            ++n2;
        }
    }

    protected void initAutoLogins(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        String[] autoLoginClassNames;
        AutoLoginsContainer autoLoginsContainer = new AutoLoginsContainer();
        this._autoLoginsContainerMap.put(servletContextName, autoLoginsContainer);
        String[] stringArray = autoLoginClassNames = StringUtil.split((String)portalProperties.getProperty("auto.login.hooks"));
        int n = autoLoginClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String autoLoginClassName = stringArray[n2];
            AutoLogin autoLogin = (AutoLogin)this.newInstance(portletClassLoader, AutoLogin.class, autoLoginClassName);
            autoLoginsContainer.registerAutoLogin(autoLogin);
            ++n2;
        }
    }

    protected void initCustomJspBag(CustomJspBag customJspBag) throws Exception {
        String customJspDir = customJspBag.getCustomJspDir();
        List<String> customJsps = customJspBag.getCustomJsps();
        String portalWebDir = PortalUtil.getPortalWebDir();
        for (String customJsp : customJsps) {
            int pos = customJsp.indexOf(customJspDir);
            String portalJsp = customJsp.substring(pos + customJspDir.length(), customJsp.length());
            File portalJspFile = new File(String.valueOf(portalWebDir) + portalJsp);
            File portalJspBackupFile = this.getPortalJspBackupFile(portalJspFile);
            if (portalJspFile.exists() && !portalJspBackupFile.exists()) {
                FileUtil.copyFile((File)portalJspFile, (File)portalJspBackupFile);
            }
            FileUtil.copyFile((String)customJsp, (String)(String.valueOf(portalWebDir) + portalJsp));
        }
    }

    protected Object initEvent(String eventName, String eventClassName, ClassLoader portletClassLoader) throws Exception {
        if (eventName.equals("application.startup.events")) {
            long[] companyIds;
            SimpleAction simpleAction = (SimpleAction)portletClassLoader.loadClass(eventClassName).newInstance();
            simpleAction = new InvokerSimpleAction(simpleAction, portletClassLoader);
            long companyId = CompanyThreadLocal.getCompanyId();
            long[] lArray = companyIds = PortalInstances.getCompanyIds();
            int n = companyIds.length;
            int n2 = 0;
            while (n2 < n) {
                long curCompanyId = lArray[n2];
                CompanyThreadLocal.setCompanyId((long)curCompanyId);
                simpleAction.run(new String[]{String.valueOf(curCompanyId)});
                ++n2;
            }
            CompanyThreadLocal.setCompanyId((long)companyId);
            return null;
        }
        if (ArrayUtil.contains((Object[])_PROPS_KEYS_EVENTS, (Object)eventName)) {
            Action action = (Action)portletClassLoader.loadClass(eventClassName).newInstance();
            action = new InvokerAction(action, portletClassLoader);
            EventsProcessorUtil.registerEvent(eventName, action);
            return action;
        }
        if (ArrayUtil.contains((Object[])_PROPS_KEYS_SESSION_EVENTS, (Object)eventName)) {
            SessionAction sessionAction = (SessionAction)portletClassLoader.loadClass(eventClassName).newInstance();
            sessionAction = new InvokerSessionAction(sessionAction, portletClassLoader);
            EventsProcessorUtil.registerEvent(eventName, sessionAction);
            return sessionAction;
        }
        return null;
    }

    protected void initEvents(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        EventsContainer eventsContainer = new EventsContainer();
        this._eventsContainerMap.put(servletContextName, eventsContainer);
        for (Map.Entry<Object, Object> entry : portalProperties.entrySet()) {
            String[] eventClassNames;
            String key = (String)entry.getKey();
            if (!key.equals("application.startup.events") && !ArrayUtil.contains((Object[])_PROPS_KEYS_EVENTS, (Object)key) && !ArrayUtil.contains((Object[])_PROPS_KEYS_SESSION_EVENTS, (Object)key)) continue;
            String eventName = key;
            String[] stringArray = eventClassNames = StringUtil.split((String)((String)entry.getValue()));
            int n = eventClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String eventClassName = stringArray[n2];
                Object obj = this.initEvent(eventName, eventClassName, portletClassLoader);
                if (obj != null) {
                    eventsContainer.registerEvent(eventName, obj);
                }
                ++n2;
            }
        }
    }

    protected void initHotDeployListeners(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        String[] hotDeployListenerClassNames = StringUtil.split((String)portalProperties.getProperty("hot.deploy.listeners"));
        if (hotDeployListenerClassNames.length == 0) {
            return;
        }
        HotDeployListenersContainer hotDeployListenersContainer = new HotDeployListenersContainer();
        this._hotDeployListenersContainerMap.put(servletContextName, hotDeployListenersContainer);
        String[] stringArray = hotDeployListenerClassNames;
        int n = hotDeployListenerClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String hotDeployListenerClassName = stringArray[n2];
            HotDeployListener hotDeployListener = (HotDeployListener)this.newInstance(portletClassLoader, HotDeployListener.class, hotDeployListenerClassName);
            hotDeployListenersContainer.registerHotDeployListener(hotDeployListener);
            ++n2;
        }
    }

    protected void initLogger(ClassLoader portletClassLoader) {
        Log4JUtil.configureLog4J((URL)portletClassLoader.getResource("META-INF/portal-log4j.xml"));
    }

    protected ModelListener<BaseModel<?>> initModelListener(String modelName, String modelListenerClassName, ClassLoader portletClassLoader) throws Exception {
        ModelListener modelListener = (ModelListener)this.newInstance(portletClassLoader, ModelListener.class, modelListenerClassName);
        BasePersistence<?> persistence = this.getPersistence(modelName);
        persistence.registerListener(modelListener);
        return modelListener;
    }

    protected void initModelListeners(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        ModelListenersContainer modelListenersContainer = new ModelListenersContainer();
        this._modelListenersContainerMap.put(servletContextName, modelListenersContainer);
        for (Map.Entry<Object, Object> entry : portalProperties.entrySet()) {
            String[] modelListenerClassNames;
            String key = (String)entry.getKey();
            if (!key.startsWith("value.object.listener.")) continue;
            String modelName = key.substring("value.object.listener.".length());
            String[] stringArray = modelListenerClassNames = StringUtil.split((String)((String)entry.getValue()));
            int n = modelListenerClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String modelListenerClassName = stringArray[n2];
                ModelListener<BaseModel<?>> modelListener = this.initModelListener(modelName, modelListenerClassName, portletClassLoader);
                if (modelListener != null) {
                    modelListenersContainer.registerModelListener(modelName, modelListener);
                }
                ++n2;
            }
        }
    }

    protected void initPortalProperties(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        PropsUtil.addProperties(portalProperties);
        if (_log.isDebugEnabled() && portalProperties.containsKey("locales")) {
            _log.debug((Object)("Portlet locales " + portalProperties.getProperty("locales")));
            _log.debug((Object)("Merged locales " + PropsUtil.get("locales")));
            _log.debug((Object)("Merged locales array length " + PropsUtil.getArray("locales").length));
        }
        this.resetPortalProperties(servletContextName, portalProperties, true);
        if (portalProperties.containsKey("auth.token.impl")) {
            String authTokenClassName = portalProperties.getProperty("auth.token.impl");
            AuthToken authToken = (AuthToken)this.newInstance(portletClassLoader, AuthToken.class, authTokenClassName);
            AuthTokenWrapper authTokenWrapper = (AuthTokenWrapper)AuthTokenUtil.getAuthToken();
            authTokenWrapper.setAuthToken(authToken);
        }
        if (portalProperties.containsKey("captcha.engine.impl")) {
            String captchaClassName = portalProperties.getProperty("captcha.engine.impl");
            Captcha captcha = (Captcha)this.newInstance(portletClassLoader, Captcha.class, captchaClassName);
            CaptchaImpl captchaImpl = (CaptchaImpl)CaptchaUtil.getCaptcha();
            captchaImpl.setCaptcha(captcha);
        }
        if (portalProperties.containsKey("control.panel.default.entry.class")) {
            String controlPanelEntryClassName = portalProperties.getProperty("control.panel.default.entry.class");
            ControlPanelEntry controlPanelEntry = (ControlPanelEntry)this.newInstance(portletClassLoader, ControlPanelEntry.class, controlPanelEntryClassName);
            DefaultControlPanelEntryFactory.setInstance(controlPanelEntry);
        }
        if (portalProperties.containsKey("dl.hook.impl")) {
            String dlHookClassName = portalProperties.getProperty("dl.hook.impl");
            Hook dlHook = (Hook)this.newInstance(portletClassLoader, Hook.class, dlHookClassName);
            com.liferay.documentlibrary.util.HookFactory.setInstance(dlHook);
        }
        if (portalProperties.containsKey("image.hook.impl")) {
            String imageHookClassName = portalProperties.getProperty("image.hook.impl");
            com.liferay.portal.kernel.image.Hook imageHook = (com.liferay.portal.kernel.image.Hook)this.newInstance(portletClassLoader, com.liferay.portal.kernel.image.Hook.class, imageHookClassName);
            HookFactory.setInstance(imageHook);
        }
        if (portalProperties.containsKey("ldap.attrs.transformer.impl")) {
            String attributesTransformerClassName = portalProperties.getProperty("ldap.attrs.transformer.impl");
            AttributesTransformer attributesTransformer = (AttributesTransformer)this.newInstance(portletClassLoader, AttributesTransformer.class, attributesTransformerClassName);
            AttributesTransformerFactory.setInstance(attributesTransformer);
        }
        if (portalProperties.containsKey("mail.hook.impl")) {
            String mailHookClassName = portalProperties.getProperty("mail.hook.impl");
            com.liferay.mail.util.Hook mailHook = (com.liferay.mail.util.Hook)this.newInstance(portletClassLoader, com.liferay.mail.util.Hook.class, mailHookClassName);
            com.liferay.mail.util.HookFactory.setInstance(mailHook);
        }
        if (portalProperties.containsKey("sanitizer.impl")) {
            String sanitizerClassName = portalProperties.getProperty("sanitizer.impl");
            Sanitizer sanitizer = (Sanitizer)this.newInstance(portletClassLoader, Sanitizer.class, sanitizerClassName);
            SanitizerWrapper sanitizerWrapper = (SanitizerWrapper)SanitizerUtil.getSanitizer();
            sanitizerWrapper.setSanitizer(sanitizer);
        }
        if (portalProperties.containsKey("users.email.address.generator")) {
            String emailAddressGeneratorClassName = portalProperties.getProperty("users.email.address.generator");
            EmailAddressGenerator emailAddressGenerator = (EmailAddressGenerator)this.newInstance(portletClassLoader, EmailAddressGenerator.class, emailAddressGeneratorClassName);
            EmailAddressGeneratorFactory.setInstance(emailAddressGenerator);
        }
        if (portalProperties.containsKey("users.full.name.generator")) {
            String fullNameGeneratorClassName = portalProperties.getProperty("users.full.name.generator");
            FullNameGenerator fullNameGenerator = (FullNameGenerator)this.newInstance(portletClassLoader, FullNameGenerator.class, fullNameGeneratorClassName);
            FullNameGeneratorFactory.setInstance(fullNameGenerator);
        }
        if (portalProperties.containsKey("users.full.name.validator")) {
            String fullNameValidatorClassName = portalProperties.getProperty("users.full.name.validator");
            FullNameValidator fullNameValidator = (FullNameValidator)this.newInstance(portletClassLoader, FullNameValidator.class, fullNameValidatorClassName);
            FullNameValidatorFactory.setInstance(fullNameValidator);
        }
        if (portalProperties.containsKey("users.screen.name.generator")) {
            String screenNameGeneratorClassName = portalProperties.getProperty("users.screen.name.generator");
            ScreenNameGenerator screenNameGenerator = (ScreenNameGenerator)this.newInstance(portletClassLoader, ScreenNameGenerator.class, screenNameGeneratorClassName);
            ScreenNameGeneratorFactory.setInstance(screenNameGenerator);
        }
        if (portalProperties.containsKey("users.screen.name.validator")) {
            String screenNameValidatorClassName = portalProperties.getProperty("users.screen.name.validator");
            ScreenNameValidator screenNameValidator = (ScreenNameValidator)this.newInstance(portletClassLoader, ScreenNameValidator.class, screenNameValidatorClassName);
            ScreenNameValidatorFactory.setInstance(screenNameValidator);
        }
        if (portalProperties.containsKey("release.info.build.number") || portalProperties.containsKey("upgrade.processes")) {
            this.updateRelease(servletContextName, portletClassLoader, portalProperties);
        }
    }

    protected void initServices(String servletContextName, ClassLoader portletClassLoader, String serviceType, Class<?> serviceTypeClass, Constructor<?> serviceImplConstructor, Object serviceProxy) throws Exception {
        InvocationHandler invocationHandler;
        ServiceBag serviceBag = this._servicesContainer.findByServiceType(serviceType);
        if (serviceBag != null) {
            throw new IllegalStateException(String.valueOf(serviceType) + " is already overridden by " + serviceBag.getServletContextName());
        }
        AdvisedSupport advisedSupport = this.getAdvisedSupport(serviceProxy);
        TargetSource targetSource = advisedSupport.getTargetSource();
        Object originalService = targetSource.getTarget();
        if (Proxy.isProxyClass(originalService.getClass()) && (invocationHandler = Proxy.getInvocationHandler(originalService)) instanceof ClassLoaderBeanHandler) {
            ClassLoaderBeanHandler classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler;
            originalService = classLoaderBeanHandler.getBean();
        }
        Object customService = serviceImplConstructor.newInstance(originalService);
        Object customTarget = Proxy.newProxyInstance(portletClassLoader, new Class[]{serviceTypeClass}, (InvocationHandler)new ClassLoaderBeanHandler(customService, portletClassLoader));
        SingletonTargetSource customTargetSource = new SingletonTargetSource(customTarget);
        advisedSupport.setTargetSource((TargetSource)customTargetSource);
        this._servicesContainer.addServiceBag(servletContextName, serviceType, originalService);
    }

    protected void resetPortalProperties(String servletContextName, Properties portalProperties, boolean initPhase) throws Exception {
        Object value;
        Field field;
        String fieldName;
        String key;
        String[] stringArray = _PROPS_VALUES_BOOLEAN;
        int n = _PROPS_VALUES_BOOLEAN.length;
        int n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            fieldName = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
            if (this.containsKey(portalProperties, key)) {
                try {
                    field = PropsValues.class.getField(fieldName);
                    value = GetterUtil.getBoolean((String)PropsUtil.get(key));
                    field.setBoolean(null, (Boolean)value);
                }
                catch (Exception e) {
                    _log.error((Object)("Error setting field " + fieldName + ": " + e.getMessage()));
                }
            }
            ++n2;
        }
        stringArray = _PROPS_VALUES_INTEGER;
        n = _PROPS_VALUES_INTEGER.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            fieldName = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
            if (this.containsKey(portalProperties, key)) {
                try {
                    field = PropsValues.class.getField(fieldName);
                    value = GetterUtil.getInteger((String)PropsUtil.get(key));
                    field.setInt(null, (Integer)value);
                }
                catch (Exception e) {
                    _log.error((Object)("Error setting field " + fieldName + ": " + e.getMessage()));
                }
            }
            ++n2;
        }
        stringArray = _PROPS_VALUES_LONG;
        n = _PROPS_VALUES_LONG.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            fieldName = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
            if (this.containsKey(portalProperties, key)) {
                try {
                    field = PropsValues.class.getField(fieldName);
                    value = GetterUtil.getLong((String)PropsUtil.get(key));
                    field.setLong(null, (Long)value);
                }
                catch (Exception e) {
                    _log.error((Object)("Error setting field " + fieldName + ": " + e.getMessage()));
                }
            }
            ++n2;
        }
        stringArray = _PROPS_VALUES_STRING;
        n = _PROPS_VALUES_STRING.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            fieldName = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
            if (this.containsKey(portalProperties, key)) {
                try {
                    field = PropsValues.class.getField(fieldName);
                    value = GetterUtil.getString((String)PropsUtil.get(key));
                    field.set(null, value);
                }
                catch (Exception e) {
                    _log.error((Object)("Error setting field " + fieldName + ": " + e.getMessage()));
                }
            }
            ++n2;
        }
        stringArray = _PROPS_VALUES_STRING_ARRAY;
        n = _PROPS_VALUES_STRING_ARRAY.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            fieldName = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
            if (this.containsKey(portalProperties, key)) {
                try {
                    field = PropsValues.class.getField(fieldName);
                    StringArraysContainer stringArraysContainer = this._stringArraysContainerMap.get(key);
                    String[] value2 = null;
                    if (initPhase) {
                        value2 = PropsUtil.getArray(key);
                    }
                    stringArraysContainer.setPluginStringArray(servletContextName, value2);
                    value2 = stringArraysContainer.getMergedStringArray();
                    field.set(null, value2);
                }
                catch (Exception e) {
                    _log.error((Object)("Error setting field " + fieldName + ": " + e.getMessage()));
                }
            }
            ++n2;
        }
        if (this.containsKey(portalProperties, "locales")) {
            PropsValues.LOCALES = PropsUtil.getArray("locales");
            LanguageUtil.init();
        }
        CacheUtil.clearCache();
        JavaScriptBundleUtil.clearCache();
    }

    protected void updateRelease(String servletContextName, ClassLoader portletClassLoader, Properties portalProperties) throws Exception {
        int buildNumber = GetterUtil.getInteger((String)portalProperties.getProperty("release.info.build.number"));
        if (buildNumber <= 0) {
            _log.error((Object)("Skipping upgrade processes for " + servletContextName + " because \"release.info.build.number\" is not specified"));
            return;
        }
        Release release = null;
        try {
            release = ReleaseLocalServiceUtil.getRelease((String)servletContextName, (int)buildNumber);
        }
        catch (PortalException portalException) {
            int previousBuildNumber = GetterUtil.getInteger((String)portalProperties.getProperty("release.info.previous.build.number"), (int)buildNumber);
            release = ReleaseLocalServiceUtil.addRelease((String)servletContextName, (int)previousBuildNumber);
        }
        if (buildNumber == release.getBuildNumber()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping upgrade processes for " + servletContextName + " because it is already up to date"));
            }
        } else {
            if (buildNumber < release.getBuildNumber()) {
                throw new UpgradeException("Skipping upgrade processes for " + servletContextName + " because you are trying to upgrade with an older version");
            }
            String[] upgradeProcessClassNames = StringUtil.split((String)portalProperties.getProperty("upgrade.processes"));
            UpgradeProcessUtil.upgradeProcess(release.getBuildNumber(), upgradeProcessClassNames, portletClassLoader);
        }
        ReleaseLocalServiceUtil.updateRelease((long)release.getReleaseId(), (int)buildNumber, null, (boolean)true);
    }

    private class AuthFailuresContainer {
        Map<String, List<AuthFailure>> _authFailures = new HashMap<String, List<AuthFailure>>();

        private AuthFailuresContainer() {
        }

        public void registerAuthFailure(String key, AuthFailure authFailure) {
            List<AuthFailure> authFailures = this._authFailures.get(key);
            if (authFailures == null) {
                authFailures = new ArrayList<AuthFailure>();
                this._authFailures.put(key, authFailures);
            }
            AuthPipeline.registerAuthFailure(key, authFailure);
            authFailures.add(authFailure);
        }

        public void unregisterAuthFailures() {
            for (Map.Entry<String, List<AuthFailure>> entry : this._authFailures.entrySet()) {
                String key = entry.getKey();
                List<AuthFailure> authFailures = entry.getValue();
                for (AuthFailure authFailure : authFailures) {
                    AuthPipeline.unregisterAuthFailure(key, authFailure);
                }
            }
        }
    }

    private class AuthenticatorsContainer {
        Map<String, List<Authenticator>> _authenticators = new HashMap<String, List<Authenticator>>();

        private AuthenticatorsContainer() {
        }

        public void registerAuthenticator(String key, Authenticator authenticator) {
            List<Authenticator> authenticators = this._authenticators.get(key);
            if (authenticators == null) {
                authenticators = new ArrayList<Authenticator>();
                this._authenticators.put(key, authenticators);
            }
            AuthPipeline.registerAuthenticator(key, authenticator);
            authenticators.add(authenticator);
        }

        public void unregisterAuthenticators() {
            for (Map.Entry<String, List<Authenticator>> entry : this._authenticators.entrySet()) {
                String key = entry.getKey();
                List<Authenticator> authenticators = entry.getValue();
                for (Authenticator authenticator : authenticators) {
                    AuthPipeline.unregisterAuthenticator(key, authenticator);
                }
            }
        }
    }

    private class AutoDeployListenersContainer {
        private List<AutoDeployListener> _autoDeployListeners = new ArrayList<AutoDeployListener>();

        private AutoDeployListenersContainer() {
        }

        public void registerAutoDeployListener(AutoDeployListener autoDeployListener) {
            AutoDeployDir autoDeployDir = AutoDeployUtil.getDir((String)"defaultAutoDeployDir");
            if (autoDeployDir == null) {
                return;
            }
            autoDeployDir.registerListener(autoDeployListener);
            this._autoDeployListeners.add(autoDeployListener);
        }

        public void unregisterAutoDeployListeners() {
            AutoDeployDir autoDeployDir = AutoDeployUtil.getDir((String)"defaultAutoDeployDir");
            if (autoDeployDir == null) {
                return;
            }
            for (AutoDeployListener autoDeployListener : this._autoDeployListeners) {
                autoDeployDir.unregisterListener(autoDeployListener);
            }
        }
    }

    private class AutoLoginsContainer {
        List<AutoLogin> _autoLogins = new ArrayList<AutoLogin>();

        private AutoLoginsContainer() {
        }

        public void registerAutoLogin(AutoLogin autoLogin) {
            AutoLoginFilter.registerAutoLogin(autoLogin);
            this._autoLogins.add(autoLogin);
        }

        public void unregisterAutoLogins() {
            for (AutoLogin autoLogin : this._autoLogins) {
                AutoLoginFilter.unregisterAutoLogin(autoLogin);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomJspBag {
        private String _customJspDir;
        private List<String> _customJsps;

        public CustomJspBag(String customJspDir, List<String> customJsps) {
            this._customJspDir = customJspDir;
            this._customJsps = customJsps;
        }

        public String getCustomJspDir() {
            return this._customJspDir;
        }

        public List<String> getCustomJsps() {
            return this._customJsps;
        }
    }

    private class EventsContainer {
        private Map<String, List<Object>> _eventsMap = new HashMap<String, List<Object>>();

        private EventsContainer() {
        }

        public void registerEvent(String eventName, Object event) {
            List<Object> events = this._eventsMap.get(eventName);
            if (events == null) {
                events = new ArrayList<Object>();
                this._eventsMap.put(eventName, events);
            }
            events.add(event);
        }

        public void unregisterEvents() {
            for (Map.Entry<String, List<Object>> entry : this._eventsMap.entrySet()) {
                String eventName = entry.getKey();
                List<Object> events = entry.getValue();
                for (Object event : events) {
                    EventsProcessorUtil.unregisterEvent(eventName, event);
                }
            }
        }
    }

    private class HotDeployListenersContainer {
        private List<HotDeployListener> _hotDeployListeners = new ArrayList<HotDeployListener>();

        private HotDeployListenersContainer() {
        }

        public void registerHotDeployListener(HotDeployListener hotDeployListener) {
            HotDeployUtil.registerListener((HotDeployListener)hotDeployListener);
            this._hotDeployListeners.add(hotDeployListener);
        }

        public void unregisterHotDeployListeners() {
            for (HotDeployListener hotDeployListener : this._hotDeployListeners) {
                HotDeployUtil.unregisterListener((HotDeployListener)hotDeployListener);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LanguagesContainer {
        private Map<Locale, Map<String, String>> _languagesMap = new HashMap<Locale, Map<String, String>>();

        private LanguagesContainer() {
        }

        public void addLanguage(Locale locale, Map<String, String> languageMap) {
            Map<String, String> oldLanguageMap = LanguageResources.putLanguageMap(locale, languageMap);
            this._languagesMap.put(locale, oldLanguageMap);
        }

        public void unregisterLanguages() {
            for (Map.Entry<Locale, Map<String, String>> entry : this._languagesMap.entrySet()) {
                Locale locale = entry.getKey();
                Map<String, String> languageMap = entry.getValue();
                LanguageResources.putLanguageMap(locale, languageMap);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelListenersContainer {
        private Map<String, List<ModelListener<BaseModel<?>>>> _modelListenersMap = new HashMap();

        private ModelListenersContainer() {
        }

        public void registerModelListener(String modelName, ModelListener<BaseModel<?>> modelListener) {
            List<ModelListener<BaseModel<?>>> modelListeners = this._modelListenersMap.get(modelName);
            if (modelListeners == null) {
                modelListeners = new ArrayList();
                this._modelListenersMap.put(modelName, modelListeners);
            }
            modelListeners.add(modelListener);
        }

        public void unregisterModelListeners() {
            for (Map.Entry<String, List<ModelListener<BaseModel<?>>>> entry : this._modelListenersMap.entrySet()) {
                String modelName = entry.getKey();
                List<ModelListener<BaseModel<?>>> modelListeners = entry.getValue();
                BasePersistence<?> persistence = HookHotDeployListener.this.getPersistence(modelName);
                for (ModelListener<BaseModel<?>> modelListener : modelListeners) {
                    persistence.unregisterListener(modelListener);
                }
            }
        }
    }

    private class ServiceBag {
        private Object _originalService;
        private String _serviceType;
        private String _servletContextName;

        public ServiceBag(String servletContextName, String serviceType, Object originalService) {
            this._servletContextName = servletContextName;
            this._serviceType = serviceType;
            this._originalService = originalService;
        }

        public Object getOriginalService() {
            return this._originalService;
        }

        public String getServiceType() {
            return this._serviceType;
        }

        public String getServletContextName() {
            return this._servletContextName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServicesContainer {
        private List<ServiceBag> _serviceBags = new ArrayList<ServiceBag>();

        private ServicesContainer() {
        }

        public void addServiceBag(String servletContextName, String serviceType, Object originalService) {
            ServiceBag serviceBag = new ServiceBag(servletContextName, serviceType, originalService);
            this._serviceBags.add(serviceBag);
        }

        public ServiceBag findByServiceType(String serviceType) {
            for (ServiceBag serviceBag : this._serviceBags) {
                if (!serviceBag.getServiceType().equals(serviceType)) continue;
                return serviceBag;
            }
            return null;
        }

        public List<ServiceBag> findByServletContextName(String servletContextName) {
            ArrayList<ServiceBag> serviceBags = new ArrayList<ServiceBag>();
            for (ServiceBag serviceBag : this._serviceBags) {
                if (!serviceBag.getServletContextName().equals(servletContextName)) continue;
                serviceBags.add(serviceBag);
            }
            return serviceBags;
        }

        public void removeByServletContextName(String servletContextName) {
            Iterator<ServiceBag> itr = this._serviceBags.iterator();
            while (itr.hasNext()) {
                ServiceBag serviceBag = itr.next();
                if (!serviceBag.getServletContextName().equals(servletContextName)) continue;
                itr.remove();
            }
        }
    }

    private class StringArraysContainer {
        private String[] _portalStringArray;
        private Map<String, String[]> _pluginStringArrayMap = new HashMap<String, String[]>();

        private StringArraysContainer(String key) {
            this._portalStringArray = PropsUtil.getArray(key);
        }

        public String[] getMergedStringArray() {
            UniqueList mergedStringList = new UniqueList();
            mergedStringList.addAll(ListUtil.fromArray((Object[])this._portalStringArray));
            for (Map.Entry<String, String[]> entry : this._pluginStringArrayMap.entrySet()) {
                Object[] pluginStringArray = entry.getValue();
                mergedStringList.addAll(ListUtil.fromArray((Object[])pluginStringArray));
            }
            return mergedStringList.toArray(new String[mergedStringList.size()]);
        }

        public void setPluginStringArray(String servletContextName, String[] pluginStringArray) {
            if (pluginStringArray != null) {
                this._pluginStringArrayMap.put(servletContextName, pluginStringArray);
            } else {
                this._pluginStringArrayMap.remove(servletContextName);
            }
        }
    }
}

