/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.jpa;

import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.dao.orm.jpa.ExceptionTranslator;
import com.liferay.portal.dao.orm.jpa.ScrollableResultsImpl;
import com.liferay.portal.dao.orm.jpa.SessionImpl;
import com.liferay.portal.kernel.dao.orm.CacheMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.ScrollableResults;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnmodifiableList;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.FlushModeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl
implements Query {
    protected Class<?> entityClass = null;
    protected int firstResult = -1;
    protected FlushModeType flushModeType = null;
    protected int maxResults = -1;
    protected Map<Integer, Object> parameterMap = new HashMap<Integer, Object>();
    protected String queryString;
    protected SessionImpl sessionImpl;
    protected boolean sqlQuery = false;
    private static final String _HQL_COMPOSITE_ID_MARKER = "\\.id\\.";
    private static final String _HQL_NOT_EQUALS = "!=";
    private static final String _JPQL_DOT_SEPARTOR = ".";
    private static final String _JPQL_NOT_EQUALS = "<>";

    public QueryImpl(SessionImpl sessionImpl, String queryString) {
        this.sessionImpl = sessionImpl;
        this.queryString = this._hqlTojpql(SQLTransformer.transform(queryString));
    }

    public int executeUpdate() throws ORMException {
        try {
            return this.sessionImpl.executeUpdate(this.queryString, this.parameterMap, this.firstResult, this.maxResults, this.flushModeType, this.sqlQuery, this.entityClass);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Iterator<?> iterate() throws ORMException {
        return this.iterate(true);
    }

    public Iterator<?> iterate(boolean unmodifiable) throws ORMException {
        try {
            return this.list(unmodifiable).iterator();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public List<?> list() throws ORMException {
        return this.list(true);
    }

    public List<?> list(boolean unmodifiable) throws ORMException {
        try {
            List<?> list = this.sessionImpl.list(this.queryString, this.parameterMap, this.firstResult, this.maxResults, this.flushModeType, this.sqlQuery, this.entityClass);
            if (unmodifiable) {
                return new UnmodifiableList(list);
            }
            return ListUtil.copy(list);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public ScrollableResults scroll() throws ORMException {
        try {
            return new ScrollableResultsImpl(this.list());
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Query setBoolean(int pos, boolean value) {
        this.parameterMap.put(pos, value);
        return this;
    }

    public Query setCacheable(boolean cacheable) {
        return this;
    }

    public Query setCacheMode(CacheMode cacheMode) {
        return this;
    }

    public Query setCacheRegion(String cacheRegion) {
        return this;
    }

    public Query setDouble(int pos, double value) {
        this.parameterMap.put(pos, value);
        return this;
    }

    public Query setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public Query setFloat(int pos, float value) {
        this.parameterMap.put(pos, Float.valueOf(value));
        return this;
    }

    public Query setFlushMode(FlushModeType flushModeType) {
        this.flushModeType = flushModeType;
        return this;
    }

    public Query setInteger(int pos, int value) {
        this.parameterMap.put(pos, value);
        return this;
    }

    public Query setLong(int pos, long value) {
        this.parameterMap.put(pos, value);
        return this;
    }

    public Query setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public Query setSerializable(int pos, Serializable value) {
        this.parameterMap.put(pos, value);
        return this;
    }

    public Query setShort(int pos, short value) {
        this.parameterMap.put(pos, value);
        return this;
    }

    public Query setString(int pos, String value) {
        this.parameterMap.put(pos, value);
        return this;
    }

    public Query setTimestamp(int pos, Timestamp value) {
        Date date = null;
        if (value != null) {
            date = new Date(value.getTime());
        }
        this.parameterMap.put(pos, date);
        return this;
    }

    public Object uniqueResult() throws ORMException {
        try {
            return this.sessionImpl.uniqueResult(this.queryString, this.parameterMap, this.firstResult, this.maxResults, this.flushModeType, this.sqlQuery, this.entityClass);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    private String _hqlTojpql(String queryString) {
        queryString = this._transformPositionalParams(queryString);
        queryString = queryString.replaceAll(_HQL_NOT_EQUALS, _JPQL_NOT_EQUALS);
        queryString = queryString.replaceAll(_HQL_COMPOSITE_ID_MARKER, _JPQL_DOT_SEPARTOR);
        return queryString;
    }

    private String _transformPositionalParams(String queryString) {
        if (queryString.indexOf(63) == -1) {
            return queryString;
        }
        StringBundler sb = new StringBundler();
        int i = 1;
        int from = 0;
        int to = 0;
        while ((to = queryString.indexOf(63, from)) != -1) {
            sb.append(queryString.substring(from, to));
            sb.append("?");
            sb.append(i++);
            from = to + 1;
        }
        sb.append(queryString.substring(from, queryString.length()));
        return sb.toString();
    }
}

