/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.CacheProviderWrapper;
import com.liferay.portal.kernel.exception.SystemException;
import java.lang.reflect.Field;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.util.FailSafeTimer;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;

public class EhCacheProvider
extends CacheProviderWrapper {
    private static CacheProvider _cacheProvider;

    public static CacheManager getCacheManager() throws SystemException {
        try {
            Class<?> clazz = Class.forName("net.sf.ehcache.hibernate.AbstractEhcacheProvider");
            Field field = clazz.getDeclaredField("manager");
            field.setAccessible(true);
            CacheManager cacheManager = (CacheManager)field.get(_cacheProvider);
            if (cacheManager == null) {
                throw new SystemException("CacheManager has been initialized");
            }
            return cacheManager;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public EhCacheProvider() {
        super("net.sf.ehcache.hibernate.EhCacheProvider");
        _cacheProvider = this.cacheProvider;
    }

    public void start(Properties properties) throws CacheException {
        super.start(properties);
        try {
            CacheManager cacheManager = EhCacheProvider.getCacheManager();
            FailSafeTimer failSafeTimer = cacheManager.getTimer();
            failSafeTimer.cancel();
        }
        catch (SystemException se) {
            throw new CacheException((Throwable)se);
        }
    }
}

