/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.cache.transactional.TransactionalPortalCache;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCacheImpl
implements CacheRegistryItem,
EntityCache {
    public static final String CACHE_NAME = EntityCache.class.getName();
    private static Log _log = LogFactoryUtil.getLog(EntityCacheImpl.class);
    private static final String _GROUP_KEY_PREFIX = CACHE_NAME.concat(".");
    private static ThreadLocal<LRUMap> _localCache;
    private static boolean _localCacheAvailable;
    private MultiVMPool _multiVMPool;
    private ConcurrentMap<String, PortalCache> _portalCaches = new ConcurrentHashMap<String, PortalCache>();

    static {
        if (PropsValues.VALUE_OBJECT_ENTITY_THREAD_LOCAL_CACHE_MAX_SIZE > 0) {
            _localCache = new AutoResetThreadLocal(EntityCacheImpl.class + "._localCache", (Object)new LRUMap(PropsValues.VALUE_OBJECT_ENTITY_THREAD_LOCAL_CACHE_MAX_SIZE));
            _localCacheAvailable = true;
        }
    }

    public void afterPropertiesSet() {
        CacheRegistryUtil.register((CacheRegistryItem)this);
    }

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(String className) {
        this.clearLocalCache();
        PortalCache portalCache = this._getPortalCache(className, false);
        if (portalCache != null) {
            portalCache.removeAll();
        }
    }

    public void clearLocalCache() {
        if (_localCacheAvailable) {
            _localCache.remove();
        }
    }

    public String getRegistryName() {
        return CACHE_NAME;
    }

    public Object getResult(boolean entityCacheEnabled, Class<?> classObj, Serializable primaryKeyObj, SessionFactory sessionFactory) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            return null;
        }
        Object result = null;
        Map localCache = null;
        String localCacheKey = null;
        if (_localCacheAvailable) {
            localCache = (Map)_localCache.get();
            localCacheKey = this._encodeLocalCacheKey(classObj, primaryKeyObj);
            result = localCache.get(localCacheKey);
        }
        if (result == null) {
            String cacheKey;
            PortalCache portalCache = this._getPortalCache(classObj.getName(), true);
            result = portalCache.get(cacheKey = this._encodeCacheKey(primaryKeyObj));
            if (result == null) {
                result = "";
                portalCache.put(cacheKey, result);
            }
            if (_localCacheAvailable) {
                localCache.put(localCacheKey, result);
            }
        }
        if (result != null) {
            result = this._objectToResult(result);
        }
        return result;
    }

    public void invalidate() {
        this.clearCache();
    }

    public Object loadResult(boolean entityCacheEnabled, Class<?> classObj, Serializable primaryKeyObj, SessionFactory sessionFactory) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            Session session = null;
            try {
                session = sessionFactory.openSession();
                Object object = session.load(classObj, primaryKeyObj);
                return object;
            }
            finally {
                sessionFactory.closeSession(session);
            }
        }
        Object result = null;
        Map localCache = null;
        String localCacheKey = null;
        if (_localCacheAvailable) {
            localCache = (Map)_localCache.get();
            localCacheKey = this._encodeLocalCacheKey(classObj, primaryKeyObj);
            result = localCache.get(localCacheKey);
        }
        boolean load = false;
        if (result == null) {
            String cacheKey;
            PortalCache portalCache = this._getPortalCache(classObj.getName(), true);
            result = portalCache.get(cacheKey = this._encodeCacheKey(primaryKeyObj));
            if (result == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Load " + classObj + " " + primaryKeyObj + " from session"));
                }
                load = true;
                Session session = null;
                try {
                    session = sessionFactory.openSession();
                    result = session.load(classObj, primaryKeyObj);
                }
                finally {
                    result = result == null ? "" : this._objectToResult(result);
                    portalCache.put(cacheKey, result);
                    sessionFactory.closeSession(session);
                }
            }
            if (_localCacheAvailable) {
                localCache.put(localCacheKey, result);
            }
        }
        if (!load) {
            return this._objectToResult(result);
        }
        if (result instanceof String) {
            return null;
        }
        return result;
    }

    public void putResult(boolean entityCacheEnabled, Class<?> classObj, Serializable primaryKeyObj, Object result) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive() && result != null)) {
            return;
        }
        result = this._objectToResult(result);
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            String localCacheKey = this._encodeLocalCacheKey(classObj, primaryKeyObj);
            localCache.put(localCacheKey, result);
        }
        PortalCache portalCache = this._getPortalCache(classObj.getName(), true);
        String cacheKey = this._encodeCacheKey(primaryKeyObj);
        portalCache.put(cacheKey, result);
    }

    public void removeCache(String className) {
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._portalCaches.remove(groupKey);
        this._multiVMPool.removeCache(groupKey);
    }

    public void removeResult(boolean entityCacheEnabled, Class<?> classObj, Serializable primaryKeyObj) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            return;
        }
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            String localCacheKey = this._encodeLocalCacheKey(classObj, primaryKeyObj);
            localCache.remove(localCacheKey);
        }
        PortalCache portalCache = this._getPortalCache(classObj.getName(), true);
        String cacheKey = this._encodeCacheKey(primaryKeyObj);
        portalCache.remove(cacheKey);
    }

    public void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    private String _encodeCacheKey(Serializable primaryKeyObj) {
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)CACHE_NAME);
        cacheKeyGenerator.append(ShardUtil.getCurrentShardName());
        cacheKeyGenerator.append(primaryKeyObj.toString());
        return cacheKeyGenerator.finish();
    }

    private String _encodeLocalCacheKey(Class<?> classObj, Serializable primaryKeyObj) {
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)CACHE_NAME);
        cacheKeyGenerator.append(ShardUtil.getCurrentShardName());
        cacheKeyGenerator.append(classObj.getName());
        cacheKeyGenerator.append(primaryKeyObj.toString());
        return cacheKeyGenerator.finish();
    }

    private PortalCache _getPortalCache(String className, boolean createIfAbsent) {
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        Object portalCache = (PortalCache)this._portalCaches.get(groupKey);
        if (portalCache == null && createIfAbsent) {
            PortalCache previousPortalCache;
            portalCache = this._multiVMPool.getCache(groupKey, PropsValues.VALUE_OBJECT_ENTITY_BLOCKING_CACHE);
            if (PropsValues.TRANSACTIONAL_CACHE_ENABLED) {
                portalCache = new TransactionalPortalCache((PortalCache)portalCache);
            }
            if ((previousPortalCache = this._portalCaches.putIfAbsent(groupKey, (PortalCache)portalCache)) != null) {
                portalCache = previousPortalCache;
            }
            portalCache.setDebug(true);
        }
        return portalCache;
    }

    private Object _objectToResult(Object result) {
        if (result instanceof String) {
            return null;
        }
        result = ((BaseModel)result).clone();
        BaseModel model = (BaseModel)result;
        model.setCachedModel(true);
        return model;
    }
}

