/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cmis.model;

import com.liferay.portal.cmis.model.CMISConstants;
import com.liferay.portal.cmis.model.CMISConstants_1_0_0;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISObject
extends ExtensibleElementWrapper {
    private static final String _DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private CMISConstants _cmisConstants = CMISConstants.getInstance();

    public CMISObject(Element element) {
        super(element);
    }

    public CMISObject(Factory factory) {
        super(factory, CMISConstants.getInstance().OBJECT);
    }

    public String getBaseType() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_BASETYPE);
    }

    public String getCheckinComment() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_CHECKIN_COMMENT);
    }

    public String getContentStreamFilename() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_CONTENT_STREAM_FILENAME);
    }

    public int getContentStreamLength() {
        String value = this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_CONTENT_STREAM_LENGTH);
        return GetterUtil.getInteger((String)value);
    }

    public String getContentStreamMimetype() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_CONTENT_STREAM_MIMETYPE);
    }

    public String getContentStreamUri() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_CONTENT_STREAM_URI);
    }

    public String getCreatedBy() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_CREATED_BY);
    }

    public Date getCreationDate() {
        return this.getDate(this._cmisConstants.PROPERTY_NAME_CREATION_DATE);
    }

    public Date getLastModificationDate() {
        return this.getDate(this._cmisConstants.PROPERTY_NAME_LAST_MODIFICATION_DATE);
    }

    public String getLastModifiedBy() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_LAST_MODIFIED_BY);
    }

    public String getName() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_NAME);
    }

    public String getObjectId() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_OBJECT_ID);
    }

    public String getObjectTypeId() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_OBJECT_TYPE_ID);
    }

    public String getSourceId() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_SOURCE_ID);
    }

    public String getTargetId() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_TARGET_ID);
    }

    public String getVersionLabel() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_VERSION_LABEL);
    }

    public String getVersionSeriesCheckedOutBy() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_VERSION_SERIES_CHECKED_OUT_BY);
    }

    public String getVersionSeriesCheckedOutId() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_VERSION_SERIES_CHECKED_OUT_ID);
    }

    public String getVersionSeriesId() {
        return this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_VERSION_SERIES_ID);
    }

    public boolean isImmutable() {
        return GetterUtil.getBoolean((String)this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_IS_IMMUTABLE));
    }

    public boolean isLatestMajorVersion() {
        return GetterUtil.getBoolean((String)this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_IS_LATEST_MAJOR_VERSION));
    }

    public boolean isLatestVersion() {
        return GetterUtil.getBoolean((String)this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_IS_LATEST_VERSION));
    }

    public boolean isMajorVersion() {
        return GetterUtil.getBoolean((String)this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_IS_MAJOR_VERSION));
    }

    public boolean isVersionSeriesCheckedOut() {
        return GetterUtil.getBoolean((String)this.getPropertyValue(this._cmisConstants.PROPERTY_NAME_IS_VERSION_SERIES_CHECKED_OUT));
    }

    public void setValue(String propertyName, Serializable propertyValue) {
        Factory factory = this.getFactory();
        Element propertiesElement = this.getFirstChild(this._cmisConstants.PROPERTIES);
        if (propertiesElement == null) {
            propertiesElement = factory.newElement(this._cmisConstants.PROPERTIES);
            this.addExtension(propertiesElement);
        }
        Element propertyElement = null;
        if (propertyValue instanceof Date) {
            propertyElement = factory.newElement(this._cmisConstants.PROPERTY_TYPE_DATETIME, (Base)propertiesElement);
            propertyValue = _dateFormat.format(propertyValue);
        } else {
            propertyElement = propertyValue instanceof Double ? factory.newElement(this._cmisConstants.PROPERTY_TYPE_DECIMAL, (Base)propertiesElement) : (propertyValue instanceof Integer ? factory.newElement(this._cmisConstants.PROPERTY_TYPE_INTEGER, (Base)propertiesElement) : (propertyValue.toString().startsWith("http") ? factory.newElement(this._cmisConstants.PROPERTY_TYPE_URI, (Base)propertiesElement) : factory.newElement(this._cmisConstants.PROPERTY_TYPE_STRING, (Base)propertiesElement)));
        }
        if (this._cmisConstants instanceof CMISConstants_1_0_0) {
            propertyElement.setAttributeValue(this._cmisConstants.PROPERTY_DEFINITION_ID, propertyName);
        } else {
            propertyElement.setAttributeValue(this._cmisConstants.PROPERTY_NAME, propertyName);
        }
        Element valueElement = factory.newElement(this._cmisConstants.PROPERTY_VALUE, (Base)propertyElement);
        valueElement.setText(propertyValue.toString());
    }

    protected Date getDate(String propertyName) {
        try {
            String value = this.getPropertyValue(propertyName);
            DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_DATE_FORMAT_PATTERN);
            return dateFormat.parse(value);
        }
        catch (Exception exception) {
            return new Date();
        }
    }

    protected List<String> getPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        Element propertiesElement = this.getFirstChild(this._cmisConstants.PROPERTIES);
        for (Element propertyElement : propertiesElement.getElements()) {
            String propertyName = propertyElement.getAttributeValue(this._cmisConstants.PROPERTY_NAME);
            propertyNames.add(propertyName);
        }
        return propertyNames;
    }

    protected String getPropertyValue(String propertyName) {
        String propertyValue = null;
        Element propertiesElement = this.getFirstChild(this._cmisConstants.PROPERTIES);
        for (Element propertyElement : propertiesElement.getElements()) {
            String curPropertyName = propertyElement.getAttributeValue(this._cmisConstants.PROPERTY_DEFINITION_ID);
            if (!propertyName.equals(curPropertyName)) continue;
            Element propertyValueElement = propertyElement.getFirstChild(this._cmisConstants.PROPERTY_VALUE);
            if (propertyValueElement == null) break;
            propertyValue = propertyValueElement.getText();
            break;
        }
        return propertyValue;
    }
}

