/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.EhcachePortalCache;
import com.liferay.portal.kernel.cache.BlockingPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.net.URL;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.management.ManagementService;
import net.sf.ehcache.util.FailSafeTimer;

public class EhcachePortalCacheManager
implements PortalCacheManager {
    private static Log _log = LogFactoryUtil.getLog(EhcachePortalCacheManager.class);
    private String _configPropertyKey;
    private CacheManager _cacheManager;
    private boolean _debug;
    private ManagementService _managementService;
    private MBeanServer _mBeanServer;
    private boolean _registerCacheManager = true;
    private boolean _registerCaches = true;
    private boolean _registerCacheConfigurations = true;
    private boolean _registerCacheStatistics = true;

    public void afterPropertiesSet() {
        URL url = this.getClass().getResource(PropsUtil.get(this._configPropertyKey));
        this._cacheManager = new CacheManager(url);
        FailSafeTimer failSafeTimer = this._cacheManager.getTimer();
        failSafeTimer.cancel();
        if (PropsValues.EHCACHE_PORTAL_CACHE_MANAGER_JMX_ENABLED) {
            this._managementService = new ManagementService(this._cacheManager, this._mBeanServer, this._registerCacheManager, this._registerCaches, this._registerCacheConfigurations, this._registerCacheStatistics);
            this._managementService.init();
        }
    }

    public void clearAll() {
        this._cacheManager.clearAll();
    }

    public void destroy() throws Exception {
        try {
            this._cacheManager.shutdown();
        }
        finally {
            if (this._managementService != null) {
                this._managementService.dispose();
            }
        }
    }

    public PortalCache getCache(String name) {
        return this.getCache(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortalCache getCache(String name, boolean blocking) {
        Ehcache cache = this._cacheManager.getEhcache(name);
        if (cache == null) {
            CacheManager cacheManager = this._cacheManager;
            synchronized (cacheManager) {
                cache = this._cacheManager.getEhcache(name);
                if (cache == null) {
                    try {
                        this._cacheManager.addCache(name);
                    }
                    catch (ObjectExistsException objectExistsException) {}
                    cache = this._cacheManager.getEhcache(name);
                    cache.setStatisticsEnabled(PropsValues.EHCACHE_STATISTICS_ENABLED);
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Cache name " + name + " is using implementation " + cache.getClass().getName()));
                    }
                }
            }
        }
        EhcachePortalCache portalCache = new EhcachePortalCache(cache);
        portalCache.setDebug(this._debug);
        if (PropsValues.EHCACHE_BLOCKING_CACHE_ALLOWED && blocking) {
            portalCache = new BlockingPortalCache((PortalCache)portalCache);
        }
        return portalCache;
    }

    public CacheManager getEhcacheManager() {
        return this._cacheManager;
    }

    public void removeCache(String name) {
        this._cacheManager.removeCache(name);
    }

    public void setConfigPropertyKey(String configPropertyKey) {
        this._configPropertyKey = configPropertyKey;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this._mBeanServer = mBeanServer;
    }

    public void setRegisterCacheConfigurations(boolean registerCacheConfigurations) {
        this._registerCacheConfigurations = registerCacheConfigurations;
    }

    public void setRegisterCacheManager(boolean registerCacheManager) {
        this._registerCacheManager = registerCacheManager;
    }

    public void setRegisterCaches(boolean registerCaches) {
        this._registerCaches = registerCaches;
    }

    public void setRegisterCacheStatistics(boolean registerCacheStatistics) {
        this._registerCacheStatistics = registerCacheStatistics;
    }
}

