/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.bean.Renderer;
import com.liferay.portal.kernel.bean.RendererException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.velocity.VelocityVariables;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendererImpl
implements Renderer {
    private static final String _BEAN = "bean";
    private static final String _LOCAL_SERVICE_UTIL = "LocalServiceUtil";
    private static final String _MODEL = ".model.";
    private static final String _SERVICE = ".service.";
    private static Log _log = LogFactoryUtil.getLog(RendererImpl.class);

    public String renderBean(HttpServletRequest request, HttpServletResponse response, Object bean) throws RendererException {
        return this.renderBean(request, response, null, bean, null);
    }

    public String renderBean(HttpServletRequest request, HttpServletResponse response, Object bean, String varientSuffix) throws RendererException {
        return this.renderBean(request, response, null, bean, varientSuffix);
    }

    public String renderBean(HttpServletRequest request, HttpServletResponse response, String servletContextName, Object bean) throws RendererException {
        return this.renderBean(request, response, servletContextName, bean, null);
    }

    public String renderBean(HttpServletRequest request, HttpServletResponse response, String servletContextName, Object bean, String varientSuffix) throws RendererException {
        if (bean == null) {
            return null;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String className = this._normalizeClassName(bean.getClass().getName());
        if (Validator.isNotNull((String)varientSuffix)) {
            className = varientSuffix;
        }
        String velocityTemplateContent = null;
        PortletPreferences preferences = this._getPortletPreferences(request);
        if (preferences != null) {
            velocityTemplateContent = preferences.getValue("renderer.template." + className, "");
        }
        if (Validator.isNull(velocityTemplateContent) && Validator.isNotNull((String)servletContextName)) {
            if (servletContextName.startsWith("/")) {
                servletContextName = servletContextName.substring(1);
            }
            try {
                BeanLocator beanLocator = PortletBeanLocatorUtil.getBeanLocator((String)servletContextName);
                velocityTemplateContent = ContentUtil.get(beanLocator.getClassLoader(), PropsUtil.get((String)("renderer.template." + className)));
            }
            catch (Exception exception) {}
        }
        if (Validator.isNull(velocityTemplateContent)) {
            try {
                velocityTemplateContent = PrefsPropsUtil.getContent(companyId, "renderer.template." + className);
            }
            catch (Exception exception) {}
        }
        if (Validator.isNull(velocityTemplateContent)) {
            _log.warn((Object)("No entity renderer template found for " + className));
            return null;
        }
        VelocityContext velocityContext = VelocityEngineUtil.getWrappedStandardToolsContext();
        try {
            VelocityVariables.insertVariables(velocityContext, request);
        }
        catch (Exception e) {
            throw new RendererException((Throwable)e);
        }
        velocityContext.put(_BEAN, bean);
        try {
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
            VelocityEngineUtil.mergeTemplate((String)className, (String)velocityTemplateContent, (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
            return unsyncStringWriter.toString();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RendererException((Throwable)e);
        }
    }

    public String renderBean(PortletRequest portletRequest, PortletResponse portletResponse, Object bean) throws RendererException {
        return this.renderBean(portletRequest, portletResponse, null, bean, null);
    }

    public String renderBean(PortletRequest portletRequest, PortletResponse portletResponse, Object bean, String varientSuffix) throws RendererException {
        return this.renderBean(portletRequest, portletResponse, null, bean, varientSuffix);
    }

    public String renderBean(PortletRequest portletRequest, PortletResponse portletResponse, String servletContextName, Object bean) throws RendererException {
        return this.renderBean(portletRequest, portletResponse, servletContextName, bean, null);
    }

    public String renderBean(PortletRequest portletRequest, PortletResponse portletResponse, String servletContextName, Object bean, String varientSuffix) throws RendererException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
        return this.renderBean(request, response, servletContextName, bean, varientSuffix);
    }

    public String renderEntity(HttpServletRequest request, HttpServletResponse response, String className, Object classPK) throws RendererException {
        return this.renderEntity(request, response, null, className, classPK, null);
    }

    public String renderEntity(HttpServletRequest request, HttpServletResponse response, String className, Object classPK, String varientSuffix) throws RendererException {
        return this.renderEntity(request, response, null, className, classPK, varientSuffix);
    }

    public String renderEntity(HttpServletRequest request, HttpServletResponse response, String servletContextName, String className, Object classPK) throws RendererException {
        return this.renderEntity(request, response, servletContextName, className, classPK, null);
    }

    public String renderEntity(HttpServletRequest request, HttpServletResponse response, String servletContextName, String className, Object classPK, String varientSuffix) throws RendererException {
        if (Validator.isNull((String)className)) {
            return null;
        }
        className = this._normalizeClassName(className);
        String[] beanNameParts = StringUtil.split((String)className, (String)_MODEL);
        Object serviceBean = null;
        if (Validator.isNotNull((String)servletContextName)) {
            if (servletContextName.startsWith("/")) {
                servletContextName = servletContextName.substring(1);
            }
            try {
                serviceBean = PortletBeanLocatorUtil.locate((String)servletContextName, (String)(String.valueOf(beanNameParts[0]) + _SERVICE + beanNameParts[1] + _LOCAL_SERVICE_UTIL));
            }
            catch (BeanLocatorException beanLocatorException) {}
        } else {
            try {
                serviceBean = PortalBeanLocatorUtil.locate((String)(String.valueOf(beanNameParts[0]) + _SERVICE + beanNameParts[1] + _LOCAL_SERVICE_UTIL));
            }
            catch (BeanLocatorException beanLocatorException) {}
        }
        Object bean = null;
        if (serviceBean != null) {
            Method getMethod = null;
            try {
                getMethod = serviceBean.getClass().getDeclaredMethod("get" + beanNameParts[1], classPK.getClass());
            }
            catch (Exception exception) {}
            if (getMethod == null) {
                try {
                    getMethod = serviceBean.getClass().getDeclaredMethod("get" + beanNameParts[1], this._mapToPrimitive(classPK.getClass()));
                }
                catch (Exception exception) {}
            }
            if (getMethod != null) {
                try {
                    bean = getMethod.invoke(null, classPK);
                }
                catch (Exception e) {
                    _log.warn((Object)e.getMessage());
                }
            }
        }
        return this.renderBean(request, response, servletContextName, bean, varientSuffix);
    }

    public String renderEntity(PortletRequest portletRequest, PortletResponse portletResponse, String className, Object classPK) throws RendererException {
        return this.renderEntity(portletRequest, portletResponse, null, className, classPK, null);
    }

    public String renderEntity(PortletRequest portletRequest, PortletResponse portletResponse, String className, Object classPK, String varientSuffix) throws RendererException {
        return this.renderEntity(portletRequest, portletResponse, null, className, classPK, varientSuffix);
    }

    public String renderEntity(PortletRequest portletRequest, PortletResponse portletResponse, String servletContextName, String className, Object classPK) throws RendererException {
        return this.renderEntity(portletRequest, portletResponse, servletContextName, className, classPK, null);
    }

    public String renderEntity(PortletRequest portletRequest, PortletResponse portletResponse, String servletContextName, String className, Object classPK, String varientSuffix) throws RendererException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)portletResponse);
        return this.renderEntity(request, response, servletContextName, className, classPK, varientSuffix);
    }

    protected PortletPreferences _getPortletPreferences(HttpServletRequest request) {
        PortletPreferences preferences = PortalUtil.getPreferences((HttpServletRequest)request);
        String portletResource = ParamUtil.getString((HttpServletRequest)request, (String)"portletResource");
        if (Validator.isNotNull((String)portletResource)) {
            try {
                preferences = PortletPreferencesFactoryUtil.getPortletSetup((HttpServletRequest)request, (String)portletResource);
            }
            catch (SystemException systemException) {}
        }
        return preferences;
    }

    protected Class<?> _mapToPrimitive(Class<?> clazz) {
        Class<Object> mapping = clazz;
        if (clazz == Integer.class) {
            mapping = Integer.TYPE;
        } else if (clazz == Long.class) {
            mapping = Long.TYPE;
        }
        return mapping;
    }

    protected String _normalizeClassName(String className) {
        className = StringUtil.replace((String)className, (String[])new String[]{".impl.", "Impl"}, (String[])new String[]{".", ""});
        return className;
    }
}

