/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.portal.bean.VelocityBeanHandler;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;

public class BeanLocatorImpl
implements BeanLocator {
    public static final String VELOCITY_SUFFIX = ".velocity";
    private static Log _log = LogFactoryUtil.getLog(BeanLocatorImpl.class);
    private ClassLoader _classLoader;
    private ApplicationContext _applicationContext;
    private Map<String, Object> _velocityBeans = new ConcurrentHashMap<String, Object>();

    public BeanLocatorImpl(ClassLoader classLoader, ApplicationContext applicationContext) {
        this._classLoader = classLoader;
        this._applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public Object locate(String name) throws BeanLocatorException {
        try {
            return this.doLocate(name);
        }
        catch (Exception e) {
            throw new BeanLocatorException((Throwable)e);
        }
    }

    protected Object doLocate(String name) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Locating " + name));
        }
        if (name.endsWith(VELOCITY_SUFFIX)) {
            Object bean = this._velocityBeans.get(name);
            if (bean == null) {
                String originalName = name.substring(0, name.length() - VELOCITY_SUFFIX.length());
                bean = this._applicationContext.getBean(originalName);
                Object[] interfaces = bean.getClass().getInterfaces();
                List interfacesList = ListUtil.fromArray((Object[])interfaces);
                Iterator itr = interfacesList.iterator();
                while (itr.hasNext()) {
                    Class classObj = (Class)itr.next();
                    try {
                        this._classLoader.loadClass(classObj.getName());
                    }
                    catch (Exception exception) {
                        itr.remove();
                    }
                }
                bean = Proxy.newProxyInstance(this._classLoader, interfacesList.toArray(new Class[interfacesList.size()]), (InvocationHandler)new VelocityBeanHandler(bean, this._classLoader));
                this._velocityBeans.put(name, bean);
            }
            return bean;
        }
        return this._applicationContext.getBean(name);
    }
}

