/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.util;

import com.liferay.documentlibrary.DuplicateDirectoryException;
import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.documentlibrary.model.FileModel;
import com.liferay.documentlibrary.util.BaseHook;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class FileSystemHook
extends BaseHook {
    private static final String _ROOT_DIR = PropsUtil.get("dl.hook.file.system.root.dir");
    private File _rootDir = new File(_ROOT_DIR);

    public FileSystemHook() {
        if (!this._rootDir.exists()) {
            this._rootDir.mkdirs();
        }
    }

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (dirNameDir.exists()) {
            throw new DuplicateDirectoryException(dirNameDir.getPath());
        }
        dirNameDir.mkdirs();
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, InputStream is) throws PortalException, SystemException {
        try {
            File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, "1.0");
            if (fileNameVersionFile.exists()) {
                throw new DuplicateFileException(fileNameVersionFile.getPath());
            }
            FileUtil.write((File)fileNameVersionFile, (InputStream)is);
            Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
            FileModel fileModel = new FileModel();
            fileModel.setAssetCategoryIds(serviceContext.getAssetCategoryIds());
            fileModel.setAssetTagNames(serviceContext.getAssetTagNames());
            fileModel.setCompanyId(companyId);
            fileModel.setFileEntryId(fileEntryId);
            fileModel.setFileName(fileName);
            fileModel.setGroupId(groupId);
            fileModel.setModifiedDate(modifiedDate);
            fileModel.setPortletId(portletId);
            fileModel.setProperties(properties);
            fileModel.setRepositoryId(repositoryId);
            indexer.reindex((Object)fileModel);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void checkRoot(long companyId) {
    }

    public void deleteDirectory(long companyId, String portletId, long repositoryId, String dirName) throws PortalException {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (!dirNameDir.exists()) {
            throw new NoSuchDirectoryException(dirNameDir.getPath());
        }
        FileUtil.deltree((File)dirNameDir);
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName) throws PortalException {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            throw new NoSuchFileException(fileNameDir.getPath());
        }
        FileUtil.deltree((File)fileNameDir);
        FileModel fileModel = new FileModel();
        fileModel.setCompanyId(companyId);
        fileModel.setFileName(fileName);
        fileModel.setPortletId(portletId);
        fileModel.setRepositoryId(repositoryId);
        Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
        indexer.delete((Object)fileModel);
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName, String versionNumber) throws PortalException {
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionNumber);
        if (!fileNameVersionFile.exists()) {
            throw new NoSuchFileException(fileNameVersionFile.getPath());
        }
        fileNameVersionFile.delete();
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionNumber) throws PortalException, SystemException {
        try {
            File fileNameVersionFile;
            if (Validator.isNull((String)versionNumber)) {
                versionNumber = this.getHeadVersionNumber(companyId, repositoryId, fileName);
            }
            if (!(fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionNumber)).exists()) {
                throw new NoSuchFileException(fileNameVersionFile.getPath());
            }
            return new FileInputStream(fileNameVersionFile);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (!dirNameDir.exists()) {
            throw new NoSuchDirectoryException(dirNameDir.getPath());
        }
        Object[] fileNames = FileUtil.listDirs((File)dirNameDir);
        Arrays.sort(fileNames);
        int i = 0;
        while (i < fileNames.length) {
            fileNames[i] = "/" + dirName + "/" + (String)fileNames[i];
            ++i;
        }
        return fileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        String versionNumber = this.getHeadVersionNumber(companyId, repositoryId, fileName);
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionNumber);
        if (!fileNameVersionFile.exists()) {
            throw new NoSuchFileException(fileNameVersionFile.getPath());
        }
        return fileNameVersionFile.length();
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionNumber) {
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionNumber);
        return fileNameVersionFile.exists();
    }

    public void move(String srcDir, String destDir) {
    }

    public void reindex(String[] ids) throws SearchException {
        long companyId = GetterUtil.getLong((String)ids[0]);
        String portletId = ids[1];
        long groupId = GetterUtil.getLong((String)ids[2]);
        long repositoryId = GetterUtil.getLong((String)ids[3]);
        ArrayList<Document> documents = new ArrayList<Document>();
        File repistoryDir = this.getRepositoryDir(companyId, repositoryId);
        String[] fileNames = FileUtil.listDirs((File)repistoryDir);
        int i = 0;
        while (i < fileNames.length) {
            String fileName = fileNames[i];
            Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
            FileModel fileModel = new FileModel();
            fileModel.setCompanyId(companyId);
            fileModel.setFileName(fileName);
            fileModel.setGroupId(groupId);
            fileModel.setPortletId(portletId);
            fileModel.setRepositoryId(repositoryId);
            Document document = indexer.getDocument((Object)fileModel);
            if (document != null) {
                documents.add(document);
            }
            ++i;
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, long newRepositoryId, String fileName, long fileEntryId) throws PortalException {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        File newFileNameDir = this.getFileNameDir(companyId, newRepositoryId, fileName);
        FileUtil.copyDirectory((File)fileNameDir, (File)newFileNameDir);
        FileUtil.deltree((File)fileNameDir);
        Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
        FileModel fileModel = new FileModel();
        fileModel.setCompanyId(companyId);
        fileModel.setFileName(fileName);
        fileModel.setPortletId(portletId);
        fileModel.setRepositoryId(repositoryId);
        indexer.delete((Object)fileModel);
        fileModel.setRepositoryId(newRepositoryId);
        fileModel.setGroupId(groupId);
        indexer.reindex((Object)fileModel);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String newFileName, boolean reindex) throws PortalException {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        File newFileNameDir = this.getFileNameDir(companyId, repositoryId, newFileName);
        FileUtil.copyDirectory((File)fileNameDir, (File)newFileNameDir);
        FileUtil.deltree((File)fileNameDir);
        if (reindex) {
            Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
            FileModel fileModel = new FileModel();
            fileModel.setCompanyId(companyId);
            fileModel.setFileName(fileName);
            fileModel.setPortletId(portletId);
            fileModel.setRepositoryId(repositoryId);
            indexer.delete((Object)fileModel);
            fileModel.setFileName(newFileName);
            fileModel.setGroupId(groupId);
            indexer.reindex((Object)fileModel);
        }
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, InputStream is) throws PortalException, SystemException {
        try {
            File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionNumber);
            if (fileNameVersionFile.exists()) {
                throw new DuplicateFileException(fileNameVersionFile.getPath());
            }
            FileUtil.write((File)fileNameVersionFile, (InputStream)is);
            Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
            FileModel fileModel = new FileModel();
            fileModel.setAssetCategoryIds(serviceContext.getAssetCategoryIds());
            fileModel.setAssetTagNames(serviceContext.getAssetTagNames());
            fileModel.setCompanyId(companyId);
            fileModel.setFileEntryId(fileEntryId);
            fileModel.setFileName(fileName);
            fileModel.setGroupId(groupId);
            fileModel.setModifiedDate(modifiedDate);
            fileModel.setPortletId(portletId);
            fileModel.setProperties(properties);
            fileModel.setRepositoryId(repositoryId);
            indexer.reindex((Object)fileModel);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected File getCompanyDir(long companyId) {
        File companyDir = new File(this._rootDir + "/" + companyId);
        if (!companyDir.exists()) {
            companyDir.mkdirs();
        }
        return companyDir;
    }

    protected File getDirNameDir(long companyId, long repositoryId, String dirName) {
        return this.getFileNameDir(companyId, repositoryId, dirName);
    }

    protected File getFileNameDir(long companyId, long repositoryId, String fileName) {
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        File fileNameDir = new File(repositoryDir + "/" + fileName);
        return fileNameDir;
    }

    protected File getFileNameVersionFile(long companyId, long repositoryId, String fileName, String version) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        File fileNameVersionFile = new File(fileNameDir + "/" + version);
        return fileNameVersionFile;
    }

    protected String getHeadVersionNumber(long companyId, long repositoryId, String fileName) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            return "1.0";
        }
        String[] versionNumbers = FileUtil.listFiles((File)fileNameDir);
        String headVersionNumber = "1.0";
        String[] stringArray = versionNumbers;
        int n = versionNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            String versionNumber = stringArray[n2];
            if (DLUtil.compareVersions((String)versionNumber, (String)headVersionNumber) > 0) {
                headVersionNumber = versionNumber;
            }
            ++n2;
        }
        return headVersionNumber;
    }

    protected File getRepositoryDir(long companyId, long repositoryId) {
        File companyDir = this.getCompanyDir(companyId);
        File repositoryDir = new File(companyDir + "/" + repositoryId);
        if (!repositoryDir.exists()) {
            repositoryDir.mkdirs();
        }
        return repositoryDir;
    }
}

