/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.xrds;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.xrds.XrdsParser;
import org.openid4java.discovery.xrds.XrdsServiceEndpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XrdsParserImpl
implements XrdsParser {
    private static final Log _log = LogFactory.getLog(XrdsParserImpl.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String XRDS_SCHEMA = "xrds.xsd";
    private static final String XRD_SCHEMA = "xrd.xsd";
    private static final String XRD_NS = "xri://$xrd*($v*2.0)";
    private static final String XRD_ELEM_XRD = "XRD";
    private static final String XRD_ELEM_TYPE = "Type";
    private static final String XRD_ELEM_URI = "URI";
    private static final String XRD_ELEM_LOCALID = "LocalID";
    private static final String XRD_ELEM_CANONICALID = "CanonicalID";
    private static final String XRD_ATTR_PRIORITY = "priority";
    private static final String OPENID_NS = "http://openid.net/xmlns/1.0";
    private static final String OPENID_ELEM_DELEGATE = "Delegate";

    public List parseXrds(String input, Set targetTypes) throws DiscoveryException {
        Node serviceNode;
        Node lastXRD;
        Document document;
        NodeList XRDs;
        if (DEBUG) {
            _log.debug((Object)("Parsing XRDS input for service types: " + targetTypes.toString()));
        }
        if ((XRDs = (document = this.parseXmlInput(input)).getElementsByTagNameNS(XRD_NS, XRD_ELEM_XRD)).getLength() < 1 || (lastXRD = XRDs.item(XRDs.getLength() - 1)) == null) {
            throw new DiscoveryException("No XRD elements found.");
        }
        String canonicalId = null;
        NodeList canonicalIDs = document.getElementsByTagNameNS(XRD_NS, XRD_ELEM_CANONICALID);
        for (int i = 0; i < canonicalIDs.getLength(); ++i) {
            Node canonicalIdNode = canonicalIDs.item(i);
            if (canonicalIdNode.getParentNode() != lastXRD) continue;
            if (canonicalId != null) {
                throw new DiscoveryException("More than one Canonical ID found.");
            }
            canonicalId = canonicalIdNode.getFirstChild() != null && canonicalIdNode.getFirstChild().getNodeType() == 3 ? canonicalIdNode.getFirstChild().getNodeValue() : null;
        }
        NodeList types = document.getElementsByTagNameNS(XRD_NS, XRD_ELEM_TYPE);
        HashMap serviceTypes = new HashMap();
        HashSet<Node> selectedServices = new HashSet<Node>();
        for (int i = 0; i < types.getLength(); ++i) {
            String type;
            Node typeNode = types.item(i);
            String string = type = typeNode != null && typeNode.getFirstChild() != null && typeNode.getFirstChild().getNodeType() == 3 ? typeNode.getFirstChild().getNodeValue() : null;
            if (type == null || (serviceNode = typeNode.getParentNode()).getParentNode() != lastXRD) continue;
            if (targetTypes.contains(type)) {
                selectedServices.add(serviceNode);
            }
            this.addServiceType(serviceTypes, serviceNode, type);
        }
        if (DEBUG) {
            _log.debug((Object)("Found " + serviceTypes.size() + " services for the requested types."));
        }
        Map serviceLocalIDs = this.extractElementsByParent(XRD_NS, XRD_ELEM_LOCALID, selectedServices, document);
        Map serviceDelegates = this.extractElementsByParent(OPENID_NS, OPENID_ELEM_DELEGATE, selectedServices, document);
        ArrayList<XrdsServiceEndpoint> result = new ArrayList<XrdsServiceEndpoint>();
        NodeList uris = document.getElementsByTagNameNS(XRD_NS, XRD_ELEM_URI);
        for (int i = 0; i < uris.getLength(); ++i) {
            Node uriNode = uris.item(i);
            if (uriNode == null || !selectedServices.contains(uriNode.getParentNode())) continue;
            String uri = uriNode.getFirstChild() != null && uriNode.getFirstChild().getNodeType() == 3 ? uriNode.getFirstChild().getNodeValue() : null;
            serviceNode = uriNode.getParentNode();
            Set typeSet = (Set)serviceTypes.get(serviceNode);
            String localId = (String)serviceLocalIDs.get(serviceNode);
            String delegate = (String)serviceDelegates.get(serviceNode);
            XrdsServiceEndpoint endpoint = new XrdsServiceEndpoint(uri, typeSet, this.getPriority(serviceNode), this.getPriority(uriNode), localId, delegate, canonicalId);
            if (DEBUG) {
                _log.debug((Object)("Discovered endpoint: \n" + endpoint));
            }
            result.add(endpoint);
        }
        Collections.sort(result);
        return result;
    }

    private Map extractElementsByParent(String ns, String elem, Set parents, Document document) {
        HashMap<Node, String> result = new HashMap<Node, String>();
        NodeList nodes = document.getElementsByTagNameNS(ns, elem);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node == null || !parents.contains(node.getParentNode())) continue;
            String localId = node.getFirstChild() != null && node.getFirstChild().getNodeType() == 3 ? node.getFirstChild().getNodeValue() : null;
            result.put(node.getParentNode(), localId);
        }
        return result;
    }

    private int getPriority(Node node) {
        if (node.hasAttributes()) {
            Node priority = node.getAttributes().getNamedItem(XRD_ATTR_PRIORITY);
            if (priority != null) {
                return Integer.parseInt(priority.getNodeValue());
            }
            return -1;
        }
        return 0;
    }

    private Document parseXmlInput(String input) throws DiscoveryException {
        if (input == null) {
            throw new DiscoveryException("Cannot read XML message", 1804);
        }
        if (DEBUG) {
            _log.debug((Object)("Parsing XRDS input: " + input));
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            dbf.setAttribute(JAXP_SCHEMA_SOURCE, new Object[]{Discovery.class.getResourceAsStream(XRD_SCHEMA), Discovery.class.getResourceAsStream(XRDS_SCHEMA)});
            DocumentBuilder builder = dbf.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            return builder.parse(new ByteArrayInputStream(input.getBytes()));
        }
        catch (ParserConfigurationException e) {
            throw new DiscoveryException("Parser configuration error", 1805, e);
        }
        catch (SAXException e) {
            throw new DiscoveryException("Error parsing XML document", 1805, e);
        }
        catch (IOException e) {
            throw new DiscoveryException("Error reading XRDS document", 1804, e);
        }
    }

    private void addServiceType(Map serviceTypes, Node serviceNode, String type) {
        HashSet<String> types = (HashSet<String>)serviceTypes.get(serviceNode);
        if (types == null) {
            types = new HashSet<String>();
            serviceTypes.put(serviceNode, types);
        }
        types.add(type);
    }
}

