/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import com.liferay.portal.model.Company;
import com.liferay.portal.service.CompanyLocalServiceUtil;

public class CompanyThreadLocal {
    private static Log _log = LogFactoryUtil.getLog(CompanyThreadLocal.class);
    private static ThreadLocal<Long> _companyId = new AutoResetThreadLocal<Long>(CompanyThreadLocal.class + "._companyId", 0L);

    public static long getCompanyId() {
        long companyId = _companyId.get();
        if (_log.isDebugEnabled()) {
            _log.debug("getCompanyId " + companyId);
        }
        return companyId;
    }

    public static void setCompanyId(long companyId) {
        if (_log.isDebugEnabled()) {
            _log.debug("setCompanyId " + companyId);
        }
        if (companyId > 0L) {
            try {
                Company company = CompanyLocalServiceUtil.getCompany(companyId);
                LocaleThreadLocal.setLocale(company.getLocale());
                TimeZoneThreadLocal.setTimeZone(company.getTimeZone());
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            _companyId.set(companyId);
        } else {
            LocaleThreadLocal.setLocale(null);
            TimeZoneThreadLocal.setTimeZone(null);
            _companyId.set(0L);
        }
    }
}

