/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetUtil {
    public static <E> Set<E> fromArray(E[] array) {
        if (array == null || array.length == 0) {
            return new HashSet();
        }
        HashSet<E> set = new HashSet<E>(array.length);
        int i = 0;
        while (i < array.length) {
            set.add(array[i]);
            ++i;
        }
        return set;
    }

    public static Set<Long> fromArray(long[] array) {
        if (array == null || array.length == 0) {
            return new HashSet<Long>();
        }
        HashSet<Long> set = new HashSet<Long>(array.length);
        int i = 0;
        while (i < array.length) {
            set.add(array[i]);
            ++i;
        }
        return set;
    }

    public static <E> Set<E> fromCollection(Collection<E> c) {
        if (c != null && Set.class.isAssignableFrom(c.getClass())) {
            return (Set)c;
        }
        if (c == null || c.size() == 0) {
            return new HashSet();
        }
        return new HashSet<E>(c);
    }

    public static <E> Set<E> fromEnumeration(Enumeration<E> enu) {
        HashSet<E> set = new HashSet<E>();
        while (enu.hasMoreElements()) {
            set.add(enu.nextElement());
        }
        return set;
    }

    public static Set<String> fromFile(File file) throws IOException {
        HashSet<String> set = new HashSet<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new FileReader(file));
        String s = "";
        while ((s = unsyncBufferedReader.readLine()) != null) {
            set.add(s);
        }
        unsyncBufferedReader.close();
        return set;
    }

    public static Set<String> fromFile(String fileName) throws IOException {
        return SetUtil.fromFile(new File(fileName));
    }

    public static <E> Set<E> fromIterator(Iterator<E> itr) {
        HashSet<E> set = new HashSet<E>();
        while (itr.hasNext()) {
            set.add(itr.next());
        }
        return set;
    }

    public static <E> Set<E> fromList(List<E> array) {
        if (array == null || array.size() == 0) {
            return new HashSet();
        }
        return new HashSet<E>(array);
    }

    public static Set<String> fromString(String s) {
        return SetUtil.fromArray(StringUtil.split(s, "\n"));
    }
}

