/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;

public abstract class BasePortalLifecycle
implements PortalLifecycle {
    private static Log _log = LogFactoryUtil.getLog(BasePortalLifecycle.class);
    private boolean _calledPortalDestroy;

    public void portalDestroy() {
        if (!this._calledPortalDestroy) {
            PortalLifecycleUtil.removeDestroy(this);
            try {
                this.doPortalDestroy();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            this._calledPortalDestroy = true;
        }
    }

    public void portalInit() {
        try {
            this.doPortalInit();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    public void registerPortalLifecycle() {
        PortalLifecycleUtil.register(this);
    }

    protected abstract void doPortalDestroy() throws Exception;

    protected abstract void doPortalInit() throws Exception;
}

